local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "window.editor.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local IsInTransitionCommand = CommandBase:extend("IsInTransitionCommand");

function IsInTransitionCommand:new(uuid, transition_id)
    IsInTransitionCommand.super.new(self);
    self._uuid = uuid;
    self._transition_id = transition_id;
    self._isTransition = false;
end

function IsInTransitionCommand:DoIt()
    local ret = false;
    self:BeginCmd();
    if self._uuid then
      local ani = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
      if ani then
        self._isTransition = ani:IsInTransition(0, self._transition_id);
      end
    end
    self:EndCmd();
end

function IsInTransitionCommand:Undo()
    self:BeginCmd();
    self:EndCmd();
end

return IsInTransitionCommand;