local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local brightnessfilter = {}
brightnessfilter.BfMat = 0;
brightnessfilter.Queue = 109;



function brightnessfilter:Initialize(host, size)
    --<!--  set the offsets parameters in vertex shader -->
  self.BRIGHTNESS = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"BRIGHTNESS");
  self.BfMat = host:CreateMaterial("comm:documents/filter/material/brightnessfilter.material" );
  self.BfRO = host:CreateRenderObject()
  self.BfMat:SetParameter(self.BRIGHTNESS, mathfunction.vector1(0.0));
  --self:_SetParam(size);
  return self.Queue;
end

function brightnessfilter:Resizeview(size)
  --self:_SetParam(size);
end

function brightnessfilter:Process(context, Original, Scene, Output)
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.BfMat:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.BfRO, self.BfMat);
  context:EndRenderPass();
end

return brightnessfilter;