-- 关卡蓝图 level script
local BP = require "bluecore.blueprint"
local BFL = require "bluecore.core.blue_ftn_lib"
local BlueScene = BP:extend("BlueScene");
local BlueRtti = require "bluecore.core.blue_rtti"

BlueScene:MemberRegister("_libMap")

function BlueScene:new(...)
  BlueScene.super.new(self, ...)

  WARNING("BlueScene created");

  -- { key: _LibId, value: BlueFtnLib }
  self._libMap = { }

end

-- true name is available
function BlueScene:TryNameEd(name)
  for uid, lib in pairs(self._libMap) do
    local _name = lib:GetLibName()
    if _name == name then
      return false ;
    end
  end
  return true ;
end


function BlueScene:AddLibEd(name, uid)

  if not self:TryNameEd(name) then ERROR("[AddLibEd] name redefined "..tostring(name)); return false; end
  if self._libMap[uid] ~= nil  then ERROR("[AddLibEd] uid conflict "..tostring(uid));  return false; end

  local bfLib = BFL(name, uid);
  bfLib:CreateByEd();

  self._libMap[uid] = bfLib;

  return true
end

function BlueScene:InsertLibEd(bfLib) --导入时候插入
  if not self:TryNameEd(bfLib:GetLibName()) then ERROR("[AddLibEd] name redefined "..tostring(bfLib:GetLibName())); return false; end
  if self._libMap[bfLib:GetLibId()] ~= nil  then ERROR("[AddLibEd] uid conflict "..tostring(bfLib:GetLibId()));  return false; end
  
  self._libMap[bfLib:GetLibId()] = bfLib;
  -- body
end

-- check ftnName conflict in editor
function BlueScene:CreateFunctionForLibraryEd(libUid, ftnName, ftnUid)

  local blueFtnLib = self._libMap[libUid] ;
  if blueFtnLib == nil then ERROR("library not exist "..tostring(libUid)); return false ; end

  if blueFtnLib:IsConflictUidEd(ftnUid) then ERROR("function library id conflict "..tostring(ftnUid)); return false ; end

  local BlueFunction = require "bluecore.bluefunction"
  local blueFunc = BlueFunction(nil, ftnName, ftnUid);
  blueFunc:EditorCreate();
  blueFunc:_OnAwake(self.Node); -- 库全局函数与场景无直接关系 但需要从rootNode获取函数
  blueFunc:SetupPresetNode();
  blueFtnLib:AddFtnEd(ftnUid, blueFunc);

  return blueFunc;
end

function BlueScene:DeleteFunctionForLibraryEd(libUid, ftnUid)

  local blueFtnLib = self._libMap[libUid] ;
  if blueFtnLib == nil then
    ERROR("DeleteFunctionForLibraryEd library not found "..tostring(libUid));
    return false
  end

  return blueFtnLib:DelFtnEd(ftnUid);

end

-- true : uid is occupied
function BlueScene:IsConflictUidEd(uid)
  return self._libMap[uid] ~= nil
end

function BlueScene:ChgLibNameEd(oldName, newName)

  local bfLib = nil

  for uid, lib in pairs(self._libMap) do
    local _name = lib:GetLibName()
    if _name == oldName then
      bfLib = lib
    end
    if _name == newName then
      ERROR("conflict library name:"..tostring(newName));
      return false ;
    end
  end

  if not bfLib  then
    ERROR("library not found:"..tostring(oldName));
  end

  bfLib:ChgLibName(newName);
  return true ;

end

function BlueScene:FoundReferEd(name)

  for uid, lib in pairs(self._libMap) do
    local _name = lib:GetLibName()
    if name == _name then
       --  FIXME(hhl) 再删除函数库的前 要交互提醒
    end
  end

end

function BlueScene:DeleteLibEd(name)
  for uid, lib in pairs(self._libMap) do
    local _name = lib:GetLibName()
    if name == _name then
      self._libMap[uid]:DeleteLibEd();
      self._libMap[uid] = nil
      return true
    end
  end
  ERROR("library not found "..name);
  return false

end

function BlueScene:SetLibsEd(libMap)
  if next(self._libMap) ~= nil then
    error("BlueScene _libMap not empty");
  else
    self._libMap = libMap
  end
end

function BlueScene:GetLibs()
  return self._libMap
end

-- 仅仅用于反序列化场景和perfab时候使用
function BlueScene:AppendLib(name, bfLib)

  -- FIXME(hhl) 多个perfab使用同一个蓝图类 可能实际对应的函数库是不一样的
  -- FIXME(hhl) 暂时处理方式: 使用最后一个
  for uid, lib in pairs(self._libMap) do
    local _name = lib:GetLibName()
    if name == _name then
      ERROR("library name conflict, use last one");
      --return false
    end
  end

  self._libMap[bfLib:GetLibId()] = bfLib;

  return true ;
end

function BlueScene:CompileCode(isPrefabMode)
  -- just for debug
  return BlueScene.super.CompileCode(self, isPrefabMode)
end


function BlueScene:_OnUpdate(def)
  -- just for debug
  --WARNING("------------BlueScene:_OnUpdate---------- ");
  BlueScene.super._OnUpdate(self, def)
end


function BlueScene:Run()
  BlueScene.super.Run(self)
  -- add library 最后才Run全局函数
  for libUid, lib in pairs(self._libMap) do
     lib:Run()
  end
end


function BlueScene:Stop()

  if not self.isrunning then LOG("BlueScene stop yet"); return ; end

  BlueScene.super.Stop(self)

  for libUid, lib in pairs(self._libMap) do
    lib:Stop()
  end
end

function BlueScene:SyncEd()

  -- 全局函数库不依赖其他,所以可以在场景蓝图同时Sync
  for libUid, lib in pairs(self._libMap) do
    lib:SyncEd()
  end

  -- 先同步库,再同步场景蓝图(目前顺序无关)
  BlueScene.super.SyncEd(self)

end

function BlueScene:_OnAwake()
  WARNING("------------BlueScene _OnAwake---------- ");
  self:_AwakeProcess();
  for _, blueFtnLib in pairs(self._libMap) do
    blueFtnLib:_OnAwake(self.Node);
  end
end

function BlueScene:_OnDeserialize()
  WARNING("------------BlueScene _OnDeserialize---------- ");
  self:_SetupBlueprintClass();
end

function BlueScene:EditorCreate()
  WARNING("------------BlueScene EditorCreate---------- ");
  self:_SetupBlueprintClass();
end

function BlueScene:_SetupBlueprintClass()
  -- 场景蓝图也加入到蓝图类型列表,支持场景蓝图创建自定义事件和事件分发器
  BlueRtti.RegisterClassAddRef(self);
  local blueprintType = BlueRtti.GetRttiByClsId(self:GetClassId())
  if blueprintType == nil then
    error("BlueScene _OnDeserialize Fail "..self:GetClassId())
  end
  blueprintType:SetSceneFlag()
end


function BlueScene:CompileCode(isPrefabMode)
  local result = true
  self.errorMessage = nil;
  for libUid, lib in pairs(self._libMap) do
    local libCompileResult = lib:CompileCode(isPrefabMode);
    result = libCompileResult and result;
    if not libCompileResult then
      local errorMess = lib:GetErrorMessage();
      self.errorMessage = self.errorMessage and self.errorMessage.."\n\n\t\t\t\t\t"..errorMess or errorMess;
    end
  end
  --函数库出问题停止编译
  return result and BlueScene.super.CompileCode(self, isPrefabMode)
end


function BlueScene:_OnDestroy()
  BlueScene.super._OnDestroy(self)
  self._libMap = nil
  WARNING("BlueScene _OnDestroy");
end


return BlueScene
