local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local mf = require "mathfunction"
local Vector1ToFloat = BlueNode:extend();

---- 游戏运行模式
function Vector1ToFloat:new(...)
  Vector1ToFloat.super.new(self, ...)
end

function Vector1ToFloat:_OnUpdate(args)
  if args[1] == nil then
    return 0.0;
  else
    return args[1].mx;
  end 

end

---- 编辑器模式
Vector1ToFloat:RegisterInput(1, mf.vector1:RTTI(), "vector1", "一维向量", mf.vector1(0.0));
Vector1ToFloat:RegisterOutput(1, Types.FloatType, "float", "浮点数");
Vector1ToFloat:SetFunctionName("vec1->float");
Vector1ToFloat:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return Vector1ToFloat ;

