local mf = require "mathfunction"
local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local BreakVector3f = BlueNode:extend();

---- 游戏运行模式
function BreakVector3f:new(...)
  BreakVector3f.super.new(self, ...)
end

function BreakVector3f:_OnUpdate(args)
  local vec3f = args[1] ;
  return vec3f:x(), vec3f:y(), vec3f:z();
end


---- 编辑器模式
BreakVector3f:RegisterInput(1, mf.vector3:RTTI(), "Vector3f Break", "拆分向量(x,y,z)", mf.vector3(0.0,0.0,0.0));
BreakVector3f:RegisterOutput(1, Types.FloatType, "x", "x 浮点");
BreakVector3f:RegisterOutput(2, Types.FloatType, "y", "y 浮点");
BreakVector3f:RegisterOutput(3, Types.FloatType, "z", "z 浮点");

BreakVector3f:SetFunctionName("Break Vector3f");
BreakVector3f:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return BreakVector3f ;