local venuscore = require "libvenuscore"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local BlueSelf = require "bluecore.blueself"
local EventDispatcher = require "bluecore.eventdispatcher"
local BD = require "bluecore.bluedefined"
local CV = require "computervisionfunction"
local BU = require "bluecore.blueutility"
local FaceExists = BlueNode:extend();

local BREAK = 0
local TRIGGER = 1
local RELEASE = 2


---- 游戏运行模式
function FaceExists:new(...)
  FaceExists.super.new(self, ...)
  self:_OnReset();
  self.faceID = 1
end

function FaceExists:_OnUpdate(args)

  self._formatOutputArray = args

  self.nextExecIdx = BREAK
  local detected = false

  if self._formatOutputArray ~= nil  then
    for _, id in pairs(self._formatOutputArray) do
      if id == self.faceID then
        detected = true
      end
    end
  end

  if detected then

    local edge = false
    if self.lastDetect == false then
      self.lastDetect = true
      edge = true
    end

    if self.isEdge and edge then
      self.nextExecIdx = TRIGGER
    elseif not self.isEdge then
      self.nextExecIdx = TRIGGER
    end

  else

    if self.lastDetect then
      self.lastDetect = false
      self.nextExecIdx = RELEASE
    end

  end

  return detected;
end

function FaceExists:_OnReset()
  self._formatOutputArray = {}
  self.lastDetect = false
  self.nextExecIdx = BREAK
end

function FaceExists:_OnNextBranch()
  return self.nextExecIdx
end


function FaceExists:RegisterTriggerFunc(func, bluePrintSelf)

  self:_GetInput()

  local comp = self.component or self.inputArgs[1]

  EventDispatcher:RegisterCallback(
          comp:GetContentPath(),
          BD.Event.VirtualEvent.HasFace,
          func,
          bluePrintSelf)

  -- 调用blueprint reset会导致所有node的inputArgs清空
  self.faceID = self.inputArgs[2]
  if self.faceID <= 0 then
    self.faceID = 1
  end

  self.isEdge = self.inputArgs[3] or false

end


function FaceExists:_OnCompile()
  self.compileResult = nil
  if FaceExists.super._OnCompile(self) then

    local comp = self.component

    -- Step.0 判断反射面板有override
    if comp ~= nil then
      if venuscore.isNil(comp) then
        self.compileResult = BD.EHINT.COMP_LOST
        return false
      end
    end

    if comp == nil then
      -- Step.1 确保Component引脚有连接
      if #self.inputs[1].links ~= 0 then
        local bluePinLink = self.inputs[1].links[1] -- 输入引脚只允许一个连接
        local otherNode = self.graph:GetNode(bluePinLink.nodeUid);

        -- Step.2 确保上一个节点是 引用组件类型 的节点
        if otherNode:GetFunctionType() == BD.COMPONENT_NODE and otherNode.comp == nil then
          self.compileResult = BD.EHINT.NOT_LINK_TO_COMP
          return false
        end

        if venuscore.isNil(otherNode.comp) then
          self.compileResult = BD.EHINT.COMP_LOST
          return false
        end

        comp = otherNode.comp

      else
        self.compileResult = BD.EHINT.PIN_1_EMPTY;
        return false
      end
    end

    -- Step.3 RecognitionComponent没有激活当前的检测类型
    local hasType = self:_HasType(comp);
    if not hasType then
      self.compileResult = BD.EHINT.NOT_ENABLE;
      return false
    end

    return true ;
  end
  return false;
end

function FaceExists:_HasType(comp)
  return bit.band(comp.Type, CV.RecognitionComponent.cvFace) ~= 0
end

function FaceExists:_OnDeserialize()

end

-- 蓝图节点反射面板相关
function FaceExists:_SetComp(comp)
  self.component = comp ;
end

function FaceExists:_GetComp()
  return self.component
end

function FaceExists:ReflectFilterFtnOnPrefab(obj, member, value)
  return member == "component"
end

function FaceExists:LiteralMismatchOnCompile(pin, pinInfo)
  if pin.argId ==  1 and BU:isBlueSelf(pin.literal) and  not venuscore.isNil(self.component) then
    return true
  end
  return false
end

FaceExists:MemberRegister("component",
        Types.ReferenceType(CV.RecognitionComponent:RTTI(),
                FaceExists._GetComp, FaceExists._SetComp));

---- 编辑器模式
if _KRATOSEDITOR then

function FaceExists:_OnLink(selfPin, otherNode, otherPin)
  if BU:IsInputPin(selfPin) and selfPin.argId == 1 then
    if otherNode:GetFunctionType() == BD.COMPONENT_NODE and otherNode.comp then
      if venuscore.isNil(otherNode.comp) then
        ERROR(BD.EHINT.COMP_LOST)
      else
        local hasType = self:_HasType(otherNode.comp);
        if not hasType then
          ERROR(BD.EHINT.NOT_ENABLE)
        end
      end
    else
      ERROR(BD.EHINT.NOT_LINK_TO_COMP)
    end
  end
end

function FaceExists:_OnUnLink(unlinkPin)
  if unlinkPin.argId == 1 then
     ERROR(BD.EHINT.PIN_1_EMPTY)
  end
end

function FaceExists:_OnCreateWithEditor()
  FaceExists.super._OnCreateWithEditor(self);
end

function FaceExists:_OnUpdateByEditor()
  FaceExists.super._OnUpdateByEditor(self);
  self:_OnCompile();
end

end

FaceExists:RegisterInput(1, CV.RecognitionComponent:RTTI(), "component", "监听组件", BlueSelf());
FaceExists:RegisterInput(2, Types.IntType, "index", "face index(从1开始)", 1);
FaceExists:RegisterInput(3, Types.BoolType, "isEdge", "从无到有触发一次(OnTrigger)", false);

FaceExists:RegisterOutput(1, Types.BoolType, "hasFace", "有人脸?");

FaceExists:RegisterExecOutput(TRIGGER, "OnTrigger", "execute");
FaceExists:RegisterExecOutput(RELEASE, "OnRelease", "execute");

FaceExists:SetFunctionName("Has Face?");
FaceExists:SetFunctionType(BD.EVENT_FUNCTION_NODE);
FaceExists:SetEventType(BD.EventType.RegisterCallback);

return FaceExists;
