local BlueNode = require "bluecore.bluenode"
local EventDispatcher = require "bluecore.eventdispatcher"
local BlueDefined = require "bluecore.bluedefined"
local apolloengine = require "apolloengine"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"
local OnFrameAniEnd = BlueNode:extend();

---- 游戏运行模式
function OnFrameAniEnd:new(...)
  OnFrameAniEnd.super.new(self, ...)
  self.edge = true;
end

function OnFrameAniEnd:_OnUpdate(eventParam)
  self.output = eventParam
end

function OnFrameAniEnd:_OnNextBranch() --Update函数调用
  if self.edge and not self.output.isEdge then 
    return 0
  else
    return 1
  end
end

function OnFrameAniEnd:RegisterTriggerFunc(func, bluePrintSelf)
  self:_GetInput()
  self.edge = self.inputArgs[2];
  EventDispatcher:RegisterCallback(self.inputArgs[1]:GetContentPath(), BlueDefined.Event.FrameAnimationEvent.End, func, bluePrintSelf );
end

---- 编辑器模式
OnFrameAniEnd:RegisterInput(1, apolloengine.FrameAnimationComponent:RTTI(), "component", "监听组件", BlueSelf());
OnFrameAniEnd:RegisterInput(2, Types.BoolType, "edge", "边缘触发", true);
OnFrameAniEnd:RegisterExecOutput(1, "OnTrigger", "执行");

OnFrameAniEnd:SetFunctionName("_OnFrameAnimationEnd");

OnFrameAniEnd:SetFunctionType(BlueDefined.EVENT_FUNCTION_NODE);

OnFrameAniEnd:SetEventType(BlueDefined.EventType.RegisterCallback);

return OnFrameAniEnd;

