local BlueNode = require "bluecore.bluenode"

-- 门控节点
local DoOnce = BlueNode:extend();
local Types = require "venuscore.rtti.types"

local EXEC_NEXT = 1
local EXEC_RESET = 2

---- 游戏运行模式
function DoOnce:new(...)
  DoOnce.super.new(self, ...)

end

-- 重写BlueNode的Update方法
function DoOnce:Update(execIdx)
  if execIdx == EXEC_RESET then
    --self:_Reset();
    self.inputArgs[1] = false -- 门打开
    return nil -- 不继续执行
  else
    if self.inputArgs[1] == nil then
      self:_Reset();
    end
    if self.inputArgs[1] == true then
      return nil
    else
      self.inputArgs[1] = true ; -- 门关闭
      return 1;
    end
  end
end

function DoOnce:_Reset()
  local depend = self.dependInputs[1] ;
  local node = depend[1];
  local ouputIdx = depend[2];
  node:Update();
  self.inputArgs = { node:GetOutputByIndex(ouputIdx) } ;
end


function DoOnce:_OnReset()
  self:_Reset();
end

DoOnce:RegisterInput(1, Types.BoolType, "Start Closed", "初始为关门", false);
DoOnce:RegisterExecInput(EXEC_NEXT, "Exec", "执行");
-- abort=true执行链,到这个引脚不会再继续后续节点
DoOnce:RegisterExecInput(EXEC_RESET, "Reset", "重置", true);
DoOnce:RegisterExecOutput(1, "Completed", "执行");

DoOnce:SetFunctionName("Do Once");

return DoOnce;

