local BD = require "bluecore.bluedefined"
local BATNode = require "bluecore.base.blue_anytype_node"
local Types = require "venuscore.rtti.types"

local GetArrayElementByIndex = BATNode:extend();

---- 游戏运行模式
function GetArrayElementByIndex:new(...)
  GetArrayElementByIndex.super.new(self, ...)
end

function GetArrayElementByIndex:_OnUpdate(args)
  local array = args[1]
  local index = args[2]

  if array == nil then
    LOG("[GetArrayElementByIndex] array is nil")
    return nil ;
  end
  if index < 1 or index > #array then -- FIXME(hhl) 如果{}不是数组而是字典??
    LOG("[GetArrayElementByIndex] out of range: index = "..tostring(index)..", length ="..tostring(#array))
    return nil ;
  end
  return array[index]
end

---- 编辑器模式

GetArrayElementByIndex:RegisterInput(1, Types.AnyArrayType, "Array", "通配数组", Types.AnyArrayType(), false, BATNode.DEFAULT_GROUP);
GetArrayElementByIndex:RegisterInput(2, Types.IntType, "Index", "数组索引(从1开始)", 1, false, nil)
GetArrayElementByIndex:RegisterOutput(1, Types.AnyType, "Get Element", "返回给定下标的数组元素", Types.AnyType(), false, BATNode.DEFAULT_GROUP);

GetArrayElementByIndex:SetFunctionName("Get");
GetArrayElementByIndex:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return GetArrayElementByIndex ;