local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local BlueNode = require "bluecore.bluenode"
local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"

local SetParamBool = BlueNode:extend();

function SetParamBool:new(...)
    SetParamBool.super.new(self, ...);
end

function SetParamBool:_OnUpdate(args)
    args[1]:SetBoolValue(args[2], args[3]);
end

SetParamBool:RegisterInput(1, apolloengine.AnimationComponent:RTTI(), "target", "动画组件", BlueSelf());
SetParamBool:RegisterInput(2, Types.StringType, "ParamName", "参数名字", "");
SetParamBool:RegisterInput(3, Types.BoolType, "Bool Value", "设置Bool类型参数", false);
SetParamBool:RegisterExecInput(1, "exec", "Execute");
SetParamBool:RegisterExecOutput(1, "exec", "Execute");
SetParamBool:SetFunctionName("SetParamBool");

return SetParamBool;
