local b3 = require 'behavior3.b3';

--M1: 20180731使用成员变量self.isOpen代替访问blackboard
--M2: 20180731注掉对Tick的调用
--M3: 20180801直接调用


local baseNode = b3.Class("BaseNode")
b3.BaseNode = baseNode

function baseNode:ctor(params)
	self.id = b3.createUUID()
	self.name = ""
	self.title = self.title or self.name
	self.description = ""
	self.parameters = {}
	self.properties = {}
  self.isOpen = false;
end

local _fenter = baseNode._enter;

function baseNode:_execute(tick)
	--ENTER
	--M3: self:_enter(tick)
	--self:enter(tick)

	--OPEN
	--M1: if not (tick.blackboard:get("isOpen", tick.tree.id, self.id)) then
  --[[if not self.isOpen then
		--M3: self:_open(tick) 
    self.isOpen = true;
    self:open(tick)
	end]]--

	--TICK
	--M3: local status = self:_tick(tick)
  local status = self:tick(tick)

	--CLOSE
	--[[if status ~= b3.RUNNING then
		--M3: self:_close(tick)
    self.isOpen = false;
    self:close(tick)
	end]]--

	--EXIT
	--M3: self:_exit(tick)
	--self:exit(tick)

	return status
end

function baseNode:_enter(tick)
	--M2: tick:_enterNode(self)
	self:enter(tick)
end

function baseNode:_open(tick)
	--M2: tick:_openNode(self)
	--M1: tick.blackboard:set("isOpen", true, tick.tree.id, self.id)
  self.isOpen = true;
	self:open(tick)
end

function baseNode:_tick(tick)
	--M2: tick:_tickNode(self)
	return self:tick(tick)
end

function baseNode:_close(tick)
	--M2: tick:_closeNode(self)
  self.isOpen = false;
	--M1: tick.blackboard:set("isOpen", false, tick.tree.id, self.id)
	self:close(tick)
end

function baseNode:_exit(tick)
	--M2: tick:_exitNode(self)
	self:exit(tick)
end

function baseNode:init(tick)
  if self.child then
    self.child:init(tick)
  end  
  if self.children then
    for i,v in ipairs(self.children) do
      local status = v:init(tick)
    end
  end  
end

function baseNode:enter(tick)
end

function baseNode:open(tick)
end

function baseNode:tick(tick)
end

function baseNode:close(tick)
end

function baseNode:exit(tick)
end

function baseNode:reset(tick)
  if self.child then
    self.child:reset(tick)
  end  
  if self.children then
    for i,v in ipairs(self.children) do
      v:reset(tick)
    end
  end 
end


