local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local radialblur = {}

function radialblur:SetBlurCenter(center)
  --print("Blur Center is: " .. tostring(center));
  --print("Blur Size is: " .. tostring(self.size));
  self.DnMaterial:SetParameter(self.BLUR_CENTER, mathfunction.vector2( center:x()/self.size:x(), center:y()/self.size:y() ) );
end

function radialblur:SetBlurScale(scale)
  self.DnMaterial:SetParameter(self.BLUR_SCALE, mathfunction.vector1(scale:x() * 0.00018) );
end

function radialblur:Initialize(host, size)
  self.Dn = 0;
  self.Queue = 100;
  --self.size = size;
  self.size = mathfunction.vector2(size:x(),size:y());
  self.BlurCenter = mathfunction.vector2(size:x()/2, size:y()/2);
  self.BlurScale = mathfunction.vector1(0);
    --<!--  set the center parameters in fragment shader -->
  self.BLUR_CENTER = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"UNIFORM_BLUR_CENTER");
    
  self.BLUR_SCALE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"UNIFORM_BLUR_SCALE");

  self.POST_EFFECT_ALPHA = apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,
    "POST_EFFECT_ALPHA");

  self.DnMaterial  = host:CreateMaterial("comm:documents/material/radialblur.material" );
  self.DnRenderObj = host:CreateRenderObject();

  self:SetBlurCenter(self.BlurCenter);
  self:SetBlurScale(self.BlurScale );

  self.DnMaterial:SetParameter(self.POST_EFFECT_ALPHA, mathfunction.vector1(1.0));
  
  host:RegisterScriptParameter(self,"BlurScale");
  host:RegisterScriptParameter(self,"BlurCenter");
  return self.Queue;
end

function radialblur:Resizeview(size)
  --self.size = size;
  self.size = mathfunction.vector2(size:x(),size:y());
  print("Resizeview size is: " .. tostring(self.size));
  self.center = mathfunction.vector2(size:x()/2, size:y()/2);
  self:SetBlurCenter(self.center);
end

function radialblur:Process(context, Original, Scene, Output)
  self:SetBlurCenter(self.BlurCenter);
  --print("Blur Center is:" .. tostring(self.BlurCenter));
  self:SetBlurScale(self.BlurScale );

  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.DnMaterial:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.DnRenderObj, self.DnMaterial);
  context:EndRenderPass();
end

return radialblur;