

#DEFPARAMS
_MainTex = { "main Color", TEXTURE2D, "white" },
_BumpMap = { "Normal Map", TEXTURE2D, "bump" },
_EnvMap = { "Env Map", TEXTURECUBE, "cube"},
_FresnelPower = { "Fresnel Power", FLOAT, "10"},
_FresnelBase = {"Fresnel Base", FLOAT, "0.9"},
_Cutoff = {"Cut Off", FLOAT, "1.0"},
_Opacity = {"Opacity", FLOAT, "0.3"},
_ReflectCol = {"Reflect Color", COLOR, "0.8,0.8,1.0,1.0"},
_ReflectStrength = { "Reflect Strength", FLOAT, "7.5" },
_MainUVScale = {"Main UV Scale", VEC2, "0.1,0.1"},
_BumpUVScale = {"Bump UV Scale", VEC2, "0.001,0.001"}
#END

#DEFTAG
ShaderName = "Ice"
RenderQueue = "Transparent+1"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;
	float3 binoraml : BINORMAL;
	float3 tangent : TANGENT;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 worldnormal : TEXCOORD1;
	float4 worldtangent : TEXCOORD2;
	float4 worldbinormal : TEXCOORD3;
	float4 vertex : SV_POSITION;
};

Texture2D _MainTex;
Texture2D _BumpMap;
TextureCube _EnvMap;
SamplerState _MainSampler;
SamplerState _BumpSampler;
SamplerState _EnvSampler;
float _FresnelPower;
float _FresnelBase;
float _Cutoff;
float _Opacity;
float4 _ReflectCol;
float _ReflectStrength;
float2 _MainUVScale;
float2 _BumpUVScale;

v2f vert(appdata v)
{
	v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);
	o.uv = v.uv.xy;
	float3 worldpos = ObjectToWorldPos(v.vertex).xyz;
	o.worldnormal.xyz = ObjectToWorldNormal(v.normal).xyz;
	o.worldtangent.xyz = ObjectToWorldDir(v.tangent).xyz;
	o.worldbinormal.xyz = ObjectToWorldDir(v.binoraml).xyz;

	o.worldnormal.w = worldpos.x;
	o.worldtangent.w = worldpos.y;
	o.worldbinormal.w = worldpos.z;

	return o;
}

void frag(in v2f i, out float4 outColor : SV_Target0)
{
	// sample the texture
	float2 mainUV = i.uv * _MainUVScale;
	float4 mainColor = _MainTex.Sample(_MainSampler, mainUV);

	// normal world
	float2 bumpUV = i.uv * _BumpUVScale;
	float3 normalTangent = _BumpMap.Sample(_BumpSampler, bumpUV).rgb;
	normalTangent.xyz = normalTangent.xyz * 2.0 - 1.0;
	float3 normalWorld = normalTangent.x * i.worldtangent.xyz + normalTangent.y * i.worldtangent.xyz
		+ normalTangent.z * i.worldnormal.xyz;
	normalWorld.xyz = normalize(normalWorld.xyz);

	// reflect dir
	float3 worldPos = float3(i.worldnormal.w, i.worldtangent.w, i.worldbinormal.w);
	float3 reflectDir = WorldReflectionVector(worldPos, normalWorld);
	half4 reflectCol = _EnvMap.Sample(_EnvSampler, reflectDir) * mainColor.w;

	float3 viewDirWorld = WorldViewDir(worldPos);
	half dotNV = dot(normalWorld, viewDirWorld);
	half fresnel = saturate(1.0 - dotNV);
	fresnel = pow(fresnel, _FresnelPower);
	fresnel = _FresnelBase + (1.0 - _FresnelBase) * fresnel;

//	outColor.xyz = mainColor.xyz * (1.0 - fresnel) + reflectCol * fresnel;
	outColor.xyz = reflectCol.xyz * fresnel;
	outColor.xyz = outColor.xyz * _ReflectCol.xyz * _ReflectStrength;
	outColor.w = (_Cutoff > mainColor.a ? mainColor.a + _Opacity : 0.0);
}
ENDCG
#END
