//////////////////////////////////////////////////////////////////////////////////////
//
//						The Bohge Engine License (BEL)
//
//	Copyright (c) 2011-2014 Peng Zhao
//
//	Permission is hereby granted, free of charge, to any person obtaining a copy
//	of this software and associated documentation files (the "Software"), to deal
//	in the Software without restriction, including without limitation the rights
//	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//	copies of the Software, and to permit persons to whom the Software is
//	furnished to do so, subject to the following conditions:
//
//	The above copyright notice and this permission notice shall be included in 
//	all copies or substantial portions of the Software. And the logo of 
//	Bohge Engine shall be displayed full screen for more than 3 seconds 
//	when the software is started. Copyright holders are allowed to develop 
//	game edit based on Bohge Engine, The edit must be released under the MIT 
//	open source license if it is going to be published. In no event shall 
//	copyright holders be prohibited from using any code of Bohge Engine 
//	to develop any other analogous game engines.
//
//	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//
//////////////////////////////////////////////////////////////////////////////////////



//最普通的参数输出最基本的数据
#SHADER_DEFINE BaseTransfrom

	FUNCTION_INPUT = 
	{
		{ LOCALSCREEN_TRANSVIEWPROJ,	HIGH,	MAT4,		"in_WorldViewPorj" },
		{ LOCALWORLD_ROTATION,			HIGH,	MAT3,		"in_WorldRotation" },
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_NORMAL, 			HIGH,	VEC3,		"in_Normal" },
	}

	FUNCTION_OUTPUT = 
	{
		{ SCREENSPACE_POSITION, 		HIGH,	VEC4,		"out_Position" },
		{ WORLDSPACE_NORMAL, 			HIGH,	VEC3,		"out_Normal" },
	}

#SHADER_CODE
	vec4 out_Position = in_WorldViewPorj * in_Position;
    vec3 out_Normal = in_WorldRotation * in_Normal;
#END_CODE
#END_DEFINE


//输出顶点的世界坐标的shader，光源的一些计算需要这个参数
#SHADER_DEFINE TransfromWorldPosition

	FUNCTION_INPUT = 
	{
		{ CAMERA_VIEWPROJ,			HIGH,	MAT4,		"in_ViewPorj" },
    { CAMERA_VIEW,          HIGH, MAT4,    "in_ViewMatrix"},
		{ LOCALWORLD_TRANSFORM,		HIGH,	MAT4,		"in_Transfrom" },
		{ LOCALWORLD_ROTATION,		HIGH,	MAT3,		"in_WorldRotation" },
		{ ATTRIBUTE_POSITION, 		HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_NORMAL, 		HIGH,	VEC3,		"in_Normal" },
    { ATTRIBUTE_TANGENT,    HIGH, VEC3,    "in_Tangent" },
    { ATTRIBUTE_BINORMAL,   HIGH, VEC3,    "in_Binormal" }
	}

	FUNCTION_OUTPUT = 
	{
		{ SCREENSPACE_POSITION, 	HIGH,	VEC4,		"out_Position" },
		{ WORLDSPACE_NORMAL, 		HIGH,	VEC3,		"out_Normal" },
		{ WORLDSPACE_POSITION,		HIGH,	VEC4,		"out_PositionWS" },
    { WORLDSPACE_TANGENT,   HIGH, VEC3,    "out_Tangent"},
    { WORLDSPACE_BINORMAL,  HIGH, VEC3,    "out_Binormal"},
    { CAMERASPACE_POSITION, HIGH, VEC3,    "out_PositionCS"}
	}

#SHADER_CODE
    vec3 out_Normal = normalize(in_WorldRotation * in_Normal);
    vec3 out_Tangent = normalize(in_WorldRotation * in_Tangent);
    vec3 out_Binormal = normalize(in_WorldRotation * in_Binormal);
    vec4 out_PositionWS  = in_Transfrom * in_Position;
    vec4 position_cameraspace = in_ViewMatrix * out_PositionWS;
    vec3 out_PositionCS = position_cameraspace.xyz / position_cameraspace.w;
	vec4 out_Position = in_ViewPorj * out_PositionWS;
#END_CODE
#END_DEFINE


#SHADER_DEFINE TransfromNoConvert


	FUNCTION_INPUT =
	{
		{ ATTRIBUTE_POSITION, 		HIGH,	VEC4,		"in_Position" },
	}





	FUNCTION_OUTPUT =
	{
		{ SCREENSPACE_POSITION, 	HIGH,	VEC4,		"out_Position" },
	}

#SHADER_CODE
	vec4 out_Position = in_Position;
#END_CODE
#END_DEFINE

#SHADER_DEFINE TBNTransform

	FUNCTION_INPUT = 
	{
		{ WORLDSPACE_TANGENT,   HIGH, VEC3,    "out_Tangent"},
		{ WORLDSPACE_BINORMAL,  HIGH, VEC3,    "out_Binormal"},
		{ WORLDSPACE_NORMAL, 	HIGH, VEC3,	   "out_Normal" },
		{ LIGHT_GIVEN_DIRECTION,		MEDIUM,		VEC3,		"in_LightDirection" },
	}

	FUNCTION_OUTPUT = 
	{
		{	W2T_TBN_MAT,	HIGH,    MAT3,         "W2T_TBN"},
		{	T2W_TBN_MAT,	HIGH,    MAT3,         "T2W_TBN"},
	    {   LIGHT_GIVEN_DIRECTION,		MEDIUM,		VEC3,		"out_LightDirection" }
	}

#SHADER_CODE
	mat3 T2W_TBN = mat3(out_Tangent,out_Binormal,out_Normal);//从切线空间转到世界空间的矩阵
	mat3 W2T_TBN = mat3(
		vec3(out_Tangent.x,out_Binormal.x,out_Normal.x),
		vec3(out_Tangent.y,out_Binormal.y,out_Normal.y),
		vec3(out_Tangent.z,out_Binormal.z,out_Normal.z));//从世界空间转到切线空间的矩阵
	vec3 out_LightDirection = in_LightDirection;
#END_CODE
#END_DEFINE

#SHADER_DEFINE ShadowTransform

	FUNCTION_INPUT = 
	{
    { LIGHT_CAMERA_VIEW,               HIGH, MAT4,   "in_LightCameraViewMatrix"},
    { LIGHT_CAMERA_PROJECTION,         HIGH, MAT4,   "in_LightCameraPorjMatrix"},
    { LIGHT_CAMERA_LINEARPARAM, HIGH,	VEC3,		"in_LightCameraLineDepthParam"},
    { LIGHT_CAMERA_POSITION,    HIGH, VEC3,   "in_LightCameraPosition"},
    { WORLDSPACE_POSITION,		HIGH,	VEC4,		  "in_PositionWS" }
	}

	FUNCTION_OUTPUT = 
	{
    { LIGHTSPACE_COORD,    HIGH, VEC4,    "out_LightCoord"},
    { WORLDSPACE_LIGHTCAMERA_DISTANCE, HIGH, FLOAT, "out_OrigDepth"}
	}

#SHADER_CODE
  const mat4 biasMatrix = mat4(0.5,0.0,0.0,0.0,
                        0.0,0.5,0.0,0.0,
                        0.0,0.0,0.5,0.0,
                        0.5,0.5,0.5,1.0);
  vec4 out_LightCoord = in_LightCameraPorjMatrix * in_LightCameraViewMatrix * in_PositionWS;
  vec4 positionCS = in_LightCameraViewMatrix * in_PositionWS;
  out_LightCoord = out_LightCoord / out_LightCoord.w;
  out_LightCoord = biasMatrix * out_LightCoord;
	highp float out_OrigDepth = ( -positionCS.z / positionCS.w - in_LightCameraLineDepthParam.x ) * in_LightCameraLineDepthParam.y;
  
#END_CODE
#END_DEFINE

#SHADER_DEFINE ShadowTransformBias

	FUNCTION_INPUT = 
	{
    { LIGHT_CAMERA_VIEW,               HIGH, MAT4,   "in_LightCameraViewMatrix"},
    { LIGHT_CAMERA_PROJECTION,         HIGH, MAT4,   "in_LightCameraPorjMatrix"},
    { LIGHT_CAMERA_LINEARPARAM, HIGH,	VEC3,		"in_LightCameraLineDepthParam"},
    { LIGHT_CAMERA_POSITION,    HIGH, VEC3,   "in_LightCameraPosition"},
    { WORLDSPACE_POSITION,		HIGH,	VEC4,		  "in_PositionWS" },
    { WORLDSPACE_NORMAL,		HIGH,	VEC3,		  "in_Normal" }
	}

	FUNCTION_OUTPUT = 
	{
    { LIGHTSPACE_COORD,    HIGH, VEC4,    "out_LightCoord"},
    { WORLDSPACE_LIGHTCAMERA_DISTANCE, HIGH, FLOAT, "out_OrigDepth"}
	}

#SHADER_CODE
  const mat4 biasMatrix = mat4(0.5,0.0,0.0,0.0,
                        0.0,0.5,0.0,0.0,
                        0.0,0.0,0.5,0.0,
                        0.5,0.5,0.5,1.0);
  vec4 newWorldPos = in_PositionWS-vec4(0.005*in_Normal,0.0);
  vec4 out_LightCoord = in_LightCameraPorjMatrix * in_LightCameraViewMatrix * newWorldPos;
  vec4 positionCS = in_LightCameraViewMatrix * newWorldPos;
  out_LightCoord = out_LightCoord / out_LightCoord.w;
  out_LightCoord = biasMatrix * out_LightCoord;
	highp float out_OrigDepth = ( -positionCS.z / positionCS.w - in_LightCameraLineDepthParam.x ) * in_LightCameraLineDepthParam.y;
  
#END_CODE
#END_DEFINE

#SHADER_DEFINE TransfromWorldPositionTangentBinormal

	FUNCTION_INPUT = 
	{
		{ CAMERA_VIEWPROJ,			HIGH,	MAT4,		"in_ViewPorj" },
		{ LOCALWORLD_TRANSFORM,		HIGH,	MAT4,		"in_Transfrom" },
		{ LOCALWORLD_ROTATION,		HIGH,	MAT3,		"in_WorldRotation" },
		{ ATTRIBUTE_POSITION, 		HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_NORMAL, 		HIGH,	VEC3,		"in_Normal" },
		{ ATTRIBUTE_TANGENT, 		HIGH,	VEC3,		"in_Tangent" },
		{ ATTRIBUTE_BINORMAL, 		HIGH,	VEC3,		"in_Binormal" },
	}

	FUNCTION_OUTPUT = 
	{
		{ SCREENSPACE_POSITION, 	HIGH,	VEC4,		"out_Position" },
		{ WORLDSPACE_NORMAL, 		HIGH,	VEC3,		"out_Normal" },
		{ WORLDSPACE_POSITION,		HIGH,	VEC4,		"out_PositionWS" },
		{ WORLDSPACE_TANGENT, 		HIGH,	VEC3,		"out_Tangent" },
		{ WORLDSPACE_BINORMAL, 		HIGH,	VEC3,		"out_Binormal" },
	}

#SHADER_CODE
    vec3 out_Normal = in_WorldRotation * in_Normal;
    vec4 out_PositionWS  = in_Transfrom * in_Position;
	  vec4 out_Position = in_ViewPorj * out_PositionWS;
    vec3 out_Tangent = in_WorldRotation * in_Tangent;
    vec3 out_Binormal = in_WorldRotation * in_Binormal;
#END_CODE
#END_DEFINE


#SHADER_DEFINE DebugPhysicsPosition

FUNCTION_INPUT =
{
	{ LOCALWORLD_TRANSFORM,		HIGH,	MAT4,		"in_Transfrom" },
	{ ATTRIBUTE_POSITION, 		HIGH,	VEC4,		"in_Position" },
	{ CAMERA_VIEWPROJ,			HIGH,	MAT4,		"in_ViewPorj" },
	{ ATTRIBUTE_COLOR0,	        LOW,	VEC4,		"in_Color" },
	{ UNIFORM_DEBUGCAPSULE,     LOW,    VEC2,       "in_CapsuleTrans"}
}

FUNCTION_OUTPUT =
{
	{ SCREENSPACE_POSITION, 	HIGH,	VEC4,		"out_Position" },
	{ WORLDSPACE_POSITION,		HIGH,	VEC4,		"out_PositionWS" },
}

#SHADER_CODE

vec4 out_PositionTemp = vec4(in_Position.xyz * in_CapsuleTrans.y * in_Color.y, 1.0);
vec4 out_PositionUD = vec4(out_PositionTemp.x, out_PositionTemp.y + (in_Color.z - 0.5) * in_CapsuleTrans.x, out_PositionTemp.z, 1.0);
vec4 out_PositionWS = in_Transfrom * out_PositionUD;
vec4 out_Position = in_ViewPorj * out_PositionWS;
#END_CODE
#END_DEFINE