//////////////////////////////////////////////////////////////////////////////////////
//
//						The Bohge Engine License (BEL)
//
//	Copyright (c) 2011-2014 Peng Zhao
//
//	Permission is hereby granted, free of charge, to any person obtaining a copy
//	of this software and associated documentation files (the "Software"), to deal
//	in the Software without restriction, including without limitation the rights
//	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//	copies of the Software, and to permit persons to whom the Software is
//	furnished to do so, subject to the following conditions:
//
//	The above copyright notice and this permission notice shall be included in 
//	all copies or substantial portions of the Software. And the logo of 
//	Bohge Engine shall be displayed full screen for more than 3 seconds 
//	when the software is started. Copyright holders are allowed to develop 
//	game edit based on Bohge Engine, The edit must be released under the MIT 
//	open source license if it is going to be published. In no event shall 
//	copyright holders be prohibited from using any code of Bohge Engine 
//	to develop any other analogous game engines.
//
//	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//
//////////////////////////////////////////////////////////////////////////////////////





#SHADER_DEFINE FontVertex

	FUNCTION_INPUT = 
	{
		{ CAMERA_RESOLUTION_INV,        HIGH, VEC2,   "in_ResolutionInv"},
		{ CAMERA_RESOLUTION_HALF_INV,   HIGH, VEC2,   "in_ResolutionHalfInv"},
		{ WORLD_POSITION,           	HIGH, VEC3,   "in_WorldPosition"},
		{ WORLD_SCALE,             		HIGH, VEC3,   "in_WorldScale"},
		{ ATTRIBUTE_POSITION, 			HIGH, VEC2,		"in_Position" },
		{ ATTRIBUTE_COLOR0, 			HIGH,  VEC4,		"in_Color" },
		{ ATTRIBUTE_COORDNATE1, 			HIGH,  VEC2,		"in_Center" },
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"in_Coordinate" },
		{ OUTLINE_COLOR,                HIGH, VEC4,    "outline_Color"},
		{ OUTLINE_STRENGTH,             HIGH, FLOAT,    "outline_Strength"},
	}

	FUNCTION_OUTPUT = 
	{
		{ SCREENSPACE_POSITION, 		HIGH,	VEC4,		"out_Position" },
		{ ATTRIBUTE_COLOR0, 			  HIGH,	VEC4,		"out_Color" },
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"Out_Coordinate" },
	}

#SHADER_CODE
	vec4 out_Position = vec4(in_Position * in_WorldScale.xy *in_ResolutionInv + in_WorldPosition.xy * in_ResolutionHalfInv, 0.0, 1.0);
	//vec4 center = vec4(in_Center * in_WorldScale.xy *in_ResolutionInv + in_WorldPosition.xy * in_ResolutionHalfInv, 0.0, 1.0);
	out_Position = out_Position + vec4(vec2(0.01,-0.01), 0.0, 0.0) * outline_Strength;
    vec4 out_Color = in_Color;
    if(outline_Strength != 0.0){
        out_Color = outline_Color;
    }
	highp vec2 Out_Coordinate = in_Coordinate;
#END_CODE
#END_DEFINE


#SHADER_DEFINE FontSampling

	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
		{ ATTRIBUTE_COORDNATE0,	HIGH,	VEC2,		"in_Coordinate" },
		{ ATTRIBUTE_COLOR0,	    HIGH,	  VEC4,		"in_Color" },
	}

	FUNCTION_OUTPUT = 
	{
		{ SURFACE_COLOR,	HIGH,	VEC4,		"out_TextureColor" },
	}
	
#SHADER_CODE
    highp float alpha = texture2D( in_DiffuseTexture, in_Coordinate ).a;
	highp vec4 out_TextureColor = in_Color;
	out_TextureColor.a *= alpha;
#END_CODE
#END_DEFINE