
#DEFPARAMS
TEXTURE_DIFFUSE = { "tex diffuse", TEXTURE2D, "white" },
TEXTURE_REFLECTION = { "reflection tex", TEXTURE2D, "white" },
UNIFORM_REFFACTOR = { "reffactor", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "nl_reflectionadv"
RenderQueue = "Opaque+100"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
	float3 normal : NORMAL;
	float3 tangent : TANGENT;
	float3 binoraml : BINORMAL;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float3 worldpos : TEXCOORD2;
	float3 worldnormal : NORMAL;
	float3 worldtangent : TANGENT;
	float3 worldbinormal : BINORMAL;
	float4 vertex : SV_POSITION;
};

uniform float3x3 LOCALWORLD_ROTATION;
Texture2D TEXTURE_DIFFUSE;
Texture2D TEXTURE_NORMAL;
Texture2D TEXTURE_EMSSION;
SamplerState TEXTURE_DIFFUSE_Sampler;
SamplerState TEXTURE_NORMAL_Sampler;
SamplerState TEXTURE_EMSSION_Sampler;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(o.vertex);
	o.uv = v.uv.xy;
	o.worldpos = ObjectToWorldPos(v.vertex).xyz;
	o.worldnormal = mul(v.normal, LOCALWORLD_ROTATION).xyz;
	o.worldtangent = mul(v.tangent, LOCALWORLD_ROTATION).xyz;
	o.worldbinormal = mul(v.binoraml, LOCALWORLD_ROTATION).xyz;

	return o;
}

void frag(in v2f i, in bool FacingSign : SV_IsFrontFace, out float4 mainColor : SV_Target0)
{	
	float4 diffTexColor = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.uv);
	float4 emssionTexColor = TEXTURE_EMSSION.Sample(TEXTURE_EMSSION_Sampler, i.uv);
	float4 normalTexColor = TEXTURE_NORMAL.Sample(TEXTURE_NORMAL_Sampler, i.uv);

	if (diffTexColor.a < 0.5)
		discard;
	float3 normal = normalTexColor.rgb - 0.5;
	normal = normalize(normal);
	if (!FacingSign)
		normal = -normal;

	float3x3 tangentSpace = float3x3(i.worldtangent,
		i.worldbinormal,
		i.worldnormal);

	float3 v_worldViewDir = normalize(float3(i.worldpos.xyz) - CAMERA_WORLDPOSITION);
	float3 worldNormal = normalize(mul(normal, tangentSpace));
	float3 refCoord = reflect(v_worldViewDir, worldNormal);

	float3 ref = normalize(refCoord) + float3(0.0, 0.0, 1.0);
	float len2 = 2.0*sqrt(ref.x*ref.x + ref.y*ref.y + ref.z*ref.z);
	float2 texCoord = float2(0.5 + ref.x / len2, 0.5 - ref.y / len2);
	
	mainColor.rgb = diffTexColor.rgb*0.5+float3(texCoord.y, texCoord.y, texCoord.y) + emssionTexColor.rgb;
	mainColor.a = diffTexColor.a;
}
ENDCG
#END
