#include"functions/square.function"
#include"functions/geotrans.function"

#SHADER_DEFINE SixImgVertex
	FUNCTION_INPUT = 
	{
        { ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;
    vec2 out_TexCooridate = in_TexCooridate.xy;
#END_CODE
#END_DEFINE



#SHADER_DEFINE SixImgFragment
  FUNCTION_INPUT = 
	{

    { TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"uniCurrentTexture" },
    { ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
    { RATIOASPECT,    MEDIUM,    FLOAT,        "aspectRatio"},


	}
#SHADER_CODE
   
   
   
   
   vec2 center = vec2(0.5,0.5);
   const float pi = 3.1415926;


   float angle =  getangle(in_TexCooridate,center,aspectRatio);
   vec2 Coord = vec2(0.0);
   if(0.0 <= angle && angle < 1.0/3.0*pi)
   {  
      Coord = rotate(in_TexCooridate-center,pi/3.0,aspectRatio)+vec2(0.5,0.5); 
   }
   else if(1.0/3.0*pi <= angle && angle < 2.0/3.0*pi)
   {  
      Coord = in_TexCooridate;
   }
   else if(2.0/3.0*pi <= angle && angle < pi)
   {  
      Coord = rotate(in_TexCooridate-center,-pi/3.0,aspectRatio)+vec2(0.5,0.5); 
   }
   else if(-1.0/3.0*pi <= angle && angle < 0.0)
   {  
      Coord = rotate(in_TexCooridate-center,2.0*pi/3.0,aspectRatio)+vec2(0.5,0.5); 
   }
   else if(-2.0/3.0*pi <= angle && angle < -1.0/3.0*pi)
   {  
      Coord = rotate(in_TexCooridate-center,pi,aspectRatio)+vec2(0.5,0.5); 
   }
   else {
     Coord = rotate(in_TexCooridate-center,-2.0*pi/3.0,aspectRatio)+vec2(0.5,0.5);
   }

   Coord.y = Coord.y - 0.25;
   vec3 color = texture2D(uniCurrentTexture,Coord).rgb;
   gl_FragColor = vec4(color,1.0);

#END_CODE
#END_DEFINE