

#DEFPARAMS
_MainTex = { "main Color", TEXTURE2D, "white" },
_TexAspect = {"TexAspect", FLOAT, "1.0"},
_ScaleX = { "scale_x", FLOAT, "1.0" },
_ScaleY = { "scale_y", FLOAT, "1.0" },
_PosX = { "pos_x", FLOAT, "0.0" },
_PosY = { "pos_y", FLOAT, "0.0" },
_PosZ = { "pos_z", FLOAT, "0.0" },
#END


#DEFTAG
ShaderName = "normal_ui_bg"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_ALWAYS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_skin
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
	ANI_ATTRIBUTE
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D _MainTex;
SamplerState _MainSampler;
float     _TexAspect;
float _ScaleX;
float _ScaleY;
float _PosX;
float _PosY;
float _PosZ;

v2f vert(appdata v)
{
    v2f o;
	v.vertex.x = v.vertex.x * (step(0.999, _TexAspect)*_TexAspect + step(_TexAspect, 0.999));
	v.vertex.y = v.vertex.y * (step(0.999, _TexAspect) + step(_TexAspect, 0.999)/_TexAspect);
    float2 in_WorldScale = float2(_ScaleX, _ScaleY);
    float4 pos = float4(v.vertex.xy * in_WorldScale / 1000.0 + float2(_PosX, _PosY), _PosZ, 1.0);
    o.vertex = UniformNDC(pos);
    o.uv = v.uv.xy;
    return o;
}

void frag(in v2f i, out float4 outColor : SV_Target0)
{
	// sample the texture
	outColor = _MainTex.Sample(_MainSampler, i.uv);
}
ENDCG
#END
