

#DEFPARAMS
_MainTex = { "main Color", TEXTURE2D, "white" },
_Gloss = { "specular Gloss", FLOAT, "0.5" },
_Specular = { "specular Color", FLOAT, "0.5"},
_CutOff = { "CutOff", FLOAT, "0.2" },
#END

#DEFTAG
ShaderName = "Specular"
RenderQueue = "TransparentCutout+100"
#END 

#DEFPASS ForwardBase
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdbase
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;
	float2 uv : TEXCOORD0;
	ANI_ATTRIBUTE
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float3 worldpos : TEXCOORD2;
	float3 worldnormal : TEXCOORD3;
	float4 vertex : SV_POSITION;
	SHADOW_COORDS(4)
};

Texture2D _MainTex;
SamplerState _MainTex_SAMPLER;
float _Gloss;
float _Specular;
float _CutOff;

v2f vert(appdata v)
{
	COMPUTE_BONE_MATERIX(v);

	v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);
	o.uv = v.uv.xy;
	o.worldpos = ObjectToWorldPos(v.vertex).xyz;
	o.worldnormal = ObjectToWorldNormal(v.normal).xyz;

	TRANSFER_SHADOW(o, v.vertex);
	return o; 
}

void frag(in v2f i, out float4 outColor : SV_Target0) 
{
	// sample the texture
	float4 col = _MainTex.Sample(_MainTex_SAMPLER, i.uv);
	SurfaceInput input;
	input.albedo = col.rgb;
	input.specular = _Specular;
	input.gloss = _Gloss;
	input.worldNormal = normalize(i.worldnormal.xyz);
	input.worldPos = i.worldpos;
	input.emission = AmbientColor();
	input.atten = SHADOW_ATTEN(i);   

	outColor.xyz = LightCalc(input);
	outColor.w = 1.0;
	if(col.a-_CutOff<=0) {discard; }
}
ENDCG
#END

#DEFPASS ForwardAdd
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, ONE, ONE, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LEQUAL }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDADD }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdadd
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;
	float2 uv : TEXCOORD0;
	ANI_ATTRIBUTE
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float3 worldpos : TEXCOORD2;
	float3 worldnormal : TEXCOORD3;
	float4 vertex : SV_POSITION;
	SHADOW_COORDS(4)
};

Texture2D _MainTex;
SamplerState _MainTex_SAMPLER;
float _Gloss;
float _Specular;

v2f vert(appdata v)
{
	COMPUTE_BONE_MATERIX(v);

	v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);
	o.uv = v.uv.xy;
	o.worldpos = ObjectToWorldPos(v.vertex).xyz;
	o.worldnormal = ObjectToWorldNormal(v.normal).xyz;

	TRANSFER_SHADOW(o, v.vertex);
	return o;
}

void frag(in v2f i, out float4 outColor : SV_Target0) 
{
	// sample the texture
	float4 col = _MainTex.Sample(_MainTex_SAMPLER, i.uv);
	SurfaceInput input;
	input.albedo = col.rgb;
	input.specular = _Specular;
	input.gloss = _Gloss;
	input.worldNormal = normalize(i.worldnormal.xyz);
	input.worldPos = i.worldpos;
	input.emission = float3(0.0, 0.0, 0.0);
	input.atten = SHADOW_ATTEN(i);

	outColor.xyz = LightCalc(input);
	outColor.w = 1.0;
}
ENDCG

#END

#DEFPASS Depth
	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_OFF }
	DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { DEPTHPASS }

	CGPROGRAM
	#pragma vertex vert
	#pragma fragment frag
	#include "light.inc"
	#pragma multi_compile_skin

	struct appdata
	{
		float4 vertex : POSITION;
		float3 normal : NORMAL;
		ANI_ATTRIBUTE
	};

	struct v2f
	{
		float4 vertex : SV_POSITION;
	};

	v2f vert(appdata v)
	{
		COMPUTE_BONE_MATERIX(v);
		float4 clipPos = ObjectToClipPos(v.vertex);
		clipPos = ApplyShadowBias(clipPos);

		v2f o;
		o.vertex = UniformNDC(clipPos);
		return o;
	}

	void frag(in v2f i, out float4 outColor : SV_Target0)
	{
		outColor = float4(0.0, 0.0, 0.0, 1.0);
	}
	ENDCG
#END
