
#DEFPARAMS
PARTICLE_GLOBAL_OFFSET = {"Global Offeset", VEC3, "0.0,0.0,0.0"},
PARTICLE_GLOBAL_SCALE = {"Global Scale", VEC3, "1.0,1.0,1.0"},
TEXTURE_DIFFUSE = {"TEXTURE_DIFFUSE", TEXTURE2D, "white" },
[Enum(BlendFunc)]
_BlendSrc = {"blendsrc", FLOAT, "4.0"},
[Enum(BlendFunc)]
_BlendDst = {"blenddst", FLOAT, "5.0"},
#END

#DEFTAG
ShaderName = "ParticleBlend"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA 
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc", "%_BlendDst", ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS } 
STENCIL_MODE = {STENCIL_OFF}


CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
  float3 vertex : POSITION;
  float2 uv : TEXCOORD0;
  float4 in_ParticleColor : COLOR0;
  float3 in_Tiles_Frame : BINORMAL;
  float4 in_Speed_Borntime : NORMAL;
  float4 in_Rot_Lifetime: TEXCOORD1;
  float3 in_Size_Distrubance_Stretch : TEXCOORD2;
  float2 in_Offset: TEXCOORD3;
};

struct v2f
{
  float2 uv : TEXCOORD0;
  float4 vertex : SV_POSITION;
  float4 out_SurfaceColor:COLOR0;
};

float SYSTEM_TIME;
float3 PARTICLE_GLOBAL_OFFSET;
float3 PARTICLE_GLOBAL_SCALE;
float4 PARTICLE_COLOR;


v2f vert(appdata v)
{
  float in_Time = SYSTEM_TIME;
  float4x4 in_Porjection = CAMERA_PROJECTION;
  float4x4 in_View = CAMERA_VIEW;
  float in_Flip = DEVICE_COORDINATE_Y_FLIP;
  float3 in_GlobalOffset = PARTICLE_GLOBAL_OFFSET;
  float3 in_GlobalScale = PARTICLE_GLOBAL_SCALE;
	
  v2f o;
  o.out_SurfaceColor = v.in_ParticleColor;
	
  float3 new_center = v.vertex + in_GlobalOffset;
  float borntime = (v.in_Speed_Borntime).w;
  float lifetime = (v.in_Rot_Lifetime).w;
  float distrubance = (v.in_Size_Distrubance_Stretch).y;
  float emittersize = (v.in_Size_Distrubance_Stretch).x; 
  float angleX = (v.in_Rot_Lifetime).x;
  float angleY = (v.in_Rot_Lifetime).y;
  float angleZ = (v.in_Rot_Lifetime).z;
  float sx = sin(angleX);
  float cx = cos(angleX);
  float sy = sin(angleY);
  float cy = cos(angleY);    
  float sz = sin(angleZ);
  float cz = cos(angleZ);
  float3x3 rotMatrix = float3x3(cz * cy,cy * sz,-sy,
                                cz * sy * sx - cx * sz, cz * cx + sz * sy * sx,cy * sx,
                                sz * sx + cz * cx * sy,cx * sz  - cz * sx,cy * cx);
  float3 out_Offset = float3(v.in_Offset,0.0);
  out_Offset = out_Offset * emittersize * in_GlobalScale;
  out_Offset = mul(out_Offset,rotMatrix);
  
  float4 noseCoord = float4(out_Offset,(in_Time - borntime)/lifetime);
  float pase = length(v.vertex + out_Offset) * in_Time;
  float noise = cos(pase);
  out_Offset = out_Offset * ( distrubance * noise) + out_Offset;
	
  float4 out_Position = mul(float4(new_center, 1.0),in_View);
  out_Position.xyz += out_Offset;
  out_Position = mul(out_Position, in_Porjection);
	
  float4 scale = float4(1.0, in_Flip, 1.0, 1.0);					
  o.vertex = scale * out_Position;
	
  int indexV = int((v.in_Tiles_Frame).z) / int((v.in_Tiles_Frame).x);
  int indexU = int((v.in_Tiles_Frame).z) - indexV * int((v.in_Tiles_Frame).x);
  float coordU = (float)(indexU) / (v.in_Tiles_Frame).x;
  float coordV = (float)(indexV) / (v.in_Tiles_Frame).y;
  float deltaU = 1.0 / (v.in_Tiles_Frame).x;
  float deltaV = 1.0 / (v.in_Tiles_Frame).y;
  o.uv = float2(coordU,coordV);
  o.uv.x += ((v.uv).x * deltaU);
  o.uv.y += ((v.uv).y * deltaV);
  return o;
}

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_SAMPLER;

void frag(in v2f i, out float4 outColor : SV_Target0) 
{
#define in_Texture TEXTURE_DIFFUSE
  float4 in_SurfaceColor = float4(in_Texture.Sample( TEXTURE_DIFFUSE_SAMPLER, i.uv));
  outColor = in_SurfaceColor * i.out_SurfaceColor;
}
ENDCG
#END

