
local apollonode = require "apolloutility.apollonode"
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"


local FarbicMaterial = {};

--外部会调用此接口创建材质
function FarbicMaterial:SetupMaterial(meshNode)
  self:_PbrInitialize(meshNode);
  meshNode:SetMaterialPath("docs:material/ske4bmat_pbr_cloth.material");
end

function FarbicMaterial:_PbrInitialize(meshNode)
  
  apolloengine.ShaderEntity.TEXTURE_ALDEBO = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"TEXTURE_ALDEBO");

  apolloengine.ShaderEntity.TEXTURE_NORMAL = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"TEXTURE_NORMAL");

  apolloengine.ShaderEntity.HAS_ALPHA = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"HAS_ALPHA");

  
  apolloengine.ShaderEntity.TEXTURE_AMR = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"TEXTURE_AMR");

  --世界空间转到切线空间的矩阵
  apolloengine.ShaderEntity.W2T_TBN_MAT = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"W2T_TBN_MAT");

  --切线空间转到世界空间的矩阵
  apolloengine.ShaderEntity.T2W_TBN_MAT = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"T2W_TBN_MAT");

  apolloengine.ShaderEntity.ALBEDO_COLOR = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"ALBEDO_COLOR");

  apolloengine.ShaderEntity.METALLIC_VALUE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"METALLIC_VALUE");

  apolloengine.ShaderEntity.ROUGHNESS_VALUE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"ROUGHNESS_VALUE");

  apolloengine.ShaderEntity.TANGENTSPACE_NORMAL = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"TANGENTSPACE_NORMAL");
  
  apolloengine.ShaderEntity.TANGENTSPACE_VIEWDIRECTION = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"TANGENTSPACE_VIEWDIRECTION");
  
  apolloengine.ShaderEntity.TANGENTSPACE_LIGHTDIRECTION = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"TANGENTSPACE_LIGHTDIRECTION");
  
  --基础反射色
  apolloengine.ShaderEntity.Base_Reflectivity = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"Base_Reflectivity");
  
  apolloengine.ShaderEntity.AO_VALUE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"AO_VALUE");
  
  apolloengine.ShaderEntity.UNIFORM_FUZZ_COLOR = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"UNIFORM_FUZZ_COLOR");
  
  
  apolloengine.ShaderEntity.LIGHTING_AMBIENT = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"LIGHTING_AMBIENT");
  
  
  meshNode:SetupUniforms(apolloengine.ShaderEntity.UNIFORM_FUZZ_COLOR, mathfunction.vector3(0.04,0.04,0.04));
  
  meshNode:SetupUniforms(apolloengine.ShaderEntity.HAS_ALPHA, mathfunction.vector1(0.0));
end



return FarbicMaterial;