local facecover = require "facecute.facechange.facecover"
local facedefined = require "facecute.facechange.facedefined"
local renderqueue = require "apolloutility.renderqueue"
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
--facecover类型
local facecover3New = facecover:extend();

function facecover3New:new(maincamera)
    facecover3New.super.new(self, maincamera);
    self.animLoop = 0;
    self.animTime = -1.0;
    self.animFPS = 25;
    self.texturereader:AutoSkip()
end


function facecover3New:GetRenderOrder()
    local offset = self.renderoffset;
    local zPos = self.zPos+offset;
    return zPos;
end

function facecover3New:ParseConfig(config,para, compress_root)

    self.renderoffset = -2000;
    local res = facecover3New.super.ParseConfig(self, config, para, compress_root);
    self:SetRenderOrder(config["zPosition"]);
    return res;
end

function facecover3New:SetRenderOrder(z)
    local zPos = z;
    self.zPos = z;

    if(zPos~=nil)
    then
        local offset = self.renderoffset;
        local bindboxV = mathfunction.Aabbox3d(mathfunction.vector3(-1,-1, offset + zPos -1),
                mathfunction.vector3(1,1,offset + zPos));
        self:SetBindBox(bindboxV);
        self:SetCull(false);
    end
end

function facecover:GetMaterialPath(blendModeIndex)

    local materialPath;
    if self.texturesplit then
        materialPath = facedefined.materialPathSplit[blendModeIndex];
    else
        materialPath = facedefined.materialPath3[blendModeIndex];
    end
    return materialPath;

end

function facecover3New:SetShow(show)
    self:SetVisible(show)
end

----------

function facecover3New:SetRootNode(rootNode)
    rootNode:AttachNode(self)
end

function facecover3New:Finished()
    return not self:IsAnimPlaying()
end

function facecover3New:SeekToFirst()
    self.texturereader:SetAccTime(0)
end

function facecover3New:SeekToMiddle()
    local totalTime = self.texturereader:GetTotalTime()
    self.texturereader:SetAccTime(totalTime * 0.5)
end

function facecover3New:SeekToLast()
    local totalTime = self.texturereader:GetTotalTime()
    if totalTime > 0.0001 then
        self.texturereader:SetAccTime(totalTime - 0.0001)
    else
        self.texturereader:SetAccTime(0)
    end
end

function facecover3New:Show(args)
    self:SetVisible(true)
end

function facecover3New:Hide(args)
    self:SetVisible(false)

    self.animLoop = 0;
    self.animTime = -1;
    self:AnimUpdate(0);
end

function facecover3New:Start(args)
    if self:IsAnimPlaying() then
        return
    end
    self.animLoop = args.loop;
    self.animTime = 0.0;
    self:AnimUpdate(0);
end

function facecover3New:Stop(args)

end

function facecover3New:Update(timespan, face, position, rotation, action)
    if not self.bParse then
        return
    end

    self.face = face;
    self.action = action;
    self.curFrame = self.curFrame + 1;
    self:AnimUpdate(timespan);
end

function facecover3New:SetFade(fade)
    self:SetParameter(apolloengine.ShaderEntity.UNIFORM_ALPHACOF, mathfunction.vector1(fade));
end

--------

function facecover3New:IsAnimPlaying()
    return self.animTime >= 0
end

function facecover3New:AnimUpdate(timespan)
    if not self.bParse then
        return
    end

    self.timespan = timespan

    if self.animTime == -1.0 then
        --local pic = self:Render();
        self:_ChangeVertexBuffer();
        return
    end

    if self.animTime == 0.0 then
        self.texturereader:ResetLoopCount();
    end

    self.animTime = self.animTime + timespan;

    local pic = self:Render();
    if self.animLoop > 0 and self.texturereader:GetLoopCount() >= self.animLoop then
        self.animTime = -1;
    end

end

function facecover3New:Render()
    if not self.bParse then
        return
    end
    local face = self.face;
    local timespan = self.timespan;
    local tex = renderqueue:GetLinkedTexture(self.renderLayer);
    self:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, tex);
    if (self.bseq == false)
    then
        if not self.texturesplit then
            self:SetParameter(apolloengine.ShaderEntity.TEXTURE_BACKG, self.tex);
            self:SetParameter(apolloengine.ShaderEntity.TEXTURE_LUT, self.ltex);
        else
            self:SetParameter(apolloengine.ShaderEntity.TEXTURE_BACKG_RGB, self.tex);
            self:SetParameter(apolloengine.ShaderEntity.TEXTURE_BACKG_ALPHA, self.atex);
        end
    else
        local slotindex = self.texturesplit
                and apolloengine.ShaderEntity.TEXTURE_BACKG_RGB
                or apolloengine.ShaderEntity.TEXTURE_BACKG
        self.rgbtexture, pic, self.alphatexture = self.texturereader:Update(timespan);
        if (self.rgbtexture ~= nil)
        then
            self:SetParameter(slotindex, self.rgbtexture);
        end
        if self.alphatexture ~= nil then
            self:SetParameter(apolloengine.ShaderEntity.TEXTURE_BACKG_ALPHA, self.alphatexture);
        end
    end

    self:_ChangeVertexBuffer();
    return pic;
end


return facecover3New;