
local transfer = require "facecute.deformation.transfer"
local defordefined = require "facecute.deformation.defordefined"
local renderqueue = require "apolloutility.renderqueue"

local transfer3New = transfer:extend()



function transfer3New:new(maincamera)
    transfer3New.super.new(self, maincamera);
    self.animLoop = 0
    self.currLoop = 0
end


function transfer3New:GetRenderOrder()
  return self.addIndex/10000+renderqueue:GetMaxFaceOrder();
end

function transfer3New:GetMaterialPath()
  return defordefined.transfer_material_path3;
end

function transfer3New:SetShow(isshow)
    self:SetVisible(isshow)
end

----------

function transfer3New:SetRootNode(rootNode)
    rootNode:AttachNode(self)
end

function transfer3New:Finished()
    if self.animLoop == 0 then
        return false
    end
    return self.currLoop >= self.animLoop
end

function transfer3New:SeekToFirst()

end

function transfer3New:SeekToMiddle()

end

function transfer3New:SeekToLast()

end

function transfer3New:Show(args)
    self:SetVisible(true)
end

function transfer3New:Hide(args)
    self:SetVisible(false)
    self.animLoop = 0
    self.currLoop = 0
end

function transfer3New:Start(args)
    self.animLoop = args.loop == nil and 0 or args.loop
end

function transfer3New:Stop(args)

end

function transfer3New:Update(timespan, face, position, rotation, action)
    self.timespan = timespan;
    self.frames = self.frames+1;
    self.action = action;
    self.curFrame= self.curFrame+1;
    self:Render();
    if self.animLoop > 0 and self.currLoop < self.animLoop then
        self.currLoop = self.currLoop + 1
    end
end

function transfer3New:SetFade(fade)

end

-----------


return transfer3New;
