local venuscore = require "venuscore"
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local pnpestimates = require "pnpestimates"
local cv = require "computervisionfunction"


local MaterialSwitchBehavior = venuscore.VenusBehavior:extend("MaterialSwitchBehavior");

function MaterialSwitchBehavior:GetTest()
    return self.matpath;
end

function MaterialSwitchBehavior:SetTest(value)
    self.matpath = value;
end


function MaterialSwitchBehavior:GetRender(node)
  self.render = node:GetComponent(apolloengine.Node.CT_RENDER);
  if self.render==nil then
   LOG("WE HAVE NO render COMPOENENT!")
  end
  return  self.render;
end

function MaterialSwitchBehavior:GetMatEntity(node)
  if self.materialEntity==nil then
    local meta = apolloengine.MaterialMetadata(self.matpath);
    local sceneid = node:GetHostScene():GetStaticID();
    meta:SetSceneID(sceneid);
    self.materialEntity = apolloengine.MaterialEntity();
    self.materialEntity:PushMetadata(meta);
    self.materialEntity:CreateResource();
  end
  return self.materialEntity;
end

function MaterialSwitchBehavior:SwitchMat(node,recursive)
  if self.matpath~="" then
    local render = self:GetRender(node);
    if render then
      WARNING("SWITCH NODE MAT "..node:GetName());
      render:ChangeMaterial(self:GetMatEntity(node), 1);
    end
  end
  if recursive then
    local children = node:GetChildrens();
    for i=1,#children do
      self:SwitchMat(children[i],recursive);
    end
  end
end

function MaterialSwitchBehavior:new()
  self.matpath = "";
  self.needRecursive = false;
end

function MaterialSwitchBehavior:_OnStart()
  self:SwitchMat(self.Node,self.needRecursive);
end

function MaterialSwitchBehavior:_OnUpdate()

end

MaterialSwitchBehavior:MemberRegister("matpath",  
  venuscore.ScriptTypes.FilePathType(
    {"mat" },
    MaterialSwitchBehavior.GetTest,
    MaterialSwitchBehavior.SetTest
  ));

MaterialSwitchBehavior:MemberRegister("needRecursive");

return MaterialSwitchBehavior;