local venuscore = require "venuscore"
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local define = require "behavior.cosmetic_contact_lenses.defines"


local CosmeticAlpha = venuscore.VenusBehavior:extend("CosmeticAlpha");
--CosmeticAlpha:MemberRegister("Alpha");

function CosmeticAlpha:new()
  --self.Alpha = 1.0;
  self.first = true;
  self.alphaTable = {};
end


function CosmeticAlpha:_OnUpdate(def)
  --[[local components = self.Node.Components;
  for comType, com in pairs(components) do
    local tm = getmetatable(com);
    if tm.Instances then
      for scrKey,scrValue in pairs(com.Instances) do
        if scrValue then
          LOG("name");
          --scrValue:Update(def);
        end
      end
    end
  end]]--
  if self.first then
    self.first = false;
    self:_SearchNodeOpacity(self.Node);
  end
  

end

function CosmeticAlpha:RecursiveNode(rootNode, newValue) --滑动条修改透明度
  
  if self.first then --手机端滑动条set的时候scriptcom还没有update
    self.first = false;
    self:_SearchNodeOpacity(self.Node);
  end
  
  local childNode = rootNode:GetChildrens();
  for i=1,#childNode do
    local node = childNode[i];
    local scriptCom = node:GetComponent(apolloengine.Node.CT_SCRIPT);
    if scriptCom then
      local paraSet = scriptCom.Instances
      for scrKey,scrValue in pairs(paraSet) do
        if scrValue["Opacity"] ~= nil then
          scrValue["Opacity"] = newValue*self.alphaTable[node:GetObjectID()];
        end
      end
    end
    self:RecursiveNode(node, newValue);
  end
end

function CosmeticAlpha:_SearchNodeOpacity(rootNode) --存储初始透明度值防止累乘
  local childNode = rootNode:GetChildrens();
  for i=1,#childNode do
    local node = childNode[i];
    local scriptCom = node:GetComponent(apolloengine.Node.CT_SCRIPT);
    if scriptCom then
      local paraSet = scriptCom.Instances
      for scrKey,scrValue in pairs(paraSet) do
        if scrValue["Opacity"] ~= nil then
          self.alphaTable[node:GetObjectID()] = scrValue["Opacity"];
        end
      end
    end
    self:_SearchNodeOpacity(node);
  end
end

return CosmeticAlpha;