local Venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local ModelPoseGetter = Venuscore.VenusBehavior:extend("ModelPoseGetter"); 

local rootBone   = "Pelvis";

local bonesNames = {};

table.insert( bonesNames, "R_Shoulder" );
table.insert( bonesNames, "R_Elbow" );
table.insert( bonesNames, "R_Wrist" );
table.insert( bonesNames, "L_Shoulder" );
table.insert( bonesNames, "L_Elbow" );
table.insert( bonesNames, "L_Wrist" );
table.insert( bonesNames, "R_Hip" );
table.insert( bonesNames, "R_Knee" );
table.insert( bonesNames, "R_Ankle" );
table.insert( bonesNames, "L_Hip" );
table.insert( bonesNames, "L_Knee" );
table.insert( bonesNames, "L_Ankle" );
table.insert( bonesNames, "Neck" );
table.insert( bonesNames, "Head" );
table.insert( bonesNames, "HeadL" );
table.insert( bonesNames, "HeadR" );
table.insert( bonesNames, "HeadF" );
table.insert( bonesNames, "HeadB" );


function ModelPoseGetter:new()
    self.R_Shoulder = nil;
    self.R_Elbow    = nil;
    self.R_Wrist    = nil;
    self.R_Hip      = nil;
    self.R_Knee     = nil;
    self.R_Ankle    = nil;

    self.L_Shoulder = nil;
    self.L_Elbow    = nil;
    self.L_Wrist    = nil;
    self.L_Hip      = nil;
    self.L_Knee     = nil;
    self.L_Ankle    = nil;
    self.Neck       = nil;
    self.Head       = nil;

    self.HeadL       = nil;
    self.HeadR       = nil;
    self.HeadF       = nil;
    self.HeadB       = nil;
end

function ModelPoseGetter:Init()
  self.BoneNodes = 
  {
    self.R_Shoulder,
    self.R_Elbow,
    self.R_Wrist,
    self.L_Shoulder,
    self.L_Elbow,
    self.L_Wrist,
    self.R_Hip,
    self.R_Knee,
    self.R_Ankle,
    self.L_Hip,
    self.L_Knee,
    self.L_Ankle,
    self.Neck,
    self.Head,
    self.HeadL,
    self.HeadR,
    self.HeadF,
    self.HeadB,
  }
  
end

function ModelPoseGetter:GetBonePosition()
    self:Init();
    local ret = {};
    for i=1,18 do
        if self.BoneNodes[i]~=nil then
            ret[i]  = {};
            local transform = self.BoneNodes[i]:GetComponent(apolloengine.Node.CT_TRANSFORM);
            local worldpos = transform:GetWorldPosition();
            ret[i][1] = worldpos:x();
            ret[i][2] = worldpos:y();
            ret[i][3] = worldpos:z();
        end
    end

    if #ret==18 then
        local mid = {};
        mid[1] = (ret[7][1]+ret[10][1])/2;
        mid[2] = (ret[7][2]+ret[10][2])/2;
        mid[3] = (ret[7][3]+ret[10][3])/2;
        for i=1,18 do
            ret[i][1] = ret[i][1] -  mid[1];
            ret[i][2] = ret[i][2] -  mid[2];
            ret[i][3] = ret[i][3] -  mid[3];
        end
    end
    return ret;
end




for i=1, #bonesNames do
    ModelPoseGetter:MemberRegister(bonesNames[i],
    Venuscore.ScriptTypes.ReferenceType(
    apolloengine.Node:RTTI()
  )); 
end


return ModelPoseGetter;