require "venusdebug"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local beautyutils = require "beauty.utils"
local Len = require "beauty.len"
local beautydefined

local FaceShin = {}

function FaceShin:_Bbox(config,keypoints, bboxData)
  for id, pt in pairs(keypoints) do
    bboxData.min_x = math.min(bboxData.min_x, pt[1]);
    bboxData.max_x = math.max(bboxData.max_x, pt[1]);
    bboxData.min_y = math.min(bboxData.min_y, pt[2]);
    bboxData.max_y = math.max(bboxData.max_y, pt[2]);
  end

  local index_left_up = beautydefined.FaceKey[1][1]+1;
  local index_left_down = beautydefined.FaceKey[2][1]+1;
  local index_right_up = beautydefined.FaceKey[1][2]+1;
  local index_right_down = beautydefined.FaceKey[2][2]+1;

  for i = 1, beautydefined.NumFaceAddition, 1 do
    local point_left = {keypoints[index_left_up][1], keypoints[index_left_up][2]};
    point_left[1] = point_left[1] + beautydefined.DeltaFaceAddition * i * (keypoints[index_left_up][1] - keypoints[index_left_down][1]);
    point_left[2] = point_left[2] + beautydefined.DeltaFaceAddition * i * (keypoints[index_left_up][2] - keypoints[index_left_down][2]);
    local point_right = {keypoints[index_right_up][1], keypoints[index_right_up][2]};
    point_right[1] = point_right[1] + beautydefined.DeltaFaceAddition * i * (keypoints[index_right_up][1] - keypoints[index_right_down][1]);
    point_right[2] = point_right[2] + beautydefined.DeltaFaceAddition * i * (keypoints[index_right_up][2] - keypoints[index_right_down][2]);
    
    local dr = config.AdditionRadius[i][1] * beautyutils.GetDistance(point_left, point_right)
    bboxData.min_x = math.min(bboxData.min_x, point_left[1]-dr);
    bboxData.max_x = math.max(bboxData.max_x, point_left[1]+dr);
    bboxData.min_y = math.min(bboxData.min_y, point_right[2]-dr);
    bboxData.max_y = math.max(bboxData.max_y, point_right[2]+dr);
      -- LOG("points: " .. point_left[1] .. " " .. point_left[2] .. " " .. point_right[1] .. " " .. point_right[2]);
      -- LOG("x,y range: " .. min_x .. " " .. max_x .. " "  .. min_y .. " "  .. max_y);
  end
	for i = 1, #beautydefined.FaceKey do
    if type(beautydefined.FaceKey[i]) == "table" then
      local index1 = beautydefined.FaceKey[i][1] + 1;
      local index2 = beautydefined.FaceDir[i][2] + 1;
      local dr = config.FaceParamRadius[i][1] * beautyutils.GetDistance(keypoints[index1], keypoints[index2])
			bboxData.min_x = math.min(bboxData.min_x, keypoints[index1][1]-dr);
			bboxData.max_x = math.max(bboxData.max_x, keypoints[index1][1]+dr);
			bboxData.min_y = math.min(bboxData.min_y, keypoints[index1][2]-dr);
			bboxData.max_y = math.max(bboxData.max_y, keypoints[index1][2]+dr);
			
			index1 = beautydefined.FaceKey[i][2] + 1;
      index2 = beautydefined.FaceDir[i][1] + 1;
      dr = config.FaceParamRadius[i][1] * beautyutils.GetDistance(keypoints[index1], keypoints[index2])
			bboxData.min_x = math.min(bboxData.min_x, keypoints[index1][1]-dr);
			bboxData.max_x = math.max(bboxData.max_x, keypoints[index1][1]+dr);
			bboxData.min_y = math.min(bboxData.min_y, keypoints[index1][2]-dr);
			bboxData.max_y = math.max(bboxData.max_y, keypoints[index1][2]+dr);
    end
  end
end

function FaceShin:_Switch(on)
	-- venus editor on/off facial effect's switch
	self.on = on;
	if self.on then
		self.coef = self.coef_temp;
	else
		self.coef = 0;
	end
end

function FaceShin:_SetTempCoef(coef)
	-- venus editor temporary params value, used when switched on
	self.coef_temp = coef;
	if self.on then
		self.coef = self.coef_temp;
	end  
end

-- version num: 0 for likee, 1 for live
function FaceShin:_InitParams(defined)
    beautydefined = defined
    -- 瘦脸参数
    self.coef = self.coef or 0
    self.coef_temp = 1.0;
    -- shader params
    apolloengine.ShaderEntity.UNIFORM_PTS =
        apolloengine.IMaterialSystem:NewParameterSlot(
            apolloengine.ShaderEntity.UNIFORM, "UNIFORM_PTS");
	apolloengine.ShaderEntity.UNIFORM_PTS_MASK =
        apolloengine.IMaterialSystem:NewParameterSlot(
            apolloengine.ShaderEntity.UNIFORM, "UNIFORM_PTS_MASK");
    apolloengine.ShaderEntity.UNIFORM_FACECOEF =
        apolloengine.IMaterialSystem:NewParameterSlot(
            apolloengine.ShaderEntity.UNIFORM, "UNIFORM_FACECOEF");
    apolloengine.ShaderEntity.FACEPARA =
        apolloengine.IMaterialSystem:NewParameterSlot(
            apolloengine.ShaderEntity.UNIFORM, "FACEPARA");
    apolloengine.ShaderEntity.FACEPARARADIUS =
        apolloengine.IMaterialSystem:NewParameterSlot(
            apolloengine.ShaderEntity.UNIFORM, "FACEPARARADIUS");
end

function FaceShin:SetParams(config, shaderParams)
    shaderParams.facepointArray = mathfunction.vector4array();
	shaderParams.facepointMask = mathfunction.vector2array();
    shaderParams.faceParaArray = mathfunction.vector2array();
    shaderParams.faceParamRadiusArray = mathfunction.vector2array();
  
    --  LOG("part 1 iteration time: " .. #facedefined.FaceKey - 1);
    for i = 1, #beautydefined.FaceKey - beautydefined.FaceSingleNum, 1 do
        if type(beautydefined.FaceKey[i]) == "table" then
            shaderParams.faceParaArray:PushBack(
                beautyutils._ArrayToVec2(config.FaceParam[i]));
            shaderParams.faceParaArray:PushBack(
                beautyutils._ArrayToVec2(config.FaceParam[i]));
        end
    end
    for i = #beautydefined.FaceKey - beautydefined.FaceSingleNum + 1, #beautydefined.FaceKey, 1 do
        shaderParams.faceParaArray:PushBack(beautyutils._ArrayToVec2(config.FaceParam[i]));
    end
    for i = 1, beautydefined.NumFaceAddition, 1 do
        shaderParams.faceParaArray:PushBack(
            beautyutils._ArrayToVec2(config.AdditionFaceParam[i]));
        shaderParams.faceParaArray:PushBack(
            beautyutils._ArrayToVec2(config.AdditionFaceParam[i]));
    end

    for i = 1, #beautydefined.FaceKey - beautydefined.FaceSingleNum, 1 do
        if type(beautydefined.FaceKey[i]) == "table" then
            shaderParams.faceParamRadiusArray:PushBack(
                beautyutils._ArrayToVec2(config.FaceParamRadius[i]));
            shaderParams.faceParamRadiusArray:PushBack(
                beautyutils._ArrayToVec2(config.FaceParamRadius[i]));
        end
    end
    for i = #beautydefined.FaceKey - beautydefined.FaceSingleNum + 1, #beautydefined.FaceKey, 1 do
            shaderParams.faceParamRadiusArray:PushBack(
                beautyutils._ArrayToVec2(config.FaceParamRadius[i]));
    end
    for i = 1, beautydefined.NumFaceAddition, 1 do
        shaderParams.faceParamRadiusArray:PushBack(
            beautyutils._ArrayToVec2(config.AdditionRadius[i]));
        shaderParams.faceParamRadiusArray:PushBack(
            beautyutils._ArrayToVec2(config.AdditionRadius[i]));
    end
    --  LOG("faceParaArray size: " .. faceParaArray:Size());
    --  LOG("faceParamRadiusArray size: " .. faceParamRadiusArray:Size());
    --  LOG("forehead: " .. AdditionFaceParam[1][1] .. " " .. AdditionFaceParam[2][1]);
    self:_InitLens(config)
end

function FaceShin:_InitLens(config)
  self.fastlens = {}
  for i = 1, #beautydefined.FaceKeyScript - 1 do
    local index1 = beautydefined.FaceKeyScript[i][1] + 1
    local index2 = beautydefined.FaceDirScript[i][2] + 1;
    local scale = beautydefined.FaceScaleScript[i]
    self.fastlens[#self.fastlens + 1] = Len(index1, index2, beautydefined.FaceParamScript[i][1] * scale, beautydefined.FaceParamScript[i][2] * scale, beautydefined.FaceParamRadiusScript[i])
    index1 = beautydefined.FaceKeyScript[i][2] + 1
    index2 = beautydefined.FaceDirScript[i][1] + 1;
    self.fastlens[#self.fastlens + 1] = Len(index1, index2, beautydefined.FaceParamScript[i][1] * scale, beautydefined.FaceParamScript[i][2] * scale, beautydefined.FaceParamRadiusScript[i])
  end
  local index1 = beautydefined.FaceKeyScript[#beautydefined.FaceKeyScript][1] + 1
  local index2 = beautydefined.FaceDirScript[#beautydefined.FaceKeyScript][2] + 1;
  local scale = beautydefined.FaceScaleScript[#beautydefined.FaceKeyScript]
  self.fastlens[#self.fastlens + 1] = Len(index1, index2, 
    beautydefined.FaceParamScript[#beautydefined.FaceKeyScript][1] * scale, 
    beautydefined.FaceParamScript[#beautydefined.FaceKeyScript][2] * scale, 
    beautydefined.FaceParamRadiusScript[#beautydefined.FaceKeyScript])
end

function FaceShin:_InitQuad(quadnode, shaderParams)
    quadnode:SetParameter(apolloengine.ShaderEntity.UNIFORM_PTS,
                          shaderParams.facepointArray);
	quadnode:SetParameter(apolloengine.ShaderEntity.UNIFORM_PTS_MASK,
                          shaderParams.facepointMask);
    quadnode:SetParameter(apolloengine.ShaderEntity.FACEPARA,
                          shaderParams.faceParaArray);
    quadnode:SetParameter(apolloengine.ShaderEntity.FACEPARARADIUS,
                          shaderParams.faceParamRadiusArray);
    quadnode:SetParameter(apolloengine.ShaderEntity.UNIFORM_FACECOEF,
                          mathfunction.vector2(0.0,0.0));
end

function FaceShin:_DrawQuad(quadnode, keypoints, rate)
    local facePointArray = mathfunction.vector4array();
	local facePointMask = mathfunction.vector2array();
    for i = 1, #beautydefined.FaceKey - beautydefined.FaceSingleNum do
        if type(beautydefined.FaceKey[i]) == "table" then
            local index1 = beautydefined.FaceKey[i][1] + 1;
            local index2 = beautydefined.FaceDir[i][2] + 1;
            facePointArray:PushBack(beautyutils._ArrayToVec4(keypoints[index1],
                                                             keypoints[index2]));
			facePointMask:PushBack(mathfunction.vector2(beautydefined.FaceKeyMask[i],0.0));

            index1 = beautydefined.FaceKey[i][2] + 1;
            index2 = beautydefined.FaceDir[i][1] + 1;
            facePointArray:PushBack(beautyutils._ArrayToVec4(keypoints[index1],
                                                             keypoints[index2]));
			facePointMask:PushBack(mathfunction.vector2(beautydefined.FaceKeyMask[i],0.0));
        end
    end
    --LOG("facePointArray size after dobules points: " .. facePointArray:Size());
    for i = #beautydefined.FaceKey - beautydefined.FaceSingleNum + 1, #beautydefined.FaceKey do
        facePointArray:PushBack(beautyutils._ArrayToVec4(
                                keypoints[beautydefined.FaceKey[i][1] + 1],
                                keypoints[beautydefined.FaceDir[i][2] + 1]));
		facePointMask:PushBack(mathfunction.vector2(beautydefined.FaceKeyMask[i],0.0));
    end
    
    ------------------------------------------------------------------
    local face_point_num = #keypoints;
    for i = 1, beautydefined.NumFaceAddition, 1 do
      local index_left_up = beautydefined.FaceKey[1][1] + 1;
      local index_left_down = beautydefined.FaceKey[2][1] + 1;
      local index_right_up = beautydefined.FaceKey[1][2] + 1;
      local index_right_down = beautydefined.FaceKey[2][2] + 1;

      local point_left = {keypoints[index_left_up][1], keypoints[index_left_up][2]};
      point_left[1] = point_left[1] + beautydefined.DeltaFaceAddition * i *
                          (keypoints[index_left_up][1] -
                              keypoints[index_left_down][1]);
      point_left[2] = point_left[2] + beautydefined.DeltaFaceAddition * i *
                          (keypoints[index_left_up][2] -
                              keypoints[index_left_down][2]);
      local point_right = {keypoints[index_right_up][1], keypoints[index_right_up][2]};
      point_right[1] = point_right[1] + beautydefined.DeltaFaceAddition * i *
                           (keypoints[index_right_up][1] -
                               keypoints[index_right_down][1]);
      point_right[2] = point_right[2] + beautydefined.DeltaFaceAddition * i *
                           (keypoints[index_right_up][2] -
                               keypoints[index_right_down][2]);

      facePointArray:PushBack(
          beautyutils._ArrayToVec4(point_left, point_right));
      facePointMask:PushBack(mathfunction.vector2(1,0.0));
		
      facePointArray:PushBack(
          beautyutils._ArrayToVec4(point_right, point_left));
      facePointMask:PushBack(mathfunction.vector2(1,0.0));
    end
	-- LOG("facePointArray:Size " .. facePointArray:Size());
  quadnode:SetParameter(apolloengine.ShaderEntity.UNIFORM_FACECOEF,
                          mathfunction.vector2(self.coef * rate[1], self.coef * rate[2]));
  quadnode:SetParameter(apolloengine.ShaderEntity.UNIFORM_PTS,
                          facePointArray); 
	quadnode:SetParameter(apolloengine.ShaderEntity.UNIFORM_PTS_MASK,
                          facePointMask); 
end

function FaceShin:_getWarpedKeyPointsDisplacement(keypoints, keypointsDisplacement, aspect_ratio, config, rate)
  if self.coef == 0 then
    return;
  end
  local facedir = {keypoints[75][1] - keypoints[78][1], keypoints[75][2] - keypoints[78][2]};
  facedir[2] = facedir[2] * aspect_ratio
  facedir[1] = facedir[1] / math.sqrt(facedir[1] * facedir[1] + facedir[2] * facedir[2]);
  facedir[2] = facedir[2] / math.sqrt(facedir[1] * facedir[1] + facedir[2] * facedir[2]);
  
  local coef = self.coef * rate[1]
  local tmpDis = {}
  for i = 1, 33 do
    tmpDis[i] = {0, 0}
  end
  
  for i = 1, #self.fastlens do
    local srcIdx = self.fastlens[i]:GetSrcIdx()
    local dstIdx = self.fastlens[i]:GetDstIdx()
    local src = keypoints[srcIdx]
    local dst = keypoints[dstIdx]
    self.fastlens[i]:InitParams(src, dst, facedir, coef, aspect_ratio)
    local tmp = self.fastlens[i]:TransformWarp(src, aspect_ratio)
    tmpDis[srcIdx] = tmp
  end
  beautyutils.LinearInterpolation(tmpDis, 1, 33)
  for i = 1, #tmpDis do
    keypointsDisplacement[i][1] = keypointsDisplacement[i][1] + tmpDis[i][1]
    keypointsDisplacement[i][2] = keypointsDisplacement[i][2] + tmpDis[i][2]
  end
  
  for i = 1, #beautydefined.FaceWarpMap do
    local src = beautydefined.FaceWarpMap[i][1] + 1
    local dst = beautydefined.FaceWarpMap[i][2] + 1
    keypointsDisplacement[src][1] = keypointsDisplacement[src][1] + tmpDis[dst][1] * beautydefined.FaceWarpCoef[i]
    keypointsDisplacement[src][2] = keypointsDisplacement[src][2] + tmpDis[dst][2] * beautydefined.FaceWarpCoef[i]
  end
  if #keypoints >= 240 then
    for i = 1, #beautydefined.AdvFaceWarpMap do
      local src = beautydefined.AdvFaceWarpMap[i][1] + 107
      local dst = beautydefined.AdvFaceWarpMap[i][2] + 1
      keypointsDisplacement[src][1] = keypointsDisplacement[src][1] + tmpDis[dst][1] * beautydefined.AdvFaceWarpCoef[i]
      keypointsDisplacement[src][2] = keypointsDisplacement[src][2] + tmpDis[dst][2] * beautydefined.AdvFaceWarpCoef[i]
    end
    if #keypoints >= 263 then
      for i = 1, #beautydefined.FaceForeheadWarp do
        local src = beautydefined.FaceForeheadWarp[i][1] + 241
        local dst = beautydefined.FaceForeheadWarp[i][2] + 1
        keypointsDisplacement[src][1] = keypointsDisplacement[src][1] + tmpDis[dst][1] * beautydefined.FaceForeheadCoef[i]
        keypointsDisplacement[src][2] = keypointsDisplacement[src][2] + tmpDis[dst][2] * beautydefined.FaceForeheadCoef[i]
      end
    end
  elseif #keypoints >= 129 then
    for i = 1, #beautydefined.FaceForeheadWarp do
      local src = beautydefined.FaceForeheadWarp[i][1] + 107
      local dst = beautydefined.FaceForeheadWarp[i][2] + 1
      keypointsDisplacement[src][1] = keypointsDisplacement[src][1] + tmpDis[dst][1] * beautydefined.FaceForeheadCoef[i]
      keypointsDisplacement[src][2] = keypointsDisplacement[src][2] + tmpDis[dst][2] * beautydefined.FaceForeheadCoef[i]
    end
  end
  
end

function FaceShin:UpdateParaValue(quadnode, config, key_index,
                                  attribute, value)
    local face_point_num = beautydefined.nose_start - 1 - 2;
    if (key_index <= face_point_num) then
        if (attribute == "X") then
            config.FaceParam[key_index][1] = value;
            -- LOG("FaceParam[" .. key_param_table[key_index] .. "][1] set to " .. value);
        end
        if (attribute == "Y") then
            config.FaceParam[key_index][2] = value;
            -- LOG("FaceParam[" .. key_param_table[key_index] .. "][2] set to " .. value);
        end
        if (attribute == "R") then
            config.FaceParamRadius[key_index][1] = value;
            -- LOG("FaceParamRadius[" .. key_param_table[key_index] .. "][1] set to " .. value);
            if (config.FaceParamRadius[key_index][1] < 0.1) then
                config.FaceParamRadius[key_index][1] = 0.1;
            end
        end
    else
        if (attribute == "X") then
            config.AdditionFaceParam[key_index - face_point_num][1] = value;
            -- LOG("AdditionFaceParam[" .. key_index - face_point_num .. "][1] set to " .. value);
        end
        if (attribute == "Y") then
            config.AdditionFaceParam[key_index - face_point_num][2] = value;
            -- LOG("AdditionFaceParam[" .. key_index - face_point_num .. "][2] set to " .. value);
        end
        if (attribute == "R") then
            config.AdditionRadius[key_index - face_point_num][1] = value;
            -- LOG("AdditionRadius[" .. key_index - face_point_num .. "][1] set to " .. value);
            if (config.AdditionRadius[key_index - face_point_num][1] < 0.1) then
                config.AdditionRadius[key_index - face_point_num][1] = 0.1;
            end
        end
    end
    local shaderParams = {}
    self:SetParams(config, shaderParams);
    quadnode:SetParameter(apolloengine.ShaderEntity.FACEPARA,
                          shaderParams.faceParaArray);
    quadnode:SetParameter(apolloengine.ShaderEntity.FACEPARARADIUS,
                          shaderParams.faceParamRadiusArray);
end

function FaceShin:UpdateCoeff(quadnode, value, rate)
    if (value == 1) then
        self.coef = 1.0;
    else
        self.coef = 0.0;
    end
    -- LOG("Face Shin coef set to: " .. self.coef);
    quadnode:SetParameter(apolloengine.ShaderEntity.UNIFORM_FACECOEF,
                          mathfunction.vector2(self.coef * rate,self.coef * rate));
end

function FaceShin:GetParams(config)
    -- LOG("FaceParam size: " .. #config.FaceParam);
    local FullFaceParam = beautyutils.Clone(config.FaceParam);
    local FullFaceParamRadius = beautyutils.Clone(config.FaceParamRadius);
    table.insert(FullFaceParam, config.AdditionFaceParam[1]);
    table.insert(FullFaceParam, config.AdditionFaceParam[2]);
    table.insert(FullFaceParamRadius, config.AdditionRadius[1]);
    table.insert(FullFaceParamRadius, config.AdditionRadius[2]);
    return FullFaceParam, FullFaceParamRadius
end

function FaceShin:SetCoef(coef)
  if coef == nil then
    coef = 0
  end
    self.coef = coef;
    --WARNING("[facelift]: Face Shin coef: " .. self.coef)
end

function FaceShin:Release()
  self.fastlens = {}
end

return FaceShin
