local apolloengine  = require "apolloengine"
local apollonode    = require "apolloutility.apollonode"
local apolloDefine = require "apolloutility.defiend"
local venuscore = require "venuscore"

local AudioRecord = {}

function AudioRecord:Initialize(scene)
    self.node = nil;
    self.audiocomponent = nil;
    self.isInit = false;
end 

function AudioRecord:CreartAudioRecord(cutterScene)
    if cutterScene == nil then
        return false
    end
    if not self.isInit then
        ERROR("AudioRecord:CreartAudioRecord")        
        self.node = cutterScene:CreateNode(apolloengine.Node.CT_NODE);
        self.node:SetName("AudioRecord");
        local sceneid = self.node:GetHostScene():GetStaticID();        
        self.audiocomponent = self.node:CreateComponent(apolloengine.Node.CT_AUDIO_PLAYER)
        self.audiocomponent:SetSceneID(sceneid);
        self.audiocomponent.Mode = 1;
        self.audiocomponent:SetDriverType(2);
        self.audiocomponent.loop = false;
        self.isInit = true;
    end
    return true;
end

function AudioRecord:StartRecord()
    if not self.isInit then
        return false;
    end
    self.audiocomponent:Play();
    return true;
end

function AudioRecord:StopRecord()
    if not self.isInit then
        return false;
    end
    return self.audiocomponent:Stop();
end

function AudioRecord:Clear(cutterScene)
    if self.isInit then
        LOG("AudioRecord:Clear")
        self.isInit = false;
        self.audiocomponent:Stop();
        self.audiocomponent:SetDriverType(1);
        if not venuscore.isNil(self.node) then  --防止Node重复删除(因为删除父Node会递归删除子Node)
          cutterScene:DeleteNode(self.node);
        end
        self.node = nil;
        self.audiocomponent = nil;
    end
    return true;
end

return AudioRecord;