local TransNode = require "apolloutility.apollonode.trasnnode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

--渲染节点
local RenderNode = TransNode:extend();

function RenderNode:new()
  self.isshow = true;
  self.iscaster = true;
  RenderNode.super.new(self)
  self.node:SetName("RenderNode");
  self.render = self.node:CreateComponent(apolloengine.Node.CT_RENDER);
end

--[[function RenderNode:PushTextureMetadata(slot, imagepath)
  self.render:PushMetadata(--传入纹理原始数据
    apolloengine.RenderObjectTextureMetadata(
      slot,
      apolloengine.TextureFileMetadata(imagepath)));
end]]--

function RenderNode:PushTextureMetadata(slot, imagepath, clampMode)
  --[[
    self.render:PushMetadata(--传入纹理原始数据TW_CLAMP_TO_EDGE
    apolloengine.RenderObjectTextureMetadata(
    slot,
    apolloengine.TextureFileMetadata(
      apolloengine.TextureEntity.TU_STATIC,
      apolloengine.TextureEntity.PF_AUTO,
      1, false,
      clampMode or apolloengine.TextureEntity.TW_REPEAT,--默认repeat
      clampMode or apolloengine.TextureEntity.TW_REPEAT,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      imagepath)));]]

  if self.render.MaterialEntities[1]~=nil then
    self.render.MaterialEntities[1]:PushTextureMetadata(--传入纹理原始数据TW_CLAMP_TO_EDGE
    slot,
    apolloengine.TextureFileMetadata(
      apolloengine.TextureEntity.TU_STATIC,
      apolloengine.TextureEntity.PF_AUTO,
      1, false,
      clampMode or apolloengine.TextureEntity.TW_REPEAT,--默认repeat
      clampMode or apolloengine.TextureEntity.TW_REPEAT,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      imagepath));
  else
    if self.ToCreateTexCache==nil then
      self.ToCreateTexCache = {}
    end
    table.insert( self.ToCreateTexCache, {["slot"] = slot, ["tex"] = apolloengine.TextureFileMetadata(
      apolloengine.TextureEntity.TU_STATIC,
      apolloengine.TextureEntity.PF_AUTO,
      1, false,
      clampMode or apolloengine.TextureEntity.TW_REPEAT,--默认repeat
      clampMode or apolloengine.TextureEntity.TW_REPEAT,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      imagepath)});
  end
end

function RenderNode:CreateResource(materialpath, rendermode, vertexstream, indicesstream)
  self.render:PushMetadata(
    apolloengine.RenderObjectMaterialMetadata(
      apolloengine.PathMetadata(materialpath)));
  
  if indicesstream then
  self.render:PushMetadata(
		apolloengine.RenderObjectMeshMetadate( 
			rendermode,
      apolloengine.ReferenceVertexMetadata(        
        apolloengine.VertexBufferEntity.MU_DYNAMIC,--使用可以修改的显存区域
        vertexstream),
      apolloengine.ReferenceIndicesMetadata(
        apolloengine.VertexBufferEntity.MU_STATIC,--使用不可修改的显存区域
        indicesstream)));
  else
    self.render:PushMetadata(
		apolloengine.RenderObjectMeshMetadate( 
			rendermode,
      apolloengine.ReferenceVertexMetadata(        
        apolloengine.VertexBufferEntity.MU_DYNAMIC,--使用可以修改的显存区域
        vertexstream)));
  end  
  
  if self.ToCreateTexCache ~= nil then
    for i=1,#self.ToCreateTexCache do
      local slot = self.ToCreateTexCache[i]["slot"];
      local tex = self.ToCreateTexCache[i]["tex"];
      local materies  = self.render.MaterialEntities;
      for key ,value in pairs(materies) do
        value:PushTextureMetadata(slot,tex);
      end
    end
  end
  
  self.render:CreateResource();
end

function RenderNode:SetJobType(t)
  self.render:SetJobType(t)
end

function RenderNode:SetParameter(slot, value)
  if value then
    self.render:SetParameter(slot, value);
  end  
end

function RenderNode:SetShow(isshow)
  if self.isshow ~= isshow then
    self.isshow = isshow;
    if isshow then
      self.render:SetRenderProperty(apolloengine.RenderComponent.RP_SHOW);
    else
      self.render:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);
    end  
  end
end

function RenderNode:SetShadowCaster(iscaster)
  if self.iscaster ~= iscaster then
    self.iscaster = iscaster;
    if iscaster then
      self.render:SetRenderProperty(apolloengine.RenderComponent.RP_SHADOW_CASTER);
    else
      self.render:EraseRenderProperty(apolloengine.RenderComponent.RP_SHADOW_CASTER);
    end
  end
end


function RenderNode:SetCull(iscull)
  if iscull then
    self.render:SetRenderProperty(apolloengine.RenderComponent.RP_CULL);
  else
    self.render:EraseRenderProperty(apolloengine.RenderComponent.RP_CULL);
  end  
end

function RenderNode:SetBindBox(aabb)
  self.render:SetBindBox(aabb);
end

function RenderNode:GetBindBox()
  return self.render:GetBindBox();
end

--设置摄像机所属的队列
function RenderNode:SetSequence(s)
  self.render:SetSequence(s);
end

function RenderNode:GetSequence()
  return self.render:GetSequence();
end

function RenderNode:GetVertexStream()
  return self.render:GetVertexStream();
end

function RenderNode:GetIndexStream()
  return self.render:GetIndexStream();
end


function RenderNode:RigidBodyComponent(shape, mass) 
  local collisionShape;
  if shape == apolloengine.RigidBodyComponent.CST_BOX then
    local bindbox = self.render:GetOriginalBindBox();
    local halfsize = bindbox:GetExtent();
    collisionShape = apolloengine.BoxShape(halfsize);
  elseif shape == apolloengine.RigidBodyComponent.CST_MESH then
    local vertexstream = self.render:GetVertexStream();
    local indexstream = self.render:GetIndexStream();
    collisionShape = apolloengine.MeshShape(vertexstream, indexstream);
  elseif shape == apolloengine.RigidBodyComponent.CST_SPHERE then
    local bindbox = self.render:GetOriginalBindBox();
    local halfsize = bindbox:GetExtent();
    local x = halfsize:x();
    local y = halfsize:y();
    local z = halfsize:z();
    local radius = x;
    if radius < y then
      radius = y;
    end
    if radius < z then
      radius = z;
    end
    collisionShape = apolloengine.SphereShape(radius);
  end
  RenderNode.super.RigidBodyComponent(self,collisionShape,mass);
end

function RenderNode:SetKeepSource(iskeepsource)
  self.render:SetKeepSource(iskeepsource);
end

function RenderNode:IsRenderProperty(p)
  return self.render:isRenderProperty(p);
end

function RenderNode:SetResourceType(resType)
  self.render:SetResourceType(resType);
end

function RenderNode:GetResourceType()
  return self.render:GetResourceType();
end



return RenderNode;
