#SHADER_DEFINE ParallaxVS

	FUNCTION_INPUT = 
	{
		{ CAMERA_VIEWPROJ,			HIGH,	MAT4,		"in_ViewPorj" },
		{ LOCALWORLD_TRANSFORM,		HIGH,	MAT4,		"in_Transfrom" },
		{ ATTRIBUTE_POSITION, 		HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_NORMAL, 		HIGH,	VEC3,		"in_Normal" },
    { ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_Coord" },
    { UNI_VIEW_POS,            MEDIUM,    VEC3,        "in_ViewPos" },
    { CAMERA_WORLDPOSITION,			MEDIUM,		VEC3,					"in_CameraPosition"},
	}

	FUNCTION_OUTPUT = 
	{
    { ATTRIBUTE_COORDNATE0,            MEDIUM,    VEC2,        "out_Coordinate" },
    { VIEW_DIR,            MEDIUM,    VEC3,        "out_ViewDir" },
	}

#SHADER_CODE
  
    vec4 out_PositionWS  = in_Transfrom * in_Position;
    vec3 out_ViewDir = normalize(out_PositionWS.xyz - in_ViewPos.xyz);
	  vec4 out_Position = in_ViewPorj * out_PositionWS;
    vec2 out_Coordinate = in_Coord;
    out_Coordinate.y = 1.0- out_Coordinate.y;
    gl_Position = out_Position;
    
#END_CODE
#END_DEFINE


#SHADER_DEFINE ParallaxPS

	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,			NONE,			TEXTURE2D,		"uSampler" },
    { TEXTURE_HEIGHT,			NONE,			TEXTURE2D,		"displacementMap" },
    { ATTRIBUTE_COORDNATE0,    MEDIUM,    VEC2,        "vTextureCoord" },
    { VIEW_DIR,            MEDIUM,    VEC3,        "in_ViewDir" },
	}

	FUNCTION_OUTPUT = 
	{
    
	}

#SHADER_CODE


vec4 dimensions = vec4(638.0,235.0,0.0,0.0);

float scale = 1.0;
vec2 offset = in_ViewDir.xy;
float focus = 0.5;

  
float aspect = dimensions.x / dimensions.y;
vec2 scale2 = vec2(scale * min(1.0, 1.0 / aspect), scale * min(1.0, aspect)) * vec2(1, -1) * vec2(1);
vec2 mapCords = vTextureCoord;

float map = 1.0-texture2D(displacementMap, mapCords).r;
map = map * -1.0 + focus;
vec2 disCords = vTextureCoord;
disCords += offset * map * scale2;
gl_FragColor = texture2D(uSampler, disCords) ;

#END_CODE
#END_DEFINE



