#include "functions/util.function"
#SHADER_DEFINE LabcolorVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCoordinate"},
       
	}
	FUNCTION_OUTPUT =
	{
        { ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;  
    vec2 out_TexCooridate;
    out_TexCooridate= in_TexCoordinate.xy;     // upper left corner
 
#END_CODE

#END_DEFINE


#SHADER_DEFINE LabcolorFragment

	FUNCTION_INPUT = 
	{
        { TEXTURE_uDab,		    	NONE,	TEXTURE2D,	  "uImage" },
		{ TEXTURE_uLut,		    	NONE,	TEXTURE2D,	  "uLut" },
        { ATTRIBUTE_COORDNATE0,		HIGH,	VEC2,	"vUV"},
		{ UNIFORM_uGa,				HIGH,	FLOAT,	"uGa"},
   	}
  
#SHADER_CODE

    gl_FragColor = texture2D(uImage, vUV);
	gl_FragColor.rgb = LUT(vec4(gl_FragColor.rgb,1.0),uLut).rgb;
    gl_FragColor.rgb = rgb2lab(gl_FragColor.rgb);
    gl_FragColor.r = pow(gl_FragColor.r, uGa);
 
#END_CODE

#END_DEFINE