#include "functions/warp.function"

#SHADER_DEFINE BiggerEyesVertex

    FUNCTION_INPUT =
    {
        { ATTRIBUTE_POSITION,      HIGH,    VEC4,       "in_Position" },
        { ATTRIBUTE_COORDNATE0,    HIGH,    VEC2,       "in_TexCooridate"},
        { UNIFORM_RATIOASPECT,    MEDIUM,    FLOAT,        "aspectRatio"},
        { UNIFORM_FACESNUM,       MEDIUM,    FLOAT,        "facesNum"},
        { UNIFORM_FACES_BOX,        HIGH,    VEC4_ARRAY,   "facesBox", "3"},
        { UNIFORM_LEFT_EYES,         HIGH,    VEC2_ARRAY,   "leftEyes", "33" },
        { UNIFORM_RIGHT_EYES,        HIGH,    VEC2_ARRAY,   "rightEyes", "33"},
        { UNIFORM_MOUSE,            HIGH,    VEC2_ARRAY,   "mouse", "60"},
        { UNIFORM_LEFT_PTS,         HIGH,    VEC2_ARRAY,   "leftContourPoints", "48"},
        { UNIFORM_RIGHT_PTS,        HIGH,    VEC2_ARRAY,   "rightContourPoints", "48"},
        { UNIFORM_CHIN,             MEDIUM,    VEC2_ARRAY,   "chin", "3"},
        { UNIFORM_NOSE,             HIGH,     VEC2_ARRAY,   "nose", "51"},
        { UNIFORM_FOREHEAD,        HIGH,     VEC2_ARRAY,      "forehead", "18"},//额头补点
        { UNIFORM_FACECOEF,         HIGH,     VEC2,           "faceCoef"},//普通瘦脸1
        { UNIFORM_EYE_LARGE,        HIGH,       VEC2,         "eyeLarge"},//大眼2
        { UNIFORM_FACE_NARROW,      HIGH,       VEC2,         "narrowfaceCoef"},//窄脸3
        { UNIFORM_CHIN_LENG,        MEDIUM,     FLOAT,        "lengchinCoef"},//下巴长短4
        { UNIFORM_NOSE_NARROW,      MEDIUM,     FLOAT,        "narrownoseCoef"},//瘦鼻5
        { UNIFORM_NOSE_LENG,        MEDIUM,     FLOAT,        "lengnoseCoef"},//鼻子长短6
        { UNIFORM_CANTHUS_OPEN,     HIGH,       VEC2,         "opencanthus"}, //开眼角 7  
        { UNIFORM_CANTHUS_ANGLE,    HIGH,       VEC2,         "anglecanthus"}, //眼角角度       
        { UNIFORM_EYE_DIS,          MEDIUM,     FLOAT,        "diseye"},//眼距
        { UNIFORM_MOUTH,            MEDIUM,     FLOAT,        "mouthCoef"},//嘴型
        { UNIFORM_LINE_HAIR,        MEDIUM,     FLOAT,        "hairline"},//发际线
        { UNIFORM_NOSE_HUMP,        MEDIUM,     FLOAT,        "nosehump"},//侧脸隆鼻
        { UNIFORM_NOSE_HUMP_RATE,   MEDIUM,     FLOAT,        "nosehump_rate"},//侧脸隆鼻
        { UNIFORM_PHILTRUM_LENG,    MEDIUM,     FLOAT,        "lengphiltrum"},//人中长短
        { UNIFORM_MACINTOSH,        MEDIUM,     FLOAT,            "macintosh"},//苹果肌

         
    }
    FUNCTION_OUTPUT =
    {
        { ATTRIBUTE_COORDNATE0,    HIGH,    VEC2,       "out_TexCooridate" },
    }

#SHADER_CODE
    gl_Position = in_Position;
    
    const int halfFaceNum = 9;
    const int halfChinNum = 7;
    const int halfEyeNum = 9;
    vec2 positionToUse  = in_TexCooridate * 2.0 - 1.0;

    int num = int(facesNum);
    for(int i = 0; i < num; ++i)
    {
      float alpha = 0.0;
      // eye1
      float eyeRadius = distance( mouse[i*20], mouse[i*20+6])*0.33;
      if(eyeLarge.x >=0.01)
      {
        float dis_eye1 = distance(vec2(positionToUse.x,positionToUse.y*aspectRatio), vec2(leftEyes[i*11+9].x,leftEyes[i*11+9].y*aspectRatio));
        if(dis_eye1 <= eyeRadius)
        {
           alpha = pow(dis_eye1 / eyeRadius, eyeLarge.x);
           positionToUse.x = leftEyes[i*11+9].x +(positionToUse.x - leftEyes[i*11+9].x) * alpha;
           positionToUse.y = leftEyes[i*11+9].y +(positionToUse.y - leftEyes[i*11+9].y) * alpha;
        }
       
      }
      // eye2   
     if(eyeLarge.y >=0.01)
     {
       float dis_eye2 = distance(vec2(positionToUse.x,positionToUse.y*aspectRatio),vec2(rightEyes[i*11+9].x,rightEyes[i*11+9].y*aspectRatio));            
       if(dis_eye2 <= eyeRadius)
       {
         alpha = pow(dis_eye2 / eyeRadius,eyeLarge.y);
         positionToUse.x = rightEyes[i*11+9].x +(positionToUse.x - rightEyes[i*11+9].x) * alpha;
         positionToUse.y = rightEyes[i*11+9].y +(positionToUse.y - rightEyes[i*11+9].y) * alpha;
       }
     }
     //鼻子中心的点
     vec2 curNose = nose[i*13+4];
     vec2 curChin = chin[i];  
     vec2 chinCenter = curNose + (curChin - curNose) * 0.7;
     float face_width = distance(leftEyes[i*11+9],rightEyes[i*11+9]);
       
     //下巴最下面一个点
     float normalScale = 1.0;
		 vec2 leftF = vec2(0.0);
     vec2 targetleftF = vec2(0.0);
     vec2 leftFplus = vec2(0.0);
     vec2 rightF = vec2(0.0);
     vec2 targetrightF = vec2(0.0);
     vec2 rightFplus = vec2(0.0);
     
     float curRadius = face_width*1.0;
       //脸两侧左右的点9,23
       if(faceCoef.x >=0.01)
       {
         normalScale = 1.0 -faceCoef.x*0.1;
         leftF = leftContourPoints[i*16+9];    
         targetleftF = curNose + (leftF - curNose) * normalScale ;
         leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
         positionToUse = positionToUse - leftFplus;
       }
       if(faceCoef.y >=0.01)
       {
         normalScale = 1.0 -faceCoef.y*0.1;
         rightF = rightContourPoints[i*16+9];
         targetrightF = curNose + (rightF - curNose) * normalScale ;
         rightFplus = faceStretch(positionToUse, rightF, targetrightF, curRadius, 1.0);
         positionToUse = positionToUse - rightFplus;
       }
       ////收下巴点位13，19
       curRadius = face_width*1.2;
       if(faceCoef.x >=0.01)
       {
         normalScale = 1.0 -faceCoef.x*0.1;
         
         leftF = vec2(leftContourPoints[i*16+14].x, leftContourPoints[i*16+14].y);
         targetleftF = chinCenter + (leftF - chinCenter) *  normalScale;
         leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
         positionToUse = positionToUse - leftFplus;
       }
       if(faceCoef.y >=0.01)
       {
         normalScale = 1.0 -faceCoef.y*0.1;
         rightF = vec2(rightContourPoints[i*16+14].x, rightContourPoints[i*16+14].y);
         targetrightF = chinCenter + (rightF - chinCenter) *  normalScale;
         rightFplus = faceStretch(positionToUse, rightF, targetrightF, curRadius, 1.0);
         positionToUse = positionToUse - rightFplus;
       }
       
     //微整形的半径要小，不能影响其他部位
     //窄脸微整形:脸两侧左右的点10,22  
     
     curRadius = face_width*0.2;
     for(int j= 2;j<12;++j)
     {
       if(narrowfaceCoef.x >=0.01)
       {
         normalScale = 1.0 -narrowfaceCoef.x*0.02;
         leftF = leftContourPoints[i*16+j];    
         targetleftF = curNose + (leftF - curNose) * normalScale ;
         leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
         positionToUse = positionToUse - leftFplus;
       }
       if(narrowfaceCoef.y >=0.01)
       {
         normalScale = 1.0 -narrowfaceCoef.y*0.02;
         rightF = rightContourPoints[i*16+j];
         targetrightF = curNose + (rightF - curNose) * normalScale ;
         rightFplus = faceStretch(positionToUse, rightF, targetrightF, curRadius, 1.0);
         positionToUse = positionToUse - rightFplus;
       }
     }
     //下巴长短
     if(lengchinCoef >=0.01||lengchinCoef <= -0.01)
     {
       curRadius = face_width*0.2;
       normalScale = 1.0 + lengchinCoef*0.025;//+或者-为拉长或者变短
       vec2 targetchin = mouse[i*20+9]  +(curChin - mouse[i*20+9]) *  normalScale;
       vec2 noseplus = vec2(0.0);
       noseplus = faceStretch(positionToUse, curChin, targetchin, curRadius, 1.0);
       positionToUse = positionToUse - noseplus;
       float k = 0.25;
       for(int j= 12;j<16;++j)
       {
         leftF = leftContourPoints[i*16+j];    
         targetleftF = leftF + (targetchin - curChin)*k ;
         leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
         positionToUse = positionToUse - leftFplus;
       
         rightF = rightContourPoints[i*16+j];
         targetrightF = rightF + (targetchin - curChin)*k ;
         rightFplus = faceStretch(positionToUse, rightF, targetrightF, curRadius, 1.0);
         positionToUse = positionToUse - rightFplus;
         k = k+0.25;
       }
     }
     //瘦鼻子
     curRadius = face_width*0.2;
     if(narrownoseCoef >=0.01)
     {
       normalScale = 1.0 - narrownoseCoef*0.1;
       for(int j= 5;j<8;++j)
       {   
           leftF = nose[i*13+j]; 
           rightF = nose[i*13+j+4];
           vec2 target = (leftF+rightF)/2.0;
           targetleftF = target + (leftF - target) * normalScale ;
           leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
           positionToUse = positionToUse - leftFplus;
           targetrightF = target + (rightF - target) * normalScale ;
           rightFplus = faceStretch(positionToUse, rightF, targetrightF, curRadius, 1.0);
           positionToUse = positionToUse - rightFplus;
       }
     }
     //鼻子长短：往下或者往上移
     curRadius = face_width*0.2;
     if(lengnoseCoef >=0.01 || lengnoseCoef <= -0.01)
     {
       normalScale = lengnoseCoef*0.01;//+或者-为拉长或者变短
       vec2 targetNose = (curChin - curNose) *  normalScale ;
       
       for(int j= 0;j<13;++j)
       {
         leftF = nose[i*13+j];    
         targetleftF = leftF + targetNose;
         leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
         positionToUse = positionToUse - leftFplus;
       }
     }
     //开眼角 
     curRadius = face_width*0.2;
     if(opencanthus.x >=0.01 )
     {
       normalScale = 1.0 - opencanthus.x*0.03;
     
       vec2 target = nose[i*13];
      
       leftF  = leftEyes[i*11+4]; 
       targetleftF = target + (leftF - target) * normalScale ;
       leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
       positionToUse = positionToUse - leftFplus;
     }
     if(opencanthus.y >=0.01)
     {
       normalScale = 1.0 - opencanthus.y *0.03;
       vec2 target = nose[i*13];
       rightF = rightEyes[i*11+4];
       targetrightF = target + (rightF - target) * normalScale ;
       rightFplus = faceStretch(positionToUse, rightF, targetrightF, curRadius, 1.0);
       positionToUse = positionToUse - rightFplus;
     }
     //眼睛角度：以眼球为中心，两边的点上移或者下移
     if(anglecanthus.x >=0.0001)
     {
        curRadius = face_width*0.1;
        normalScale = 0.99;
        vec2 leftEye  = leftEyes[i*11+9]; 
        vec2 rightEye  = rightEyes[i*11+9];
        for(int j=0;j<8;j++)
        {
          
          leftF = leftEyes[i*11 + j]; 
          targetleftF.x = (leftF.x - leftEye.x)*cos(anglecanthus.x) - (leftF.y - leftEye.y)*sin(anglecanthus.x) + leftEye.x  ;
          targetleftF.y = (leftF.x - leftEye.x)*sin(anglecanthus.x) + (leftF.y - leftEye.y)*cos(anglecanthus.x) + leftEye.y  ;
          leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
          positionToUse = positionToUse - leftFplus; 
        }
     }
     if(anglecanthus.y >=0.0001)
     { 
       curRadius = face_width*0.1;
       normalScale = 0.99;
       vec2 rightEye  = rightEyes[i*11+9];
       for(int j=0;j<8;j++)
       {
         rightF = rightEyes[i*11 + j]; 
         targetrightF.x = (rightF.x - rightEye.x)*cos(-anglecanthus.y ) - (rightF.y - rightEye.y)*sin(-anglecanthus.y ) + rightEye.x  ;
         targetrightF.y = (rightF.x - rightEye.x)*sin(-anglecanthus.y ) + (rightF.y - rightEye.y)*cos(-anglecanthus.y ) + rightEye.y  ;
         rightFplus = faceStretch(positionToUse, rightF, targetrightF, curRadius, 1.0);
         positionToUse = positionToUse - rightFplus; 
       } 
     }
     //眼距 两只眼睛往中间或者两边移动
     if(diseye >=0.01 || diseye <= -0.01)
     {
       curRadius = face_width*0.2;
       normalScale = diseye*0.01;//+或者-为拉长或者变短
       vec2 leftEye  = leftEyes[i*11+9]; 
       vec2 rightEye  = rightEyes[i*11+9];
       vec2 eyeCenter = (leftEye+rightEye)/2.0;
       vec2 targetEyeL = leftEye  +(eyeCenter - leftEye) *  normalScale;
       vec2 targetEyeR = rightEye  +(eyeCenter - rightEye) *  normalScale;
       vec2 leftdis = targetEyeL - leftEye;
       vec2 rightdis = targetEyeR - rightEye ;
       
       for(int j= 0;j<10;++j)
       {
         leftF = leftEyes[i*11+j];    
         targetleftF = leftF + leftdis ;
         leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
         positionToUse = positionToUse - leftFplus;
         
         rightF = rightEyes[i*11+j];    
         targetrightF = rightF + rightdis ;
         rightFplus = faceStretch(positionToUse, rightF, targetrightF, curRadius, 1.0);
         positionToUse = positionToUse - rightFplus;
       }
     }
     //嘴型
     if(mouthCoef >=0.01 || mouthCoef <= -0.01)
     {
       curRadius = face_width*0.2;
       normalScale = 1.0 - mouthCoef*0.1;
       vec2 mouthCenter =( mouse[i*20+14] +  mouse[i*20+18] )/2.0 ;   //98- 14  102-18
       
       for(int j= 0;j<12;++j)
       {
          leftF = mouse[i*20+j];    
          targetleftF = mouthCenter + (leftF - mouthCenter) * normalScale ;
          leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
          positionToUse = positionToUse - leftFplus;
       }
     }
       //人中长短  49 87
     if(lengphiltrum >=0.01 || lengphiltrum <= -0.01)
     {
       curRadius = face_width*0.2;
       normalScale = lengphiltrum*0.01;//+或者-为拉长或者变短
       vec2 mouthUp  = mouse[i*20+3]; 
       vec2 noseBottom  = nose[i*13+4];
       vec2 targetVec2 =(noseBottom - mouthUp) *  normalScale ;
       
       for(int j= 0;j<12;++j)
       {
         leftF = mouse[i*20+j];    
         targetleftF = leftF + targetVec2 ;
         leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
         positionToUse = positionToUse - leftFplus;
       }
      }
     
     //侧脸隆鼻,43,44,45三个点做一个平均向量，逆时针旋转90度，为三个点的平移向量
     if(((nosehump_rate >= 20.0 && nosehump_rate <= 30.0) || (nosehump_rate >= -30.0 && nosehump_rate <= -20.0) )&& nosehump >= 0.01)
     {
       curRadius = face_width*0.2;
       vec2 nose46 = nose[i*13+0];
       vec2 nose44 = nose[i*13+1];
       vec2 nose45 = nose[i*13+2];
       
       vec2 v1 = nose45 - nose44;
       vec2 v2 = nose46 - nose45;
       vec2 v = (v1+v2)*0.5;
       
       //逆时针旋转90度
       vec2 v90;
       
      if(nosehump_rate>0.0)
      {
        v90.x = v.x*cos(90.0) - v.y*sin(90.0);
        v90.y = v.x*sin(90.0) + v.y*cos(90.0);
      }
      else
      {
        v90.x = v.x*cos(-90.0) - v.y*sin(-90.0);
        v90.y = v.x*sin(-90.0) + v.y*cos(-90.0);
      }
      
       normalScale = nosehump*0.3;//+或者-为拉长或者变短
       vec2 tempNose = v90 *  normalScale ;
       
       for(int j= 1;j<4;++j)
       {
         leftF = nose[i*13+j];    
         targetleftF = leftF - tempNose;
         leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
         positionToUse = positionToUse - leftFplus;
       }
     }
     //苹果肌macintosh
     if(macintosh >= 0.01)
     {
       leftF  = (leftContourPoints[3]  + nose[5])*0.5;
       rightF = (rightContourPoints[3] + nose[9])*0.5;
       
       vec2 v1 = leftContourPoints[0]  - leftContourPoints[1];
       vec2 v2 = rightContourPoints[0] - rightContourPoints[1];
       
       curRadius = face_width*0.2;
       normalScale = macintosh*0.002;
       
       vec2 temp = v1 *  normalScale ;
       
       targetleftF = leftF + temp;
       leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
       positionToUse = positionToUse - leftFplus;
       
       temp = v2 *  normalScale ;
       targetrightF = rightF + temp;
       rightFplus = faceStretch(positionToUse, rightF, targetrightF, curRadius, 1.0);
       positionToUse = positionToUse - rightFplus;
     }
     //发际线
     if(hairline >= 0.01)
     {
        normalScale = 1.0 - hairline*0.028;
        curRadius = face_width*0.4;
       for(int j= 1;j<6;++j)
       {   
           leftF = forehead[i*8+j]; 
           vec2 target = forehead[0];
           targetleftF = target + (leftF - target) * normalScale ;
           leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
           positionToUse = positionToUse - leftFplus;
       }
     }
      
    }
    vec2 out_TexCooridate =  0.5 * positionToUse + 0.5;
    //vec2 out_TexCooridate = in_TexCooridate;
#END_CODE
#END_DEFINE



#SHADER_DEFINE BiggerEyesFragment

    FUNCTION_INPUT =
    {
        { TEXTURE_DIFFUSE,          NONE,    TEXTURE2D,    "inputImageTexture" },
        { ATTRIBUTE_COORDNATE0,     HIGH,    VEC2,         "textureCoordinate" },

    }

#SHADER_CODE

    gl_FragColor = texture2D(inputImageTexture,textureCoordinate);


#END_CODE
#END_DEFINE
