#DEFPARAMS
#END

#DEFTAG
ShaderName = "WarpPerspective"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag

struct appdata   
{
	float2 vertex           : POSITION;
	float2 uv               : TEXCOORD0;
};

struct v2f
{
	float2 uv               : TEXCOORD0;
	float4 vertex           : SV_POSITION;
};

Texture2D    TEXTURE0;
SamplerState TEXTURE_Sampler;
float        WIDTH;
float        HEIGHT;
float3x3     HOMOGRAPHYMAT;

v2f vert(appdata v)
{
	v2f o;
   
	o.uv = v.uv;
    o.vertex = float4(v.vertex, 0.0, 1.0);
	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    // Texture coordinates will run [0,1],[0,1];
    // Convert to "real world" coordinates
    float3 newCoordinate = float3(i.uv.x * WIDTH, i.uv.y * HEIGHT, 1.0);
    // Determine translated x and y coordinates
    float3  ori = mul(newCoordinate, HOMOGRAPHYMAT);
    
     // Normalize back to [0,1],[0,1] space
    float2 coords = float2(ori.x / ori.z / WIDTH, ori.y / ori.z / HEIGHT);
    mainColor = TEXTURE0.Sample(TEXTURE_Sampler, coords);
}
ENDCG
#END




