local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local venuscore = require "venuscore"
local mathfunction = require "mathfunction"
local defined = require "superme3d.defined"
local beholder = require "superme3d.observer"
local utility = require "superme3d.utility"
local Object = require "classic"


local NodeManager = {}

local bonenamemapping = 
{
  "Bip01_R_UpperArm",
  "Bip01_R_Forearm",
  "Bip01_R_Hand",
  "Bip01_L_UpperArm",
  "Bip01_L_Forearm",
  "Bip01_L_Hand",
  "Bip01_R_Thigh",
  "Bip01_R_Calf",
  "Bip01_R_Foot",
  "Bip01_L_Thigh",
  "Bip01_L_Calf",
  "Bip01_L_Foot",
  "Bip01_Neck",
  "Bip01_Head",
}

local function _CreateSmallCube()
  local target = apollonode.MeshNode();
  target:CreateResource(
    "comm:documents/model/cube.mesh", 
    "comm:documents/material/lightingonly.material");
  target:SetBindBox(
    mathfunction.Aabbox3d(
      mathfunction.vector3(-0.5,-0.5,-0.5),
      mathfunction.vector3(0.5,0.5,0.5)));
  target:SetLocalScale( mathfunction.vector3(0.13,0.13,0.13) );
  return target;
end

function NodeManager:Initialize()
  self.parentNode = apollonode.TransNode();
  --self.parentNode:SetLocalScale(mathfunction.vector3(0.8,0.8,0.8));
  --self.parentNode:SetLocalPosition(mathfunction.vector3(0,0.02,0.0));
  self.itemType2meshNodes = {};
  self.itemType2exclusionType = {};
  self.bullet = {};
  self.skeletonNode = nil;
  

  --注册监听事件
  self:RegisterEvents();
  

  
end

function NodeManager:RegisterEvents()
  self.OnCreateMeshNodeEvent = utility:CreateInovation(self,self.ChangeMeshNode)
  self.OnCreateMeshNodeFinishedEvent = utility:CreateInovation(self,self.ChangeMeshNodeFinished);
  self.OnCreateSkeletonFinishedEvent = utility:CreateInovation(self,self.SkeletonLoaded);
  self.OnCreateBulletFinishedEvent = utility:CreateInovation(self,self.BulletLoaded);
  self.OnUpdateEvent = utility:CreateInovation(self,self.Update);

  beholder.observe(defined.Event.ON_CREATE_MESH_NODE,self.OnCreateMeshNodeEvent);
  beholder.observe(defined.Event.ON_CREATE_MESH_NODE_FINISHED,self.OnCreateMeshNodeFinishedEvent);
  beholder.observe(defined.Event.ON_CREATE_SKELETON_FINISHED,self.OnCreateSkeletonFinishedEvent);
  beholder.observe(defined.Event.ON_CREATE_BULLET_FINISHED,self.OnCreateBulletFinishedEvent);
  beholder.observe(defined.Event.ON_UPDATE,self.OnUpdateEvent);
end



function NodeManager:_ProcessDefaultUnits()
  for k,v in pairs(self.itemType2exclusionType) do
    local itemType = k;
    local exclusionList = v;
    for i = 1, #exclusionList do
      local exclusionType = exclusionList[i];
      if self.itemType2meshNodes[exclusionType] ~= nil then
        self.itemType2meshNodes[itemType]:SetShow(false);
      end
    end
  end
end


function NodeManager:ChangeMeshNodeFinished()
  self:_ProcessDefaultUnits();  --处理默认部件显示与否
end

--骨骼和动画解析完毕
function NodeManager:SkeletonLoaded(SkeletonNodeInfo)
  --skeletonNode
  self.skeletonNode = SkeletonNodeInfo[2];
  self.skeletonNodePose = SkeletonNodeInfo[3];
  
  for k,v in pairs(self.itemType2meshNodes) do
    --skinrendernode
    v:SetSkeleton(SkeletonNodeInfo);
  end
  
    self.cubes = {}
  --for _, name in ipairs(bonenamemapping) do
   -- local cube = _CreateSmallCube()
   -- self.cubes[name] = cube;
  --  self.cubes[name]:SetShow(false);
  --end
  
end

function NodeManager:BulletLoaded(Bulletnode)
	table.insert(self.bullet, Bulletnode);
end


function NodeManager:ChangeMeshNode(meshNodeInfo)
  local itemType = meshNodeInfo[1];   --itemType是部件分类（比如：上装，下装，鞋子，袜子..)
  local exclusionInfo = meshNodeInfo[2];  --这里面包含的部件被夹在，则此部件隐藏（换装方案)
  local meshNode = meshNodeInfo[3];
  
  local currentNode = self.itemType2meshNodes[itemType];
  if currentNode then
    currentNode:SetShow(false);
    currentNode = nil; --释放？
  end
  self.itemType2meshNodes[itemType] = meshNode;
  self.parentNode:AttachNode(meshNode);
  if exclusionInfo then
    self.itemType2exclusionType[itemType] = exclusionInfo;
  end
  
  meshNode:SetShow(true);
end


--{def, pos3d}
function NodeManager:Update(data)
  
  local def = data[1];
  local pos3d = data[2];
  local targets = nil;
  if self.skeletonNodePose then 
    targets = self.skeletonNodePose:UpdateSkeleton(pos3d);
    self.skeletonNode:UpdateTargetsAndKinematics(targets);
  else
    targets = self.skeletonNode:UpdateSkeleton(pos3d);
  end
  

  --
  
  --for _, name in ipairs(bonenamemapping) do
      --self.cubes[name]:SetLocalPosition(targets[name]);
  --end
  --if self.skeletonNode then
  ----  self.skeletonNode:UpdateAnimation(def);  --更新动画
  
    --for name, pos in pairs(target) do    
    --  self.skeletonNode:SetTarget(name, pos);
    --end  
    --self.skeletonNode:UpdateKinematics();
  --end

  
  --for k,v in pairs(self.itemType2meshNodes) do  --更新每一个部件
  --  v:Update(def);
  --end
  --[[
  if self.bullet ~= nil then
    apolloengine.IPhysicSystem:Update(def,10,1.0/60.0);
    for k,v in pairs(self.bullet) do
      v:update();
    end
  end
  --]]
end


function NodeManager:ReleaseResource()
  self.itemType2meshNodes = {};
  self.skeletonNode = nil;
  self.parentNode = nil;
end

NodeManager:Initialize();

return NodeManager;


