local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

--简单meshode
local MeshNode = apollonode.RenderNode:extend();
function MeshNode:new()
  MeshNode.super.new(self)
  self.uniformList = {};
  
  --test
  self.rotation = mathfunction.Quaternion();

  self.begintime = venuscore.ITimerSystem:GetTimevalue();
end

function MeshNode:SetMaterialPath(materialpath)
  self.render:PushMetadata(
      apolloengine.RenderObjectMaterialMetadata(
        apolloengine.PathMetadata(materialpath)));
end


function MeshNode:SetMaterialBuffer(materialbuffer)
end

function MeshNode:SetMeshPath(meshpath,memoryusage)
  if memoryusage == nil then
    memoryusage = apolloengine.VertexBufferEntity.MU_STATIC;
  end   

  self.render:PushMetadata(
		apolloengine.RenderObjectMeshFileMetadate(memoryusage, meshpath));
end

function MeshNode:SetupUniforms(slot,value)
  table.insert(self.uniformList,{slot,value});
end

function MeshNode:_ApplyUniform()
  local uniformCnt = #self.uniformList;
  for i = 1, uniformCnt do
    self:SetParameter(self.uniformList[i][1],self.uniformList[i][2]);
  end
end

function MeshNode:PushTextureMetadataUsingMipmap(slot, imagepath, clampMode)
    self.render:PushMetadata(--传入纹理原始数据TW_CLAMP_TO_EDGE
    apolloengine.RenderObjectTextureMetadata(
    slot,
    apolloengine.TextureFileMetadata(
      apolloengine.TextureEntity.TU_STATIC,
      apolloengine.TextureEntity.PF_AUTO,
      1, true,
      clampMode or apolloengine.TextureEntity.TW_REPEAT,--默认repeat
      clampMode or apolloengine.TextureEntity.TW_REPEAT,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR_MIPMAP_LINEAR,
      imagepath)));
end

function MeshNode:CreateResource()
  local res = self.render:CreateResource();
  self:_ApplyUniform();
  return res;
end

function MeshNode:Update(def)
  --self.rotation = self.rotation * mathfunction.Mathutility:RotateAxis(
  --mathfunction.vector3(0,1,0), math.pi / 4 * def);
  --self:SetLocalRotation(self.rotation);
  --local position = self:GetLocalPosition();
  --position = position + mathfunction.vector3(0.0,0.0,-0.02) * def;
  --self:SetLocalPosition(position);
end













return MeshNode;