
local apollonode = require "apolloutility.apollonode"
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"


local HairMaterial = {};

--外部会调用此接口创建材质
function HairMaterial:SetupMaterial(meshNode)
  self:_InitializeArtfriend();
  self:_SetupHairArtfriend(meshNode);
end

function HairMaterial:_InitializeArtfriend()

  apolloengine.ShaderEntity.TANGENT_DIRECTION = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"TANGENT_DIRECTION");

  apolloengine.ShaderEntity.TEXTURE_DIFFUSE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"TEXTURE_DIFFUSE");

  apolloengine.ShaderEntity.WORLDSPACE_VIEWDIRECTION = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"WORLDSPACE_VIEWDIRECTION");

  --世界空间转到切线空间的矩阵
  apolloengine.ShaderEntity.W2T_TBN_MAT = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"W2T_TBN_MAT");

  --切线空间转到世界空间的矩阵
  apolloengine.ShaderEntity.T2W_TBN_MAT = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"T2W_TBN_MAT");

  apolloengine.ShaderEntity.LIGHTING_DIFFUSE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"LIGHTING_DIFFUSE");

  apolloengine.ShaderEntity.LIGHTING_SPECULAR = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"LIGHTING_SPECULAR");

  apolloengine.ShaderEntity.LIGHTING_AMBIENT = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"LIGHTING_AMBIENT");

  apolloengine.ShaderEntity.DIFFUSE_SCALE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"DIFFUSE_SCALE");

  apolloengine.ShaderEntity.SPECULAR_SCALE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"SPECULAR_SCALE");


  -- 有关高光的设置参数

  -- 纵向M的偏移
  apolloengine.ShaderEntity.ALPHA_R = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"ALPHA_R");

  apolloengine.ShaderEntity.ALPHA_TT = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"ALPHA_TT");

  apolloengine.ShaderEntity.ALPHA_TRT = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"ALPHA_TRT");

  -- 纵向M的方差变化（variance of lobe）
  apolloengine.ShaderEntity.BETA_R = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"BETA_R");

  apolloengine.ShaderEntity.BETA_TT = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"BETA_TT");

  apolloengine.ShaderEntity.BETA_TRT = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"BETA_TRT");

  -- 方位角宽度
  apolloengine.ShaderEntity.YITA_TT = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"YITA_TT");
  --Glints 的方位角宽度
  apolloengine.ShaderEntity.YITA_G = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"YITA_G");

  -- Glints相对强度
  apolloengine.ShaderEntity.INTENSITY_G = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"INTENSITY_G");
  -- 其他各分量的相对强度
  apolloengine.ShaderEntity.INTENSITY_R = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"INTENSITY_R");

  apolloengine.ShaderEntity.INTENSITY_TT = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"INTENSITY_TT");

  apolloengine.ShaderEntity.INTENSITY_TRT = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"INTENSITY_TRT");

  -- 两个Glints之间的半角度
  apolloengine.ShaderEntity.G_ANGLE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"G_ANGLE");

  -- 各分量的颜色
  apolloengine.ShaderEntity.COLOR_R = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"COLOR_R");

  apolloengine.ShaderEntity.COLOR_TT = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"COLOR_TT");

  apolloengine.ShaderEntity.COLOR_TRT = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"COLOR_TRT");

end

function HairMaterial:_SetupHairArtfriend(hairNode)
  hairNode:SetLocalScale(mathfunction.vector3(1.0, 1.0, 1.0));
  hairNode:SetLocalPosition(mathfunction.vector3(0.0, 0.0, 0.0));
  hairNode:SetMaterialPath("comm:documents/material/ske4bmathairartfriend.material");
  hairNode:SetupUniforms(apolloengine.ShaderEntity.TANGENT_DIRECTION, mathfunction.vector3(1.0,0.0,0.0));
  hairNode:SetupUniforms(apolloengine.ShaderEntity.DIFFUSE_SCALE, mathfunction.vector1(1.0));
  hairNode:SetupUniforms(apolloengine.ShaderEntity.SPECULAR_SCALE, mathfunction.vector1(1.0));

  local alphaR = -10.0;
  hairNode:SetupUniforms(apolloengine.ShaderEntity.ALPHA_R, mathfunction.vector1(alphaR));
  hairNode:SetupUniforms(apolloengine.ShaderEntity.ALPHA_TT, mathfunction.vector1(-alphaR/2.0));
  hairNode:SetupUniforms(apolloengine.ShaderEntity.ALPHA_TRT, mathfunction.vector1(-alphaR*3.0/2.0));

  local betaR = 5.0;
  hairNode:SetupUniforms(apolloengine.ShaderEntity.BETA_R, mathfunction.vector1(betaR));
  hairNode:SetupUniforms(apolloengine.ShaderEntity.BETA_TT, mathfunction.vector1(betaR/2.0));
  hairNode:SetupUniforms(apolloengine.ShaderEntity.BETA_TRT, mathfunction.vector1(betaR * 3.0/2.0));

  local yitaTT = 50.0;
  local yitaG = 3.0;
  local Ig = 4.0;
  local Gangle = 40.0;
  hairNode:SetupUniforms(apolloengine.ShaderEntity.YITA_TT, mathfunction.vector1(yitaTT));
  hairNode:SetupUniforms(apolloengine.ShaderEntity.YITA_G, mathfunction.vector1(yitaG));
  hairNode:SetupUniforms(apolloengine.ShaderEntity.G_ANGLE, mathfunction.vector1(Gangle));

  hairNode:SetupUniforms(apolloengine.ShaderEntity.INTENSITY_G, mathfunction.vector1(Ig));
  hairNode:SetupUniforms(apolloengine.ShaderEntity.INTENSITY_R, mathfunction.vector1(0.3));
  hairNode:SetupUniforms(apolloengine.ShaderEntity.INTENSITY_TT, mathfunction.vector1(0.3));
  hairNode:SetupUniforms(apolloengine.ShaderEntity.INTENSITY_TRT, mathfunction.vector1(0.15));

  hairNode:SetupUniforms(apolloengine.ShaderEntity.COLOR_R, mathfunction.vector3(178,0,0) / 255);
  hairNode:SetupUniforms(apolloengine.ShaderEntity.COLOR_TT, mathfunction.vector3(128,0.0,0.0)/255);
  hairNode:SetupUniforms(apolloengine.ShaderEntity.COLOR_TRT, mathfunction.vector3(64,0,0) / 255);
end

return HairMaterial;