local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local venuscore = require "venuscore"
local mathfunction = require "mathfunction"
local defined = require "superme3d.defined"
local beholder = require "superme3d.observer"
local utility = require "superme3d.utility"
local skeleton = require "superme3d.model.skeletonnode"
local venusjson = require "venusjson"
local Object = require "classic"


local Bulletnode = {}

function Bulletnode:Initialize(path, mesh)
	self.rigidbody = {};
	self.anchorjonit = {};
	local config = venusjson.LaodJsonFile(path);
	mesh:SetShow(false);
	self.vertex = mesh:GetVertexStream();
	self.soft = apolloengine.SoftBodyComponent();
	self.meshshape = apolloengine.MeshShape(self.vertex, mesh:GetIndexStream());
	local parameter = config.param;
	self.soft:Initialize(meshshape ,parameter.mass);
	self:Setbulletparam(parameter);
	mesh:AttachComponent(self.soft);
	self.inverskin = apolloengine.WahbasInverseSkinComponent();
	self.skeleton = skeleton();
	local inverseconfig = config.inverse;
	self:InitBoneAndVertexBind(self.vertex, inverseconfig);
	local anchorconfig = config.anchor;
	self:Setanchor(anchorconfig);
end

function Bulletnode:Setbulletparam(config)
	if config.Magin ~= nil then
		self.soft:SetMagin(config.Magin);
	end
	if config.kDF ~= nil then
		self.soft:SetSoftkDF(config.kDF);
	end
	if config.KCH ~= nil then
		self.soft:SetKineticContactHardness(config.KCH);
	end
	if config.Piterations ~= nil then
		self.soft:SetSoftPiterations(config.Piterations);
	end
	if config.Stiffness ~= nil then
		self.soft:SetLinearStiffness(config.Stiffness);
	end
	if config.PoseMatch ~= nil then
		soft:SetPoseMatch(config.PoseMatch);
	end
end

function Bulletnode:InitBoneAndVertexBind(vertexstream, config)
	local postions = vertexstream:GetVertexData();
	local xnormals = vertexstream:GetNormalData();
	local znormals = config.znormal;
	local adjinfos = config.adjinfo;
	self.inverskin:SetVertexData(postions,xnormals,znormals,adjinfos);
	local inversparam = config.bind;
	for key,value in pairs(inversparam) do
		self.inverskin:AddIndexSkeletonPair(value, self.skeleton.skeleton:GetJoint(key));
	end
	apolloengine.IPhysicSystem:SetGravity(mathfunction.vector3(0,-50,0));
end

function Bulletnode:Setanchor(config)
	for name, param in pairs(config) do
		local rigid = apolloengine.RigidBodyComponent();
		rigid:Initialize(apolloengine.BoxShape(mathfunction.vector3(0.5, 0.5, 0.5)), 0);
		rigid:SetKinematic();
		rigid:DisableCollision();
		table.insert(self.rigidbody, rigid);
		local joint = self.skeleton.skeleton:GetJoint(name);
		table.insert(self.anchorjonit, joint);
		joint:AttachComponent(rigid);
		rigid:CleanMotion();
		for index, strength in pairs(param) do
			self.soft:AppendAnchor(index,rigid,true,strength);
		end	
	end
end

function Bulletnode:update()
	self.softbody:SetVertexDataToVertexStream(self.vertex);
	self.inverskin:InverseSkin(self.vertex);
end


return Bulletnode;


