local apolloengine = require "apolloengine"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local mathfunction = require "mathfunction"
local defined = require "superme3d.defined"
local beholder = require "superme3d.observer"
local utility = require "superme3d.utility"
local apollonode = require "apolloutility.apollonode"
local Object = require "classic"



local BackgroundLoader = {}


--加载mesh
function BackgroundLoader:Initialize()
  self.OnParseBackgroundEvent = nil;
  self.OnReleaseResourceEvent = nil;
  self.OnInitializeEvent = nil;
  --注册监听事件
  self:RegisterEvents();

end

function BackgroundLoader:RegisterEvents()
  self.OnInitializeEvent = utility:CreateInovation(self,self.OnInitialize);
  self.OnParseBackgroundEvent = utility:CreateInovation(self,self.ParseBackground);
  self.OnReleaseResourceEvent = utility:CreateInovation(self,self.ReleaseResource);
  
  beholder.observe(defined.Event.ON_INITIALIZE,self.OnInitializeEvent);
  beholder.observe(defined.Event.ON_RESOURCE_BACKGROUND,self.OnParseBackgroundEvent);
  beholder.observe(defined.Event.ON_RELEASE_RESOURCE,self.OnReleaseResourceEvent);
end

function BackgroundLoader:OnInitialize(a)
  self:_CreateDefaultBack();
end


function BackgroundLoader:_CreateDefaultBack()
  
  self.quad = apollonode.QuadNode()
  self.quad:SetShadowCaster(false);
  local texturePath = venuscore.IFileSystem:PathAssembly("docs:superme3d/background/background.png");
  self.quad:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,texturePath,apolloengine.TextureEntity.TW_REPEAT); 
  self.quad:CreateResource("comm:documents/material/imageblit.material");
  --self.quad:SetShow(false);
  
  
end


function BackgroundLoader:ParseBackground(backgroundInfo)
  if backgroundInfo then
    local backType = backgroundInfo.Type;
    local texture = backgroundInfo.Texture;
    
    --普通背景
    if backType == "Normal" then
      self:_CreateNormalBack(texture);
    elseif backType == "CubMap" then
      self:_CreateCubMapBack(texture)
    end
  end
end


function BackgroundLoader:_CreateNormalBack(texture)
  local texturePath = venuscore.IFileSystem:PathAssembly("ress:" .. texture);
  local tex = apolloengine.TextureEntity();
  tex:PushMetadata(apolloengine.TextureFileMetadata(apolloengine.TextureEntity.TU_STATIC,
      apolloengine.TextureEntity.PF_AUTO,1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_BORDER,
      apolloengine.TextureEntity.TW_CLAMP_TO_BORDER,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      texturePath));
  local res = tex:CreateResource();
  self.quad:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,tex);
end





function BackgroundLoader:_CreateCubMapBack()
end

function BackgroundLoader:ReleaseResource()
  self.OnParseBackgroundEvent = nil;
  self.OnReleaseResourceEvent = nil;
  self.quad = nil;
end


BackgroundLoader:Initialize();

return BackgroundLoader;


