  
local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local filterqueue = require "apolloutility.filterqueue"
local photomooddefined = require "photomood.defined"
local Object = require "classic"
local likeapp = require "likeapp"





local PostEffectRender = Object:extend();

local function BinearSerach(offset,key_value)  --线性插值
  local len = #key_value;
  local low = 1;
  local high = len;
  local middle = 1;

  while low <= high do
    middle = math.floor((low + high) / 2);
    local pointoffset = key_value[middle][1];
    if pointoffset > offset then
      high = middle - 1;
    elseif pointoffset < offset then
      low = middle + 1;
    else
      return key_value[middle][2];
    end
  end
  
  if key_value[middle][1] > offset then
    middle = middle - 1;
  end
  local first = middle;
  local second = middle + 1;
  if second > len then
    return key_value[len][2];
  end
  if first < 1 then
    return key_value[1][2];
  end
  return key_value[first][2]; --返回区间的第一个值
end
--render_type是为区分主相机和rect上的相机的后处理参数："maincamera"为主相机，"rect"为分相机
function PostEffectRender:new(material_list,track_list,render_type)
  self.material_list = material_list;
  self.track_list = track_list;
  self.posteffect_list = {};
  self.posteffect_parameter_list = {};
  self.posteffect_track_list = {};
  self.posteffect_parameter_curve_list = {};
  
  self.posteffect_texture = nil;
  self.posteffect_index = nil;
  self:ParseMaterialAndTrack(render_type);
end


function PostEffectRender:GetParamEnum(paramName)
  if paramName == "Linear" then
    return 1;
  elseif paramName == "Free" then
    return 0;
  else
    return 1;
  end
end

function PostEffectRender:ParseMaterialAndTrack(render_type)
  local track_cnt = #self.track_list;
  local material_cnt = #self.material_list;
  

  --处理post effect
  for i = 1, material_cnt do
    local materialStruct = self.material_list[i];
    local postEffectName = materialStruct.Name;
    local postEffectPath = materialStruct.Path;
    local postEffectParameters = materialStruct.Parameters;
    local parameterCnt = #postEffectParameters;
    local postEffect = apollonode.PostEffect();
    postEffect:Disable();
    --local effectPath = postEffectPath .. "/" .. postEffectName .. ".lua";
    local rPostefectPath = photomooddefined.FilterName_to_Path[postEffectName];
    if rPostefectPath ~= nil then
      postEffectPath = rPostefectPath;
    end
    
    postEffectPath = venuscore.IFileSystem:PathAssembly(postEffectPath);
    postEffect:CreateResource(postEffectPath);
    
    local tmpParamList = {};
    for j = 1, parameterCnt do
      postEffect:RegisterParameter(postEffectParameters[j]);
      table.insert(tmpParamList,postEffectParameters[j]);
    end
    table.insert(self.posteffect_list,postEffect);
    table.insert(self.posteffect_parameter_list, tmpParamList);
  end
  if render_type == "maincamera" then
    filterqueue:AttachMaincamera(self.posteffect_list);  --不返回后处理结果
  else
    self.posteffect_texture, self.posteffect_index = filterqueue:Createfilter(self.posteffect_list);  --进行后处理返回后处理结果
  end;
  --为每个后处理附加一个帧范围和插值曲线
  local trackArray = {};
  local reverseTable = {};
  for i = 1, track_cnt do
    local trackStruct = self.track_list[i];
    local materialIndex = trackStruct.MaterialIndex;
    local track = trackStruct.Track;
    local parameterValues = trackStruct.ParameterValues;
    local parameterCnt = #parameterValues;
    local temCurves = {};
    for j = 1, parameterCnt do
      local param_index = parameterValues[j].ParameterIndex;
      local key_frames = parameterValues[j].Times;
      local key_frame_values = parameterValues[j].Values;
      local isFrameByFrame = parameterValues[j].FrameByFrame or false;
      local value_component_cnt = key_frame_values.ComponentCount;
      local key_frame_value_dats = key_frame_values.Value;
      local key_frame_value_dats_cnt = #key_frame_value_dats;
      local key_frame_value_cnt = key_frame_value_dats_cnt / value_component_cnt;
      local key_frame_cnt = #key_frames;
      if key_frame_cnt ~= key_frame_value_cnt then  --配置出错
        ERROR("Data configure error! Track index: " .. tostring(i) .. " Parameter index: " .. tostring(j));
      end
      local datatype,interpolate_curve_table = self:CreateCurve(track[1],track[2],key_frames,key_frame_value_dats,value_component_cnt,isFrameByFrame);
      table.insert(temCurves,{param_index,datatype,isFrameByFrame,interpolate_curve_table});
    end
    table.insert(self.posteffect_track_list,{materialIndex,{track[1],track[2]}});
    table.insert(self.posteffect_parameter_curve_list, {materialIndex,temCurves});
  end
end

function PostEffectRender:CreateCurve(begin_frame,end_frame,key_frames,key_frame_value_dats,value_component_cnt,is_frame_by_frame)
  local curve_table = {};
  local value_table = {};
  local datatype = "number";
  for i = 1, value_component_cnt do
    local apolo_curve = apolloengine.Curve();
    table.insert(curve_table,apolo_curve);
    table.insert(value_table,{});
  end
  
  local key_frame_cnt = #key_frames;
  for i = 1, key_frame_cnt do
    local offset = (key_frames[i] - begin_frame) / (end_frame - begin_frame);
    for j = 1, value_component_cnt do
      local value = key_frame_value_dats[(i - 1) * value_component_cnt + j];
      
      datatype = type(value);
      if is_frame_by_frame then  --逐帧的数据也特殊处理，要是插值就GG了
        local tempTable = value_table[j];
        table.insert(tempTable,value);
      else
        --bool 数值不能插值，需要特殊处理
        
        --字符串类型特殊处理
        if datatype == "string" or datatype == "boolean" then
          local tempTable = value_table[j];
          table.insert(tempTable,{offset,value});
        else
          local point = mathfunction.vector2(offset,tonumber(value));
          local tempCurve = curve_table[j];
          tempCurve:AddPoint(point,0.0,0.0,1,1);  --全部默认线性插值
        end
      end
    end
  end
  if is_frame_by_frame then
    return datatype,value_table
  else
    if datatype == "string" or datatype == "boolean" then
      return datatype,value_table
    else
      return datatype,curve_table
    end
  end
  

  
  --return datatype,curve_table;
end

function PostEffectRender:ResetPosteffect()
  self.posteffect_texture, self.posteffect_index = filterqueue:Createfilter(self.posteffect_list);
end

function PostEffectRender:GetPostEffectOutput()
  return self.posteffect_texture;
end


function PostEffectRender:SetCustomTexture(texture)
  filterqueue:SetCustomTexture(texture,self.posteffect_index);
end


function PostEffectRender:Update(frameInd)
  
  for i = 1, #self.posteffect_list do
    self.posteffect_list[i]:Disable();
  end
  
  --enable/disable posteffect && set parameters
  local frameIndex = frameInd - 1; --设计要求配置中帧号从0开始
  local trackCnt = #self.posteffect_track_list;
  for i = 1, trackCnt do
    local frameTrack = self.posteffect_track_list[i][2];
    local posteffect_index = self.posteffect_track_list[i][1];
    if frameIndex >= frameTrack[1] and frameIndex <= frameTrack[2] then
      self.posteffect_list[posteffect_index]:Enable();
      --设置Uniform
      local posteffect_index = self.posteffect_parameter_curve_list[i][1];
      local curve_list = self.posteffect_parameter_curve_list[i][2];
      local curve_list_cnt = #curve_list;
      for j = 1, curve_list_cnt do
        local param_index = curve_list[j][1];
        local param_name = self.posteffect_parameter_list[posteffect_index][param_index];
        --local param_curve = curve_list[j][2];
        local param_data_type = curve_list[j][2];
        local parma_is_frame_by_frame = curve_list[j][3];
        local param_curve_table = curve_list[j][4];
        local offset = (frameIndex - frameTrack[1]) / (frameTrack[2] - frameTrack[1]);
        local interpolate_value = {};
        for k = 1, #param_curve_table do
          local apolo_curve = param_curve_table[k];
          if parma_is_frame_by_frame == true then
            local interpolate_component = apolo_curve[frameIndex - frameTrack[1] + 1];
            table.insert(interpolate_value,interpolate_component);
          else
            if param_data_type == "boolean" or param_data_type == "string" then
              --string 和 boolean 类型不能插座
              local interpolate_component = BinearSerach(offset,apolo_curve);
              table.insert(interpolate_value,interpolate_component);
            else
              local interpolate_component = apolo_curve:Interpolate(offset);
              table.insert(interpolate_value,interpolate_component);
            end
          end
          
 
          
          
        end
        local value_component_cnt = #interpolate_value;
        local apolo_value = nil;
        
        if value_component_cnt == 1 then --bool 和 string 都只能有一个分量
          if param_data_type == "boolean" then
            apolo_value = interpolate_value[1];
          elseif param_data_type == "string" then
          
            
            apolo_value = interpolate_value[1];
 
            apolo_value = venuscore.IFileSystem:PathAssembly(apolo_value);
          else
            apolo_value = mathfunction.vector1(interpolate_value[1]);
          end
        elseif value_component_cnt == 2 then
          apolo_value = mathfunction.vector2(interpolate_value[1],interpolate_value[2]);
        elseif value_component_cnt == 3 then
          apolo_value = mathfunction.vector3(interpolate_value[1],interpolate_value[2],interpolate_value[3]);
        elseif value_component_cnt == 4 then
          apolo_value = mathfunction.vector4(interpolate_value[1],interpolate_value[2],interpolate_value[3],interpolate_value[4]);
        else
          ERROR("Unsupported parameter type!");
        end
        self.posteffect_list[posteffect_index][param_name](self.posteffect_list[posteffect_index],apolo_value);
      end
    end
  end
end

return PostEffectRender;
