local renderqueue = require "apolloutility.renderqueue"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local Object = require "classic"
local videodecet = require "videodecet"
local photosequence = require "photomood.mask_sequence"
local maincamerasequence = require "photomood.maincamera_sequence";
local lyricsequence = require "photomood.lyric_sequence"
local basevideosequence = require "photomood.base_sequence"
local basevideosequenceblend = require "photomood.base_sequence_blend"
local biugodefined = require "photomood.defined"
local filterqueue = require "apolloutility.filterqueue"
local keypointparser = require "photomood.mask_keypoint_parser"
local CustomTextureManager = require "photomood.customtexture"
local Cover = require "photomood.cover"



local photomoodmanager = {};


function photomoodmanager:Initialize(maincam)
  self.masksequence = {};
  self.photosequences = {};
  self.lyricsequence = {};
  self.lyric1 = {};
  self.lyric2 = {};
  self.lyric3 = {};
  self.quotation = {};
  self.basevideosequences = {};
  self.cover = nil;
  self.maincamera = maincam;
  self.m_sequence = nil;
end


function photomoodmanager:ParseLyric(lyricconfig,videowidth,videoheight)
  local lyric_inEffect = lyricconfig.InEffect;
  local lyric_outEffect = lyricconfig.OutEffect;
  local outline_color = lyricconfig.OutlineColor;
  local outline_offset = lyricconfig.OutlineOffset;
  local lyricseq = nil;
  if lyric_inEffect ~= nil and lyric_outEffect ~= nil then
    lyricseq = lyricsequence(lyric_inEffect,lyric_outEffect,outline_color,outline_offset,videowidth,videoheight);
    renderqueue:After(lyricseq);
  end
  return lyricseq;
end


function photomoodmanager:LoadConfig(configfile)
  local res = true;
  local config = venusjson.LaodJsonFile(configfile);
  local version = config.version or 1;
  local photoMoodConfig = config.PhotoMood;
  local mask_keypointpath_map = {};
  if photoMoodConfig then
    local videoWidth = photoMoodConfig.Canvas.Width;
    local videoHeight = photoMoodConfig.Canvas.Height;
    local fixedresolution = photoMoodConfig.FixedResolution;
    local pathDir= string.match(configfile, "(.+)/[^/]*%.%w+$");
    venuscore.IFileSystem:SetResourcePath(pathDir .. "/");

    --创建最顶层遮罩层
    --self.cover = Cover(self.maincamera);
    --Cover:Initialize(self.maincamera,videoWidth,videoHeight);
   -- renderqueue:After(Cover);
    --处理多base视频
    local baseVideo = photoMoodConfig.BaseVideo;
    if baseVideo ~= nil then
    videodecet:SetShow(false);
      local split_info = baseVideo.Split;
      local slices = baseVideo.Slices;
      local slice_cnt = #slices;
      for i = 1, slice_cnt do
        local slice_struct = slices[i];
        if slice_struct.Location[1] == 0 and slice_struct.Location[2] == 0 then
          local basevideo_seq = basevideosequence(split_info[1],split_info[2],slice_struct.Location,slice_struct.BlendMode);
          renderqueue:After(basevideo_seq);
          table.insert(self.basevideosequences,basevideo_seq);
        else
          local basevideo_seq = basevideosequenceblend(split_info[1],split_info[2],slice_struct.Location,slice_struct.BlendMode,self.maincamera);
          --local basevideo_seq = basevideosequence(split_info[1],split_info[2],slice_struct.Location,slice_struct.BlendMode);
          renderqueue:After(basevideo_seq);
          table.insert(self.basevideosequences,basevideo_seq);
        end
      end
    end



    local keypointfile = photoMoodConfig.KeyPointFiles;
    if keypointfile then
      local keypointfilecount = #keypointfile;
      filterqueue:Initialize(self.maincamera,keypointfilecount,mathfunction.vector2(videoWidth,videoHeight));
      keypointparser:Initialize();
      CustomTextureManager:Initialize();
      for i = 1,keypointfilecount do
        local channel = keypointfile[i].Channel;
        local customID = keypointfile[i].CustomID;
        local materials = keypointfile[i].Materials;
        local tracks = keypointfile[i].Tracks;
        local materialName = "Simple";  --默认给简单材质，Dffuse贴图材质
        if version == 2 then
          materialName = "SimpleV2";   --拼接版本mask
        end
        
        local maskseq = photosequence(customID,channel,materialName, materials,tracks,self.maincamera,videoWidth,videoHeight,i,fixedresolution);
        renderqueue:After(maskseq);
        table.insert(self.photosequences,maskseq);
        local filename = keypointfile[i].Path;
        local fullpath = venuscore.IFileSystem:PathAssembly(pathDir.. "/" .. filename);
        table.insert(mask_keypointpath_map,{fullpath,maskseq});
      end
      keypointparser:ParseKeypointFile(mask_keypointpath_map);
    end
    
    local maincameraeffects = photoMoodConfig.MainCameraEffects;
    if maincameraeffects then
      local materials = maincameraeffects.Materials;
      local tracks = maincameraeffects.Tracks;
      self.m_sequence = maincamerasequence(materials,tracks);
    end
    
    local lyric = photoMoodConfig.Lyric; --歌词配置
    local lyric2 = photoMoodConfig.Lyric2;
    local lyric3 = photoMoodConfig.Lyric3;
    if lyric ~= nil then
      local tempSequence = self:ParseLyric(lyric,videoWidth,videoHeight);
      table.insert(self.lyric1,tempSequence);
      table.insert(self.lyricsequence,tempSequence);
    else
      local tempSequence = self:ParseLyric(biugodefined.Lyric_Config_Default,videoWidth,videoHeight);
      table.insert(self.lyric1,tempSequence);
      table.insert(self.lyricsequence,tempSequence);
    end
    if lyric2 ~= nil then
      local count = #lyric2;
      for i = 1,count do
        local tempSequence = self:ParseLyric(lyric2[i],videoWidth,videoHeight);
        table.insert(self.lyric2,tempSequence);
        table.insert(self.lyricsequence,tempSequence);
      end
    else
      for i = 1,2 do
        local tempSequence = self:ParseLyric(biugodefined.Lyric_Config_Default,videoWidth,videoHeight);
        table.insert(self.lyric2,tempSequence);
        table.insert(self.lyricsequence,tempSequence);
      end
    end
    if lyric3 ~= nil then
      local count = #lyric3;
      for i = 1,count do
        local tempSequence = self:ParseLyric(lyric3[i],videoWidth,videoHeight);
        table.insert(self.lyric3,tempSequence);
        table.insert(self.lyricsequence,tempSequence);
      end
    else
      for i = 1,3 do
        local tempSequence = self:ParseLyric(biugodefined.Lyric_Config_Default,videoWidth,videoHeight);
        table.insert(self.lyric3,tempSequence);
        table.insert(self.lyricsequence,tempSequence);
      end
    end

    local quotation = photoMoodConfig.Quotation;
    if quotation ~= nil then
      local count = #quotation;
      for i = 1,count do
        local tempSequence = self:ParseLyric(quotation[i],videoWidth,videoHeight);
        table.insert(self.quotation,tempSequence);
      end
    else
      for i = 1,3 do
        local tempSequence = self:ParseLyric(biugodefined.Quotation_Config_Default,videoWidth,videoHeight);
        table.insert(self.quotation,tempSequence);
      end
    end
  end
  if res == false then
    self:ReleaseResource();  --加载失败，自己调用卸载，避免外部不调用卸载
  end
  return res;
end

function photomoodmanager:Update(timespan)
  
  --self.cover:Update(timespan);
  --collectgarbage();
  local maskcount = #self.photosequences;
  for i = 1, maskcount do
    self.photosequences[i]:Update(timespan);
  end
  
  if self.m_sequence ~= nil then
    self.m_sequence:Update();
  end

  
  local lyriccount = #self.lyricsequence;
  for i = 1, lyriccount do
    self.lyricsequence[i]:Update(timespan);
  end

  local quotationcount = #self.quotation;
  for i = 1,quotationcount do
    self.quotation[i]:Update(timespan);
  end
  
  local basecount = #self.basevideosequences;
  for i = 1, basecount do
    self.basevideosequences[i]:Update();
  end
  
end



function photomoodmanager:SetMaskVideoTexture(texid,size)
  local maskcount = #self.photosequences;
  for i = 1, maskcount do
    self.photosequences[i]:SetMaskTexture(texid,size);
  end
end


function photomoodmanager:SetLyric(lyricTextureID,lyricColor,lyricDuration,lyricSize,lyricPosition,isNew)
  local lyriccount = #lyricTextureID;
  local targetSequences = self.lyricsequence;
  if lyriccount == 1 then
    targetSequences = self.lyric1;
  elseif lyriccount == 2 then
    targetSequences = self.lyric2;
  elseif lyriccount == 3 then
    targetSequences = self.lyric3;
  else
    return;
  end
  for i = 1,lyriccount do
    targetSequences[i]:SetLyric(lyricTextureID[i], lyricColor:Get(i), lyricDuration[i], lyricSize:Get(i), lyricPosition:Get(i), isNew[i]);
  end
end

function photomoodmanager:SetQuotation(lyricTextureID,lyricColor,lyricDuration,lyricSize,lyricPosition,isNew)
  local lyriccount = #lyricTextureID;
  for i = 1,lyriccount do
    self.quotation[i]:SetLyric(lyricTextureID[i], lyricColor:Get(i), lyricDuration[i], lyricSize:Get(i), lyricPosition:Get(i), isNew[i]);
  end
end

function photomoodmanager:ShowLyric(isShow)
  local lyriccount = #self.lyricsequence;
  for i = 1, lyriccount do
    self.lyricsequence[i]:ShowLyric(isShow);
  end
end

function photomoodmanager:ClearLyric()
  local lyriccount = #self.lyricsequence;
  for i = 1, lyriccount do
    self.lyricsequence[i]:ClearLyric();
  end
end

function photomoodmanager:ShowQuotation(isShow)
  local quotationcount = #self.quotation;
  for i = 1, quotationcount do
    self.quotation[i]:ShowLyric(isShow);
  end
end

function photomoodmanager:ClearQuotation()
  local quotationcount = #self.quotation;
  for i = 1, quotationcount do
    self.quotation[i]:ClearLyric();
  end
end



function photomoodmanager:ReleaseResource()
  videodecet:SetShow(true);
  CustomTextureManager:Clear();
  filterqueue:Clear();
  filterqueue:ClearMaincameraAttach(); 
  keypointparser:Clear();
  for i = 1, #self.basevideosequences do
    self.basevideosequences[i]:Clear();
  end
  self.basevideosequences = {};
  self.photosequences = {};
  self.lyricsequence = {};
  self.lyric1 = {};
  self.lyric2 = {};
  self.lyric3 = {};
  self.quotation = {};
  self.m_sequence = nil;
  --Cover:Clear();
  collectgarbage();

end


return photomoodmanager;
