  
local basedetect = require "videodecet.basevideodetect";
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"
local defiend = require "apolloutility.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local MaskRender = require "photomood.mask_render"
local LyricRender = require "photomood.lyric_render"
local venuscore = require "venuscore"
local videodecet = require "videodecet"
local biugodefined = require "photomood.defined"
local emptyimage = require "apolloutility.emptyimage"
local stringsplit = require "stringsplit"
local SquareInfo = require "photomood.squareinfo";
local PostEffectRender = require "photomood.posteffect_render"
local CustomTextureBlit = require "photomood.customtexture_blit"
--local Cover = require "photomood.cover"
local Object = require "classic"
local likeapp = require "likeapp"





local MaskSequenceBase = Object:extend();


function MaskSequenceBase:new(customID,channel,materialName,material_list,track_list,maincamera,videowidth,videoheight, renderOrder, fixedresolution)
  
  self.customID = customID;
  self.maskChannel = channel;
  self.material_name = materialName;
  self.video_width = videowidth;
  self.video_height = videoheight;
  self.renderOrder = renderOrder;
  self.fixedresolution = fixedresolution;
  self.maskID = nil;
  self.mask_texture = nil;
  self.squareframes = {};
  self.posteffect_render = nil;
  LOG("CustomID is: " .. tostring(self.customID));
  if material_list ~= nil and track_list ~= nil then
    self.posteffector_render = PostEffectRender(material_list,track_list,"rect"); --创建后处理渲染
  end
  
  self.custom_blit = CustomTextureBlit(maincamera,videowidth,videoheight,self.renderOrder - 1);

  local strMaterial = self:AssemblyMaterial();
  self.maskrender = MaskRender(strMaterial);
  --self.maskrender = MaskRender(biugodefined.mask_video_material_path);  --
  
  self.empty_mask_ts = apolloengine.TextureStream();
  self.empty_mask_ts:SetStreamType(
    mathfunction.vector2(4,1),
    apolloengine.TextureEntity.PF_L8);
  for u=1, 4 do
    self.empty_mask_ts:SetPixel(u, 1, mathfunction.vector1(0.0));
  end

  self.empty_mask_texture = apolloengine.TextureEntity();
  self.empty_mask_texture:PushMetadata(
  apolloengine.TextureBufferMetadata(
    apolloengine.TextureEntity.TU_WRITE,
    1, false,
    apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
    apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
    apolloengine.TextureEntity.TF_LINEAR,
    apolloengine.TextureEntity.TF_LINEAR,
    self.empty_mask_ts));
  self.empty_mask_texture:CreateResource();
  self.mask_texture = self.empty_mask_texture;
  
  
  -- coustom texture
  -- 用户没有设置图片的情况下，不需要绘制
  self.default_custom_ts = apolloengine.TextureStream();
    self.default_custom_ts:SetStreamType(
    	mathfunction.vector2(32,1),
    	apolloengine.TextureEntity.PF_R8G8B8A8);
    for u=1, 32 do
      self.default_custom_ts:SetPixel(u, 1, mathfunction.vector4(0.0,0.0,0.0,0.0));
  end 
  self.custom_texture = apolloengine.TextureEntity();
  self.custom_texture:PushMetadata(
  apolloengine.TextureBufferMetadata(
      apolloengine.TextureEntity.TU_WRITE,
      1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
       self.default_custom_ts));
  self.custom_texture:CreateResource();
  self.custom_texture_size = nil;
  self.first_texture_size = mathfunction.vector2(960,720);
end

function MaskSequenceBase:AssemblyMaterial()
  local alphamode_str = biugodefined.AlphaMode["Blend"];
  local shaderpart_str = biugodefined.Shaders[self.material_name];

  local renderQueue = "OPAQUE + " .. tostring(self.renderOrder);
  local material_begin = string.format(biugodefined.material_begin, renderQueue, alphamode_str);
    
  local materialsrc = material_begin .. shaderpart_str;
  materialsrc = materialsrc .. biugodefined.material_end;
  return materialsrc;
end

function MaskSequenceBase:SetSequence(s)
  self.maskrender:SetSequence(s);
end

function MaskSequenceBase:SetShow(isShow)
  if self.isShow ~= isShow then
    self.isShow = isShow;
    self.maskrender:SetShow(isShow);
    self.custom_blit:SetShow(isShow);
    --Cover:SetShow(isShow);
  end
end


function MaskSequenceBase:SetCustomID(id)
  if self.customID == nil then  --如果用户指定了ID，则用用户的
    self.maskID = id;
  else
    self.maskID = self.customID;
  end
end

function MaskSequenceBase:PushData(data)
  local squareinfo = SquareInfo:cast(data);
  table.insert(self.squareframes,squareinfo);
end


function MaskSequenceBase:Update(frameIndex,needRecreateFilter)
  local keypoint_frame_count = #self.squareframes;
  local frameInd = frameIndex;
  
  if keypoint_frame_count == 0 then
    return;  --数据没读出来，不Update
  end
  
  if frameInd < 1 then
    frameInd = 1;
    ERROR("Frame index error! TheFrameIndex is: " .. tostring(frameIndex));
  end
  if frameInd > keypoint_frame_count then
    frameInd = keypoint_frame_count;
    --ERROR("Frame index error! TheFrameIndex is: " .. tostring(frameIndex));
  end
  
  local squareInfo = self.squareframes[frameInd];

  local vertexArray, texcoordArray = squareInfo:GetTesslateData();

  --按照设计要求裁剪图片
  local uvScaler = mathfunction.vector2(1.0,1.0);
  self.maskrender:Update(vertexArray,texcoordArray,uvScaler);

  
  
  --[[
  if self.posteffector_render ~= nil then 
    if needRecreateFilter == true then
      self.posteffector_render:ResetPosteffect();
    end
    
    self.posteffector_render:SetCustomTexture(self.custom_texture);
    mask_texture_after_process = self.posteffector_render:GetPostEffectOutput();
    self.posteffector_render:Update(frameInd);
  end

  self.maskrender:SetMaskTexture(self.mask_texture,self.maskChannel);
  local rectSize = mathfunction.vector2(self.video_width, self.video_height);
  self.custom_blit:Update(self.custom_texture,mask_texture_after_process,self.custom_texture_size,rectSize);
  local customtextureR = self.custom_blit:GetCustomTextureResult();
  self.maskrender:SetCustomTexture(customtextureR);
  --]]
  
  self.maskrender:SetMaskTexture(self.mask_texture,self.maskChannel);
  local rectSize = mathfunction.vector2(self.video_width, self.video_height);
  self.custom_blit:Update(self.custom_texture,self.custom_texture,self.custom_texture_size,rectSize,self.first_texture_size,self.fixedresolution,self.maskID);
  local customtextureR = self.custom_blit:GetCustomTextureResult();
  
  local mask_texture_after_process = customtextureR;
  if self.posteffector_render ~= nil then 
    if needRecreateFilter == true then
      self.posteffector_render:ResetPosteffect();
    end
    
    self.posteffector_render:SetCustomTexture(customtextureR);
    --self.posteffector_render:SetCustomTexture(self.custom_texture);
    mask_texture_after_process = self.posteffector_render:GetPostEffectOutput();
    self.posteffector_render:Update(frameInd);
  end
  self.maskrender:SetCustomTexture(mask_texture_after_process);
  --self.maskrender:SetCustomTexture(self.custom_texture);

end

function MaskSequenceBase:SetLutTexture(lut)
  if lut == nil then
    ERROR("lut mask is nil");
    return;
  end
  local lut_tex = apolloengine.TextureEntity();
  lut_tex:PushMetadata(apolloengine.TextureFileMetadata(apolloengine.TextureEntity.TU_STATIC,
      apolloengine.TextureEntity.PF_AUTO,1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_NEAREST,
      apolloengine.TextureEntity.TF_NEAREST,
      lut));
  lut_tex:CreateResource();
  self.maskrender:SetLutTexture(lut_tex);
end


return MaskSequenceBase;
