  
local defiend = require "apolloutility.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local stringsplit = require "stringsplit"
local SquareInfo = require "photomood.squareinfo";
local Object = require "classic"
local likeapp = require "likeapp"
local errno = require "errno"




local KeypointFileParser = {};

function KeypointFileParser:Initialize()
  self.path_object_map = {};
  --创建一个服务解析所有文件，避免卡死
  self.parseservice = venuscore.IServicesSystem:Create("photomood.photomood_parseservice_keypoint");
  LOG("11111");
  LOG(self.parseservice);

    local mt = getmetatable(self.parseservice);
    if not mt then
      ERROR("not the agent");
    else
      for key, value in pairs(mt) do
        ERROR(key.." is "..type(value));
      end

  end
  
  self.parseservice:Initialize();


end
function KeypointFileParser:Clear()
  self.path_object_map = {};
  self.parseservice = nil;
end

function KeypointFileParser:ParseKeypointFile(path_obj_map)
  
  self.path_object_map = path_obj_map;

  self.insertfunction = function(d,index)
    if nil ~= self.path_object_map[index] then
      local squareinfo = SquareInfo:cast(d);
      local obj = self.path_object_map[index][2];
      obj:PushData(squareinfo);
    end    
    return true;
  end

  --将所有文件都添加到服务中
  local resolution = nil;
  local mask_sequence_tabel_cnt = #self.path_object_map;
  for i = 1, mask_sequence_tabel_cnt do
    local keypointfilefullpath = self.path_object_map[i][1];
    local mask_sequence = self.path_object_map[i][2];
    local file = io.open(keypointfilefullpath, "rb")
    if file then
      file:close();
    end
    if file ~= nil then
      --获得分辨率和ID号
      local filename_with_suffix = nil;
      local filename_without_suffix = nil;
      filename_with_suffix = string.match(keypointfilefullpath,".+/([^/]*%.%w+)$");
      local idx = filename_with_suffix:match(".+()%.%w+$")
      if(idx) then
        filename_without_suffix = filename_with_suffix:sub(1, idx-1)
      else
        filename_without_suffix = filename_with_suffix
      end
      local splited_filename = stringsplit(filename_without_suffix,"_",tonumber);
      local split_component_cnt = #splited_filename;
      if split_component_cnt ~= 3 then
        ERROR("Key point file name error!");
        likeapp.AI:OnErrorReport(errno.SUPERME_KEY_POINT_FILE_NAME_ERROR);
      end
      local size = {splited_filename[1],splited_filename[2]};
      local id = splited_filename[3];
      local mask_sequence = self.path_object_map[i][2];
      mask_sequence:SetCustomID(id);
      self.parseservice:AddKeypointFile(i,keypointfilefullpath,size,id);

    else
      ERROR(keypointfilefullpath .. " do not exist!");
      likeapp.AI:OnErrorReport(errno.SUPERME_FILE_NO_EXIT);
      return false;
    end
  end
  
  local agent, index = g_callbackhandle:RegisterCallback(self.insertfunction);
  self.parseservice:PaserFile(agent, index); 
  return true;
end




return KeypointFileParser;
