local apollonode = require "apolloutility.apollonode"
local defined = require "apolloutility.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local photomooddefined = require "photomood.defined"
local Object = require "classic"


--用于绘制模糊底图和裁剪用户图片
--切换用户图片时不需要重建

local custom_texture_blit_target = Object:extend();

function custom_texture_blit_target:new(maincamera,videoWidth,videoHeight,renderorder)
  self.sequence = renderorder * 2;
  apolloengine.ShaderEntity.VERTEX_SCALER = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"VERTEX_SCALER");

  local near = maincamera:GetNear();
  local far = maincamera:GetFar();
  local pos = maincamera:GetWorldPosition();
  local lookat = pos + maincamera:GetForward();
  local up = maincamera:GetUp();
  local color = mathfunction.Color(0.0,0.0,0.0,0.0); --清屏颜色
  
  --设计要求底图是用户图片模糊的结果
  self.blur_camera = apollonode.CameraNode();
  self.blur_camera:Activate();
  self.blur_camera:CreateRealCameraProjection(near, far);
  self.blur_camera:LookAt(pos, lookat, up);
  self.blur_camera:SetSequence(photomooddefined.photomood_mask_clip_camera_sequence + self.sequence);
  self.blur_rt = apolloengine.RenderTargetEntity();
  self.blur_rt:PushMetadata(--设置FBO格式
    apolloengine.RenderTargetMetadata(
      apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      color,--清屏颜色
      mathfunction.vector4(0.0,0.0,videoWidth,videoHeight),
      mathfunction.vector2(videoWidth,videoHeight)));--分辨率
  self.blur_tex = self.blur_rt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);
  self.blur_tex:PushMetadata(--创建纹理
      apolloengine.TextureRenderMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        mathfunction.vector2(videoWidth,videoHeight)));
  self.blur_rt:CreateResource();
  self.blur_camera:AttachRenderTarget(self.blur_rt);
  
  --挂载模糊后处理，用来模糊背景底图
  self.blur_effect = apollonode.PostEffect();
  self.blur_effect:CreateResource("comm:script/apolloutility/posteffect/fastblur.lua"); 
  self.blur_effect:RegisterParameter("Blurriness");
  self.blur_effect:Blurriness(10);
  self.blur_effect:SetQueue(1);
  self.blur_camera:AttachPostEffect(self.blur_effect);


  self.blit_clip_camera = apollonode.CameraNode();
  self.blit_clip_camera:Activate();
  self.blit_clip_camera:CreateRealCameraProjection(near, far);
  self.blit_clip_camera:LookAt(pos, lookat, up);
  self.blit_clip_camera:SetSequence(photomooddefined.photomood_mask_clip_camera_sequence + self.sequence + 1);
  self.blit_clip_rt = apolloengine.RenderTargetEntity();
  self.blit_clip_rt:PushMetadata(--设置FBO格式
    apolloengine.RenderTargetMetadata(
      apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      color,--清屏颜色
      mathfunction.vector4(0.0,0.0,videoWidth,videoHeight),
      mathfunction.vector2(videoWidth,videoHeight)));--分辨率
  self.blit_clip_tex = self.blit_clip_rt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);
  self.blit_clip_tex:PushMetadata(--创建纹理
      apolloengine.TextureRenderMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        mathfunction.vector2(videoWidth,videoHeight)));
  self.blit_clip_rt:CreateResource();
  self.blit_clip_camera:AttachRenderTarget(self.blit_clip_rt);
  
  
  self:CreateRender();  --创建可渲染对象
end

function custom_texture_blit_target:Clear()
  self.blur_camera = nil;
  self.blit_clip_camera = nil;
  self.quad_blur = nil;
  self.quad_blit = nil;
  self.quad_clip = nil;
end

function custom_texture_blit_target:SetShow(isShow)
  self.quad_blur:SetShow(isShow);
  self.quad_blit:SetShow(isShow);
  self.quad_clip:SetShow(isShow);
end


function custom_texture_blit_target:CreateRender()
  --模糊底图
  self.quad_blur = apollonode.QuadNode();
  self.quad_blur:SetShow(false);
  self.quad_blur:SetSequence(photomooddefined.photomood_mask_clip_camera_sequence + self.sequence);
  self.quad_blur:CreateResource("comm:documents/material/imageblit.material",true);
  
  self.quad_blit = apollonode.QuadNode();
  self.quad_blit:SetShow(false);
  self.quad_blit:SetSequence(photomooddefined.photomood_mask_clip_camera_sequence + self.sequence + 1);
  self.quad_blit:CreateResource(photomooddefined.mask_background_blit_material_path,true);
  self.quad_blit:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,self.blur_tex);
  self.quad_blit:SetParameter(apolloengine.ShaderEntity.VERTEX_SCALER,mathfunction.vector2(1.0,1.0));
  
  self.quad_clip = apollonode.QuadNode();
  self.quad_clip:SetShow(false);
  self.quad_clip:SetSequence(photomooddefined.photomood_mask_clip_camera_sequence + self.sequence + 1);
  self.quad_clip:CreateResource(photomooddefined.mask_clip_material_path,true);
  
  
end

function custom_texture_blit_target:Update(custom_texture,posteffect_result,custom_texture_size,rect_size,first_texture_size,fixedresolution, textureid)
  
  self.quad_blur:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,custom_texture);
  self.quad_clip:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,posteffect_result);
  
  
  --用于裁剪缩放用户图片的顶点
  local vertexScaler = mathfunction.vector2(1.0,1.0);
  if custom_texture_size ~= nil then
    local custom_texture_width = custom_texture_size:x();
    local custom_texture_height = custom_texture_size:y();
    local rect_width = rect_size:x();
    local rect_height = rect_size:y();
    local rectRatio = rect_width / rect_height;
    local textureRatio = custom_texture_width / custom_texture_height;

    local first_texture_scale = mathfunction.vector2(1.0,1.0);

    if fixedresolution ~= nil and fixedresolution == true then
      --LOG("fixresolution, do not rescale texture");
    else

      if custom_texture_size == first_texture_size then
        if textureRatio > rectRatio then
          vertexScaler:Set(1.0,rectRatio / textureRatio);
        elseif textureRatio < rectRatio then
          vertexScaler:Set(textureRatio / rectRatio,1.0);
        else
          vertexScaler:Set(1.0,1.0);
        end
      else
        local first_texture_ratio = first_texture_size:x() / first_texture_size:y();
        if first_texture_ratio > rectRatio then
          first_texture_scale:Set(1.0,rectRatio / first_texture_ratio);
        elseif first_texture_ratio < rectRatio then
          first_texture_scale:Set(first_texture_ratio / rectRatio,1.0);
        else
          first_texture_scale:Set(1.0,1.0);
        end
        local first_cut_size = rect_size * first_texture_scale;
        local first_cut_ratio = first_cut_size:x()/first_cut_size:y();
        if textureRatio > first_cut_ratio then
          vertexScaler:Set(1.0,first_cut_ratio / textureRatio);
        elseif textureRatio < first_cut_ratio then
          vertexScaler:Set(textureRatio / first_cut_ratio,1.0);
        else
          vertexScaler:Set(1.0,1.0);
        end
        vertexScaler = vertexScaler * first_texture_scale;
        local finalsize = rect_size * vertexScaler;
      end
    end
  end
  self.quad_clip:SetParameter(apolloengine.ShaderEntity.VERTEX_SCALER,vertexScaler);
  self.quad_blit:SetParameter(apolloengine.ShaderEntity.VERTEX_SCALER,mathfunction.vector2(1.0,1.0));
end

function custom_texture_blit_target:GetCustomTextureResult()
  return self.blit_clip_tex;
end


return custom_texture_blit_target;