
local basedetect = require "videodecet.basevideodetect";
local apollonode = require "apolloutility.apollonode"
local filterqueue = require "apolloutility.filterqueue" 
--local Cover = require "photomood.cover"

local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local videodecet = require "videodecet"
local likeapp = require "likeapp"
local Object = require "classic"



local CustomTexture = {}

function CustomTexture:Initialize()
  self.customtexture_map = {};
  self.customtexture_size = {};
  self.firsttexture_size = mathfunction.vector2(720,960);
  self.isNew = true;
end

function CustomTexture:Clear()
  self.customtexture_map = {};
  self.customtexture_size = {};
  self.firsttexture_size = nil;
end





function CustomTexture:GetCustomTexture(id)
  local isCustomTextureChanged = likeapp.AI:IsCustomTextureChanged(id);
  
  if self.isNew == true or isCustomTextureChanged == true then
    local ts = likeapp.AI:GetCustomTexture(id);
    if ts then
      local custom_texture = apolloengine.TextureEntity();
      custom_texture:PushMetadata(
      apolloengine.TextureBufferMetadata(
          apolloengine.TextureEntity.TU_STATIC,
          1, false,
          apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
          apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
          apolloengine.TextureEntity.TF_LINEAR,
          apolloengine.TextureEntity.TF_LINEAR,
          ts));
      custom_texture:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
      custom_texture:CreateResource();
      self.customtexture_map[id] = custom_texture;  --保存用户纹理
      
      local customtexture_size = ts:GetSize();
      --获取第一张图片的尺寸
      local first_texture_stream = likeapp.AI:GetCustomTexture(1);
      if first_texture_stream then
        self.firsttexture_size = first_texture_stream:GetSize();
        --LOG("get first texture size :" .. first_texture_stream:GetSize():x() .. "__" .. first_texture_stream:GetSize():y());
      end
      if self.customtexture_size[id] == nil or  self.customtexture_size[id] ~= customtexture_size then
        LOG("ResetCustomFilter");
        --filterqueue:ResetCustomFilter(ts:GetSize()); 
        --Cover:Update(customtexture_size);  --新加载的资源或者图片大小变了更新一次
      end
      self.customtexture_size[id] =  ts:GetSize();  --保存用户纹理大小
      self.isNew = false;
    else
      ERROR("Custom texture is null");
    end
  end
  return self.customtexture_map[id],self.customtexture_size[id],self.firsttexture_size;
end



return CustomTexture;



