local venuscore = require "venuscore"
local mathfunction = require "mathfunction"
local math = require "math"
local apolloengine = require "apolloengine"
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"
local filterqueue = require "apolloutility.filterqueue"
local defined = require "apolloutility.defiend"
local splicehistoricalframe = require "historicalframe.splicehistoricalframe"
local os = require "os"
local videodetect = require "videodecet"

local interlacemain={};

local Stored_Frame_Size = mathfunction.vector2(180, 320);
local Stored_Frame_Num = 60;
local Frequency = 1;
local Sequence = -4000;
local Cycle_Frame_Size = 240;

local MAX_SUPPORT_TEX_NUM = 4;

function interlacemain:Initialize(cameraLayer, config)
  self.cameraLayer = cameraLayer
  self.maincamera = renderqueue:GetCamera(cameraLayer);
  if self.maincamera == nil then
    return;
  end
  
  self.splice = splicehistoricalframe(self.maincamera, Stored_Frame_Num, Sequence, Frequency, defined.blit_material_path, Stored_Frame_Size);
  self.config = config;
  
  self.cycle_frame_size = Cycle_Frame_Size;
  self.frame_id = 0;

  self.post = apollonode.PostEffect();
  self.post:CreateResource("comm:script/apolloutility/posteffect/interlace.lua");
  
  local interlace_mode = config.interlace_mode or 1.0;
  local resolution = self.maincamera:GetCameraResolution();
  if interlace_mode > 0.0 then
    self:CreateInterlaceOffsetTex(resolution:y(), config.history_frame_size);
  else
    self:CreateInterlaceOffsetTex(resolution:x(), config.history_frame_size);
  end
  
  local material_path = venuscore.IFileSystem:PathAssembly("comm:documents/material/interlace.material");
  if not (self:SetShaderParameters(material_path, config)) then
    self:Clear();
    return;
  end  
  self.maincamera:AttachPostEffect(self.post);
  
  --self.splice:SetShow(true);
end

function interlacemain:CreateInterlaceOffsetTex(size, history_frame_size)
  local texstream = apolloengine.TextureStream();
  texstream:SetStreamType(
    mathfunction.vector2(size,1),
    apolloengine.TextureEntity.PF_L8);
  math.randomseed(tostring(os.time()):reverse():sub(1, 6));
  for u=1, size do
    local rand = math.random(0, history_frame_size);
    texstream:SetPixel(u, 1, mathfunction.vector1(rand));
  end
  
  local tex = apolloengine.TextureEntity();
  tex:PushMetadata(apolloengine.TextureBufferMetadata(
      apolloengine.TextureEntity.TU_STATIC,
      1, false,
      apolloengine.TextureEntity.TW_REPEAT,
      apolloengine.TextureEntity.TW_REPEAT,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      texstream));
  tex:CreateResource();
  self.interlace_offset_tex = tex;
end

function interlacemain:Clear()
  self.post = nil;
  self.splice:Clear();
  self.splice = nil;  
end

function interlacemain:SetShaderParameters(material_path, config)
  self.post:RegisterParameter("FRAME_SIZE", material_path);
  self.post:RegisterParameter("CUR_FRAME_ID", material_path);
  self.post:RegisterParameter("TIME_FACTOR", material_path);
  self.post:RegisterParameter("WAVE_FACTOR", material_path);
  self.post:RegisterParameter("INTERLACE_MODE", material_path);
  self.post:RegisterParameter("ROW_FRAME_NUM_PER_TEX", material_path);
  self.post:RegisterParameter("COL_FRAME_NUM_PER_TEX", material_path);
  self.post:RegisterParameter("INTERLACE_OFFSET_TEX", material_path);

  if ( self.splice.bigtexnum  > MAX_SUPPORT_TEX_NUM) then
    return false;
  end
    
  for i = 1, self.splice.bigtexnum do
    self.post:RegisterParameter("HISTORICAL_FRAME"..i, material_path);
  end

  self.post:FRAME_SIZE(mathfunction.vector1(self.splice.framNum));  
  self.post:CUR_FRAME_ID(mathfunction.vector1(0));  

  local interlace_mode = config.interlace_mode or 1.0;
  self.post:INTERLACE_MODE(mathfunction.vector1(interlace_mode));
  
  self.post:TIME_FACTOR(mathfunction.vector1(0.0));
  
  local wave_factor = config.wave_factor or 0.0;
  self.post:WAVE_FACTOR(mathfunction.vector1(wave_factor));
  
  local row_frames = self.splice.wcount;  
  self.post:ROW_FRAME_NUM_PER_TEX(mathfunction.vector1(row_frames));
  
  local col_frames = self.splice.hcount;
  self.post:COL_FRAME_NUM_PER_TEX(mathfunction.vector1(col_frames));   
  
  self.post:INTERLACE_OFFSET_TEX(self.interlace_offset_tex);  
  
  return true;
end

function interlacemain:Update(def)
  if self.splice == nil then
    return;
  end
  
  --local tex = videodetect:GetVideoTexture();
  local tex = renderqueue:GetTexture(renderqueue:GetLink(self.cameraLayer))
  if tex == nil then
    return;
  end
  
  self.splice:SetVideoTexture(tex);
  self.splice:SetShow(true);
  self.tex,self.newframe,self.isGetEnoughFrame,self.isBegin= self.splice:Update();
  self:SetShow(self.isBegin);

  if self.isBegin == true then
    self.post:CUR_FRAME_ID(mathfunction.vector1(self.newframe - 1));

    for i = 1, #self.tex do
      self.post["HISTORICAL_FRAME"..i](self.post, self.tex[i]);
    end 
  end
  
  local time_factor = (self.frame_id % self.cycle_frame_size) / self.cycle_frame_size;
  self.post:TIME_FACTOR(mathfunction.vector1(time_factor));
  self.frame_id = self.frame_id + 1;
end

function interlacemain:Exit()
  self.maincamera:DetachPostEffect(self.post);
  self:Clear();
end

function interlacemain:SetShow(show)
  if self.post then
    if show then
      self.post:Enable()
    else
      self.post:Disable()
    end
  end
end

return interlacemain;