local textureloader = require "apolloutility.asynctexture.textureloader"
local GestureAnimation = require "gesturemagic.gestureanimation"
local renderqueue = require "apolloutility.renderqueue"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local videodecet = require "videodecet"
local facecute = require "facecute"
require "venusdebug"
require "utility"



local main = {}

g_callbackhandle = main;

function main:Timespan()
  local now = venuscore.ITimerSystem:GetTimevalue();
  local def = now - self.begintime;
  self.begintime = now;

  self.cumtime = self.cumtime + def;
  self.fps = self.fps + 1;

  if self.cumtime > 5 then
    local fps = self.fps / self.cumtime;
    self.fps = 0;
    self.cumtime = 0;
    LOG("FPS "..fps);
  end
  return def;
end

function main:CreateCameras(fbo, texture, near, far, pos, lookat, up)  
  self.maincamera = apolloengine.RenderCamera();--新建摄像机
  --self.maincamera:CreatePerspectiveProjection(near, far);
  self.maincamera:CreateRealCameraProjection(near, far);--设置摄像机
  self.maincamera:LookAt(pos, lookat, up);
  
  if _PLATFORM_ANDROID then
    LOG("platform android, fbo:"..fbo);
    self.rendertarget = apolloengine.RenderTargetEntity();--创建一个FBO
    self.rendertarget:PushMetadata(--设置FBO格式
    apolloengine.RenderTargetResourceMetadata(
      apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
      apolloengine.RenderTargetEntity.ST_SWAP_D,--标记作用，主要用于底层资源共享
      mathfunction.Color(0.0,1.0,1.0,1),--清屏颜色
      apolloengine.Framework:GetResolution(),--分辨率
      fbo));
    self.outputtexture = self.rendertarget:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);--增加color0纹理
    self.outputtexture:PushMetadata(--创建纹理
				apolloengine.TextureResourceMetadata(
					apolloengine.Framework:GetResolution(),
					texture));
    self.rendertarget:CreateResource();
    self.maincamera:AttachRenderTarget(self.rendertarget);    
  end
  self.maincamera:Activate();--激活主摄像机
end

--size,video表示视屏纹理尺寸和id,size为table
function main:Initialize(fbo, texture, size, video)
  _COROUTINES_ON();
  --初始化服务回掉注册体系
  self.servicecallbacks = {}
  textureloader:Initialize();
  self:CreateCameras(
    fbo, texture,
    0.1, 10,
    mathfunction.vector3(0,0,0),
		mathfunction.vector3(0,0,-1),
		mathfunction.vector3(0,1,0));
  --renderqueue:Initialize(self.maincamera);  

  self.gestureanimation = GestureAnimation();
  self.gestureanimation:Load("docs:bodyeffect/testbehavior.json");

  --设置同步更新事件，这个事件会阻塞渲染线程，可以在这个线程中做资源读取等操作
  --但是这个事件也会大大降低帧率
  apolloengine.Framework:AddSynchronizeUpdateCallback(self._Agent, "Update");
  
  apolloengine.Framework:AddTouchCallback(self._Agent, "OnTouch");
 
  self.begintime = venuscore.ITimerSystem:GetTimevalue();
  self.cumtime = 0;
  self.fps = 0;
  
  LOG("initialize done");
  _COROUTINES_OFF();
  return true;
end
local isload = false;
function main:OnTouch(touchinfo)
  local vec2 = touchinfo:GetTouchPoint(1);
  self.gestureanimation:SetSimulateActionPoint(vec2);
end

function main:SetFaces(inputs)
  videodecet:SetFaces(inputs);
end

function main:RegisterCallback(func)
  table.insert(self.servicecallbacks, func);
  return self._Agent, #self.servicecallbacks;
end

function main:CallbackFunction(index, ...)
  _COROUTINES_ON();
  local func = self.servicecallbacks[index];
  local res = func(...);
  _COROUTINES_OFF();
  return res;
end

function main:Update()
  _COROUTINES_ON();
  local def = self:Timespan();
  self.gestureanimation:Update();
  _COROUTINES_OFF();
end


function main:Abort()
  apolloengine.Framework:RemoveSynchronizeUpdateCallback(self._Agent, "Update");
  venuscore.IApplication:Abort();
end


return main;
