local Object          = require "classic"
local venusjson       = require "venusjson"
local defined         = require "facemorph.defined"
local Renderer        = require "facemorph.morphrenderer"
local venuscore       = require "venuscore"
local mathfunction    = require "mathfunction"
local videodecet      = require "videodecet"

local FaceMorph = {};

function FaceMorph:Initialize()     
  self.renderer   = nil;  
end

--Load Config file
function FaceMorph:LoadConfig(config_file)
  local errorMsg = "FaceMorph:LoadConfig failed for: ";
  
  local rootconfig = venusjson.LaodJsonFile(config_file);
  if (rootconfig == nil)
  then
    LOG(errorMsg.."Can not load config file ".. config_file);
    return false;
  end
  
  local morph = rootconfig.morph;
  if (morph == nil)
  then
    LOG(errorMsg.."Do not have morph entry ".. config_file);
    return false;
  end
  
  self.defaultMorphInterval = morph.default_morph_time or 3000;
  self.defaultShowInterval = morph.default_show_time or 1000;
  self:InitRenderer(self.defaultMorphInterval, self.defaultShowInterval); 
  
  --videodecet:SetShow(false);
end

function FaceMorph:ReleaseResource()
  self.renderer:Clear();
  self.renderer  = nil;
  
  --videodecet:SetShow(true);
end

function FaceMorph:DoMorph(indiceslist, showtimelist, transtimelist)
  if self.renderer == nil
  then
    return false;
  end

  return self.renderer:InitMorph(indiceslist, showtimelist, transtimelist);  
end

function FaceMorph:Update(def)
  if self.renderer ~= nil 
  then
    self.renderer:Update(def);
  end
end

function FaceMorph:SetFboSize(size)
  if (self.renderer ~= nil)
  then 
    self.renderer:SetFboSize(size); 
  end
end

function FaceMorph:GetMorphTex()
  if (self.renderer ~= nil)
  then 
    return self.renderer:GetMorphTex(); 
  end
end

--增加了个函数
function FaceMorph:InitRenderer(defaultMorphInterval,defaultShowInterval)
  self.renderer = Renderer(defaultMorphInterval, defaultShowInterval);
end

function FaceMorph:SetMorphTextureInfos(tslist, landmarkinfo)
  if self.renderer ~= nil
  then
    self.renderer:SetMorphTextureInfos(tslist, landmarkinfo);
  end
end

function FaceMorph:_LoadTemplate(template)
  if self.renderer == nil or template == nil
  then 
    return nil;
  end  

  local _image = template.image;
  local _landmarkFile = template.landmark;
  local _tex = self.renderer:LoadTexture(_image);
  local _landmarks = self:_ReadLandmarks(_landmarkFile);
  if (_tex == nil or _landmarks == nil)
  then
    ERROR("Check the input template.");
    return nil;
  end
  
  if (#_landmarks ~= (defined.NUM_FACE_LAMDMARK + defined.NUM_FOREHEAD_LANDMARK) * 2)
  then
    ERROR("Check the landmark file ".._landmarkFile);
    return nil;
  end

  --local imageStream = _tex:GetSourceStream();
  local imageTex = _tex;
  local landmarks = _landmarks;

  return imageTex, landmarks; 
end

function FaceMorph:_ReadLandmarks(path)
  if (path == nil ) 
  then 
    return nil;
  end
  
  if not venuscore.IFileSystem:isFileExist(path) then
    ERROR("landmark file:" .. path .. " not exist");
    return nil;
  end
  
  local str = venuscore.IFileSystem:ReadFile(path);
  local landmarks = {}
  -- skip the indices
  local i = 1;
  for p in string.gmatch(str, "%S+")
  do
    if (i % 3 ~= 1)
    then
      table.insert(landmarks, p);
    end
    i = i + 1;
  end
  
  return landmarks;
end

return FaceMorph;