local renderqueue = require "apolloutility.renderqueue"
local venusjson = require "venusjson"
local Object = require "classic"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local physicspaser = Object:extend();

function physicspaser:new(phyxConfigPath,model,headnode)
    self.model = model;
    self.headnode = headnode;
    self.rigidBodies = {};
    self.joints = {};
    
    self.phyxConfig = nil;

    
    self.renders = {};
    self.nodes = {};
    self.trans = {};

    self:SetupPhysxToModel(phyxConfigPath,model,headnode);
    self.isenable = false;

end

function physicspaser:findNode(name)
    local joint = nil;
    if self.model==nil then
        return joint;
    end
    local skeletonComponent = self.model.skeletonNode.skeleton;
    if name == "head" then
        joint = self.headnode;
    else
        joint = skeletonComponent:GetJoint(name);
    end 
    return joint;
end;

function physicspaser:AttachDebugRender(joint)
    local node = apolloengine.Node();
    local cube = apolloengine.RenderComponent();
    local trans = apolloengine.TransformComponent()
    cube:PushMetadata(
      apolloengine.RenderObjectMaterialMetadata(
        apolloengine.PathMetadata("comm:documents/material/lightingonly.material")));  
    cube:PushMetadata(
          apolloengine.RenderObjectMeshFileMetadate("comm:documents/model/cube.mesh"));  
    cube:CreateResource();
    node:AttachComponent(trans);
    node:AttachComponent(cube);
    joint:AttachNode(node);
    trans:SetLocalScale(mathfunction.vector3(0.02,0.02,0.02));
    trans:SetLocalPosition(mathfunction.vector3(0,0,0));

    table.insert(self.renders, cube);
    table.insert(self.nodes, node);
    table.insert(self.trans, trans);
  end

function physicspaser:SetupPhysxToModel(phyxConfigPath,model,headnode)
    self.model = model;
    local skeletonComponent = model.skeletonNode.skeleton;
    self.phyxConfig = venusjson.LaodJsonFile(phyxConfigPath);

    if self.phyxConfig.cull == true then
        renderqueue:After(model);  
    else
        renderqueue:Before(model);  
    end

    local RigidsCfg = self.phyxConfig.rigidBody;
  
    local rigidNodes = {};
    for _, perCfg in ipairs(RigidsCfg) do
        local joint = self:findNode(perCfg.joint );

        local size ,shape;
        if perCfg.shape==1 then
            size = mathfunction.vector3(perCfg.size[1],perCfg.size[2],perCfg.size[3]);
            shape = apolloengine.BoxShape(size);
        elseif perCfg.shape==2 then
            --size = mathfunction.vector3(perCfg.size[1],perCfg.size[2],perCfg.size[3]);
            shape = apolloengine.CapsuleShape(perCfg.size[1],perCfg.size[2]);
        end

        local rigid = apolloengine.RigidBodyComponent();
      
        rigid:Initialize(shape, perCfg.mass); 
        
        if perCfg.kinematic==true then
            rigid:SetKinematic();
        end

        joint:AttachComponent(rigid); 

       --[[ if perCfg.joint~="head" then
            self:AttachDebugRender(joint); 
        end]]
        rigid:DisableCollision();
        rigid:DisableSimulation();
        table.insert(self.rigidBodies, rigid);
        table.insert(rigidNodes, joint);
    end

    local springJointCfg = self.phyxConfig.springJoint;
    local configJointCfg = self.phyxConfig.configJoint;
    if  springJointCfg~=nil  then
        for _, perCfg in ipairs(springJointCfg) do
            local joint1 = rigidNodes[perCfg.jointA];
            local joint2 = rigidNodes[perCfg.jointB];
    
            local stiffLinear = mathfunction.vector3( perCfg.stiffLinear[1],perCfg.stiffLinear[2],perCfg.stiffLinear[3]);
            local stiffAngular = mathfunction.vector3(perCfg.stiffAngular[1],perCfg.stiffAngular[2],perCfg.stiffAngular[3]);
            local dampingLinear = mathfunction.vector3(perCfg.dampingLinear[1],perCfg.dampingLinear[2],perCfg.dampingLinear[3]);
            local dampingAugular = mathfunction.vector3(perCfg.dampingAngular[1],perCfg.dampingAngular[2],perCfg.dampingAngular[3]);
            local linearLow = mathfunction.vector3(perCfg.LinearLow[1],perCfg.LinearLow[2],perCfg.LinearLow[3]);
            local linearHigh = mathfunction.vector3(perCfg.LinearHigh[1],perCfg.LinearHigh[2],perCfg.LinearHigh[3]);
            local angularLow = mathfunction.vector3(perCfg.AngularLow[1],perCfg.AngularLow[2],perCfg.AngularLow[3]);
            local angularHigh = mathfunction.vector3(perCfg.AngularHigh[1],perCfg.AngularHigh[2],perCfg.AngularHigh[3]);
          
    
            local spring = apolloengine.SpringJointComponent();
            joint1:AttachComponent(spring);
             table.insert(self.joints, spring);
            spring:ConnectBody(joint2);--约束是限制connect的这个物体的
            spring:SetStiffness(stiffLinear,stiffAngular);
            spring:SetDamping(dampingLinear,dampingAugular);
            spring:SetLinearLimit(linearLow,linearHigh);
            spring:SetAngularLimit(angularLow,angularHigh);
            spring:SetEquilibriumPoint(); 
        end
    end
    if  configJointCfg~=nil  then
        for _, perCfg in ipairs(configJointCfg) do
            local joint1 = rigidNodes[perCfg.jointA];
            local joint2 = rigidNodes[perCfg.jointB];

            local linearLow = mathfunction.vector3(perCfg.LinearLow[1],perCfg.LinearLow[2],perCfg.LinearLow[3]);
            local linearHigh = mathfunction.vector3(perCfg.LinearHigh[1],perCfg.LinearHigh[2],perCfg.LinearHigh[3]);
            local angularLow = mathfunction.vector3(perCfg.AngularLow[1],perCfg.AngularLow[2],perCfg.AngularLow[3]);
            local angularHigh = mathfunction.vector3(perCfg.AngularHigh[1],perCfg.AngularHigh[2],perCfg.AngularHigh[3]);
        

            local spring = apolloengine.ConfigurableJointComponent();
            joint1:AttachComponent(spring);
            table.insert(self.joints, spring);
            spring:ConnectBody(joint2);--约束是限制connect的这个物体的
            spring:SetLinearLimit(linearLow,linearHigh);
            spring:SetAngularLimit(angularLow,angularHigh);
        end
    end
   
end

function physicspaser:AttachNode(nodeA,nodeB)

    local transformcom = nodeB:GetComponent(apolloengine.Node.CT_TRANSFORM)

    local worldpos = transformcom:GetWorldPosition();
    local worldquat = transformcom:GetWorldRotation();
    nodeA:AttachNode(nodeB);
    transformcom:SetWorldPosition(worldpos);
    transformcom:SetWorldRotation(worldquat);
end

function physicspaser:DetachNode(nodeA,nodeB)
    local transformcom = nodeB:GetComponent(apolloengine.Node.CT_TRANSFORM)
    local worldpos = transformcom:GetWorldPosition();
    local worldquat = transformcom:GetWorldRotation();
    nodeA:DetachNode(nodeB);
    transformcom:SetWorldPosition(worldpos);
    transformcom:SetWorldRotation(worldquat);
end


function physicspaser:DisablePhysics()
    if self.isenable ==false then
        return;
    end
    self.isenable =false;
    local skeletonComponent = self.model.skeletonNode.skeleton;

    local RigidsCfg = self.phyxConfig.rigidBody;
    for _, perCfg in ipairs(RigidsCfg) do
        if perCfg.disableAnimation then
            skeletonComponent:SetBoneAnimationMask("take 001",perCfg.joint,1.0);
         end
    end

    for _, rigidbody in ipairs( self.rigidBodies) do
        rigidbody:DisableCollision();
        rigidbody:DisableSimulation();
    end

    local springJointCfg = self.phyxConfig.springJoint;
    if  springJointCfg~=nil then
        for _, perCfg in ipairs(springJointCfg) do
            if perCfg.breakJointBParent~=nil then
                local nodep = self:findNode(perCfg.breakJointBParent[1]); 
                local nodec = self:findNode(perCfg.breakJointBParent[2]); 
                self:AttachNode(nodep,nodec);
            end
        end
    end
   
    local configJointCfg = self.phyxConfig.configJoint;
    if  configJointCfg~=nil then
        for _, perCfg in ipairs(configJointCfg) do
            if perCfg.breakJointBParent~=nil then
                local nodep = self:findNode(perCfg.breakJointBParent[1]); 
                local nodec = self:findNode(perCfg.breakJointBParent[2]); 
                self:AttachNode(nodep,nodec);
            end
        end
    end
end


function physicspaser:EnablePhysics()
    if self.isenable ==true then
        return;
    end
    self.isenable =true;
    self.model:Reset(0);
    self.model:UpdateAnimation(0);
    local skeletonComponent = self.model.skeletonNode.skeleton;

    local RigidsCfg = self.phyxConfig.rigidBody;
    for _, perCfg in ipairs(RigidsCfg) do
        if perCfg.disableAnimation then
            skeletonComponent:SetBoneAnimationMask("take 001",perCfg.joint,0.0);
        end
    end

    for _, rigidbody in ipairs( self.rigidBodies) do
        rigidbody:EnableCollision();
        rigidbody:EnableSimulation();
        rigidbody:CleanMotion();
    end

    local springJointCfg = self.phyxConfig.springJoint;
    if  springJointCfg~=nil then
        for _, perCfg in ipairs(springJointCfg) do
            if perCfg.breakJointBParent~=nil then
                local nodep = self:findNode(perCfg.breakJointBParent[1]); 
                local nodec = self:findNode(perCfg.breakJointBParent[2]); 
                self:DetachNode(nodep,nodec);
            end
        end
    end
    
    local configJointCfg = self.phyxConfig.configJoint;
    if  configJointCfg~=nil then
        for _, perCfg in ipairs(configJointCfg) do
            if perCfg.breakJointBParent~=nil then
                local nodep = self:findNode(perCfg.breakJointBParent[1]); 
                local nodec = self:findNode(perCfg.breakJointBParent[2]); 
                self:DetachNode(nodep,nodec);
            end
        end
    end
end

function physicspaser:OnHeadIndexChange()
    if self.isenable ==true then
        self:DisablePhysics();
        self:EnablePhysics();
        print("reset motion!")
    end

   
end

return physicspaser;