local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local defined = require "facecute.defined"
local videodecet = require "videodecet"
local renderqueue = require "apolloutility.renderqueue"
local facedefined = require "facecute.facechange.facedefined"
local b3 = require "behavior3"
local vc = require "venuscore"
local cjutil = require "cjson.util"
local cjson = require "cjson"
local behdefined = require "facecute.behavior.behdefined"
local cutebehavior = require "facecute.behavior.cutebehavior"
local particledefine = require "facecute.particle.particledefine"
local eAffector = particledefine.emitterAffector;
local eDatetype = particledefine.emitterDataType;

local particlenode = apollonode.ParticleNode:extend();

function particlenode:new(maincamera)
 self.maincamera = maincamera;
 particlenode.super.new(self);

  --self:SetShow(self, false);
 self.frames = 0;
 self.curFrame = 0;
 self.emittertype ="CPU";
 self.timespan = 0;


end


function particlenode:SetTrigger(config)
  self.triggerType = config["triggerType"];
  self.triggerLoop = config["displayFrames"];
  self.triggerDelay = config["triggerDelay"];
  if(self.triggerDelay~=nil)
  then
    self.triggerDelay = self.triggerDelay;
  end
  self.triggerStop = config["triggerStop"];
end

--像素：标准单位 = 0.00028755
local function ModelLengthToWorldLength(le)
	local val = le*0.00028755
	return val
end

local function WorldLengthToModelLength(le)
	local val = le/0.00028755
	return val
end

local function RotateXYZ(x,y,z)
    local eulerQuat = mathfunction.Quaternion();
    eulerQuat:YawPitchRoll(y, x, z);
    return eulerQuat;
end
local function Conversion_Quaternion_to_Euler(quat)

	local q0, q1, q2, q3;
	q0 = quat:w();
	q1 = quat:x();
	q2 = quat:y();
	q3 = quat:z();
	local Pitch = (math.asin(-2 * q1 * q3 + 2 * q0* q2)* 57.3); 
	local Roll = (math.atan2(2 * q2 * q3 + 2 * q0 * q1, -2 * q1 * q1 - 2 * q2* q2 + 1)* 57.3);
	local Yaw = (math.atan2(2 * (q1*q2 + q0*q3), q0*q0 + q1*q1 - q2*q2 - q3*q3) * 57.3);

end

function particlenode:GetConstValByMode(sizeconfig)
  if(sizeconfig.mode=="constant")
  then
    return {sizeconfig.constant,sizeconfig.constant};
  end
  return nil;
end

function particlenode:GetSingleCurveValByMode(curveconfig)
  if(curveconfig.mode=="curve" --[[and curveconfig.curvemultiplier==1]])
  then
    local time =curveconfig.curve.time;
    local value=curveconfig.curve.value;
    local intangent=curveconfig.curve.intangent;
    local outtangent = curveconfig.curve.outtangent;
    local length =curveconfig.curve.length;
    if(time and value and intangent and outtangent and length)
    then
       return {length,time,value,intangent,outtangent};
    else
      return nil;
    end
  end
  return nil;
end

function particlenode:AddSingleCurve(name,curveconfig,value)

  value = value and value or 1;
  local single = self:GetSingleCurveValByMode(curveconfig);
  if(single)
  then
    self:AddCurve(name);
    for i=1,single[1] do
      self:AddCurvePoint(name,"Free",single[4][i],"Free",single[5][i],mathfunction.vector2(single[2][i],single[3][i]*value));
    end
  end
end

--人头原点像素位置为：vec2(385,700)
function particlenode:ParseConfig(config,para)
  --解析配置表，读取数据，设置初始状态
  --particlenode.super.CreateResource(self,para[1] .. "/".."..".."/shuer/flower/flash.emitter");
  particlenode.super.new(self);
  self:CreateEmitter(self.emittertype);

  --local base = mathfunction.vector3(-0.0116,0.1293,-0.0304);
  --local base = mathfunction.vector3(-para["particle"].translation[1],para["particle"].translation[2],para["particle"].translation[3])
  --local pos = mathfunction.vector3(-0.0838,0.0312,0.0288);
  local angletranscof = 1/180*3.1415926;
  local eulerQuat = mathfunction.Quaternion(config.rotation[1],config.rotation[2],config.rotation[3],config.rotation[4]);
  local eulerQuatMod = mathfunction.Quaternion();
  eulerQuatMod:YawPitchRoll(0,0,90*angletranscof);
  self:SetLocalRotation(eulerQuatMod*eulerQuat);
  self:SetLocalScale(mathfunction.vector3(config.scale[1],config.scale[2],config.scale[3]));
  --local pos = mathfunction.vector3(-0.0613,0.0245,0.02901434);
  --local pos = mathfunction.vector3(self.translation[1],self.translation[2],self.translation[3]);
  --local pos = mathfunction.vector3(self.translation[1],self.translation[2],self.translation[3]);
  local pos = nil;
  --FIXME
  if(self.positionType=="HAND")
  then
     pos = mathfunction.vector3(config.translation[1],config.translation[2],-0.3);
  else
     pos = mathfunction.vector3(config.translation[1],config.translation[2],config.translation[3]);
  end
  self:SetLocalPosition(pos);
  self.localpos = pos;
  self:SetPara(config,para);
  particlenode.super.SetShow(self, false);

end
function particlenode:GetMinMaxRow(mode,brandow,rowcount,constrow)
  if(mode=="singlerow")
  then
    if(brandow)
    then
      return {0,rowcount-1};
    else
      return {constrow,constrow};
    end
  end
  return {0,0};
end

function particlenode:GetAnimMode(mode)
  if(mode=="wholesheet")
  then
    return 0;
  elseif(mode=="singlerow")
  then
    return 1;
  end
  return 0;
end

function particlenode:GetTexParaValue(uvmodule)
  if(uvmodule.mode=="wholesheet")
  then
    return uvmodule.tilex*uvmodule.tiley-1;
  elseif(uvmodule.mode=="singlerow")
  then
    return  uvmodule.tilex-1;
  end
  return 0;
end


function particlenode:parseColorMoudle(moudle)
  
  if(moudle and moudle.color)
  then 
    local res = self:GetVal(moudle.color);
    self:setRuntimeParaVal("",res);
    return;
  end
end

local DEFUALT_PARTICLE_WORLD_DEPTH = 0.1;
function particlenode:UpdateHandPosition(center)
  local ray = self.maincamera:PickRay(mathfunction.vector2(center[1], center[2]));
  local wpos = ray:GetOrigin() + ray:GetDirection() * DEFUALT_PARTICLE_WORLD_DEPTH;
  self:SetWorldPosition(wpos);
end


function particlenode:parseRotate(rotateconfig,data)
  if(rotateconfig.mode=="twoconstants")
  then
    data.mode="twoconstants";
    data.curvemultiplier = rotateconfig.curvemultiplier;
    data.constantmin = rotateconfig.constantmin;
    data.constantmax = rotateconfig.constantmax;
  end
end

function particlenode:parseRotationMoudle(moudle)
  
  if(not moudle)
  then
    return;
  end
  
  local eAffector = particledefine.emitterAffector;
  local eDatetype = particledefine.emitterDataType;
  self.separateaxes =  moudle.separateaxes;

  if(moudle.rotatex)
  then
    
   local res =  self:GetVal(moudle.rotatex);
   self:setRuntimeParaVal("RotX",res);
  end
  
  if(moudle.rotatey)
  then
   local res =  self:GetVal(moudle.rotatey);
   self:setRuntimeParaVal("RotY",res);
  end
  
  if(moudle.rotatez)
  then
    local res =  self:GetVal(moudle.rotatez);
    self:setRuntimeParaVal("RotZ",res);

  end
  
end

function particlenode:updateSpearateRoate(axisname,data)
  if(data and data.mode=="twoconstants")
  then
     local roateval = self:GetRandow( data.constantmin, data.constantmax,os.time());
     self:SetBaseParam(axisname,roateval*particledefine.arcToDegree );

  end
end




function particlenode:parseEmissionMoudle(moudle)
  if(not moudle)
  then
    return;
  end
  
  local res = self:GetVal(moudle.rateovertime);
  --res.constant = 250;
  self:SetVal(particledefine.emitterAffector.EA_PARTICLE_DENSITY,res);
end



function particlenode:GetVal(config)
  local res = nil;
  local valueType = particledefine.valueType;
  local valueTypeStr = particledefine.valueTypeStr;
  if(valueType[config.mode]==valueType.constant)
  then
    res={};
    res.mode=valueTypeStr.constant;
    res.constant= config.constant;
  elseif(config.constantmin and config.constantmax --[[valueType[config.mode]==valueType.twoconstants]])
  then
    res ={};
    res.mode =valueTypeStr.twoconstants;
    res.constantmin = config.constantmin;
    res.constantmax = config.constantmax;
  
  elseif(valueType[config.mode]==valueType.color)
  then
    res ={};
    res.mode =valueTypeStr.color;
    local clr = config.color;
    res.color = {clr[1],clr[2],clr[3],clr[4]};
  elseif(valueType[config.mode]==valueType.twocolors)
  then
    res={};
    res.mode = valueTypeStr.twocolors;
    local clrmin = config.colormin;
    local clrmax = config.colormax;
    res.colormin = {clrmin[1],clrmin[2],clrmin[3],clrmin[4]};
    res.colormax = {clrmax[1],clrmax[2],clrmax[3],clrmax[4]};
  elseif(valueType[config.mode]==valueType.twoconstants)
  then
    res ={};
    res.mode = valueTypeStr.twoconstants;
    res.constantmin = config.constantmin;
    res.constantmax = config.constantmax;
  elseif(valueType[config.mode]==valueType.curve)
  then
    res={};
    local time =config.curve.time;
    local value=config.curve.value;
    local intangent=config.curve.intangent;
    local outtangent = config.curve.outtangent;
    local length =config.curve.length;
    res.mode = valueTypeStr.curve;
    res.time = time;
    res.value = value;
    res.intangent = intangent;
    res.outtangent = outtangent;
    res.length = length;
  elseif(valueType[config.mode]==valueType.gradient)
  then
    res={};
    res.mode=valueTypeStr.gradient;
    res.gradient={};
    res.gradient.mode=config.gradient.mode;
    res.gradient.alphatimekey = config.gradient.alphatimekey;
    res.gradient.alphavalue = config.gradient.alphavalue;
    res.gradient.colortimekey = config.gradient.colortimekey;
    res.gradient.colorvalue = config.gradient.colorvalue;
  end
  return res;
end

function particlenode:SetGeneralVal(affector,res)
  
  local eAffector = particledefine.emitterAffector;
  local eDatetype = particledefine.emitterDataType;
  local config = res;
  local valueType = particledefine.valueType;
  if(valueType[config.mode]==valueType.constant)
  then
      self:AddGeneralAffector(affector,eDatetype.DST_VECTOR1,mathfunction.vector1(res.constant),mathfunction.vector1(res.constant));
  elseif(valueType[config.mode]==valueType.twoconstants)
  then
     self:AddGeneralAffector(affector,eDatetype.DST_VECTOR1,mathfunction.vector1(res.constantmin),mathfunction.vector1(res.constantmax));
  elseif(valueType[config.mode]==valueType.color)
  then
    local clrmin = config.color;
    local clrmax = config.color;
    self:AddGeneralAffector(affector,eDatetype.DST_VECTOR4,mathfunction.vector4(clrmin[1],clrmin[2],clrmin[3],clrmin[4]),
      mathfunction.vector4(clrmax[1],clrmax[2],clrmax[3],clrmax[4]));
   -- self:SetBaseParam("Alpha", clrmin);
  elseif(valueType[config.mode]==valueType.twocolors)
  then
    local clrmin = config.colormin;
    local clrmax = config.colormax;
    self:AddGeneralAffector(affector,eDatetype.DST_VECTOR4,mathfunction.vector4(clrmin[1],clrmin[2],clrmin[3],clrmin[4]),
      mathfunction.vector4(clrmax[1],clrmax[2],clrmax[3],clrmax[4]));
  elseif(valueType[config.mode]==valueType.curve)
  then
    local le = res.length;
    self:AddCurve(affector);
    if(res.intangent and res.outtangent)
    then
      local single = {res.length,res.time,res.value,res.intangent,res.outtangent};
      for i=1,le do
        self:AddCurvePoint(affector,"Free",single[4][i],"Free",single[5][i],mathfunction.vector2(single[2][i],single[3][i]));
      end
    end
  end
end


function particlenode:AddRunTimeSngGradient(paraname,config)
    self:AddColorGradient();
    local colorkey = config.gradient.colortimekey;
    local colorval = config.gradient.colorvalue;
    local alphakey = config.gradient.alphatimekey;
    local alphaval = config.gradient.alphavalue;
    local len = #colorkey;
    local alphalen = #alphakey;
    for i=1,len do
      self:AddColorPoint(colorkey[i],mathfunction.vector3(colorval[3*i-2],colorval[3*i-1],colorval[3*i]));
    end
    self:AddCurve("Alpha");
    for i=1,alphalen do
      self:AddCurvePoint("Alpha","Linear",0,"Linear",0,mathfunction.vector2(alphakey[i],alphaval[i]));
    end
end

function particlenode:AddRunTimeSngCurve(paraname,res)
    local le = res.length;
    self:AddCurve(paraname);
    if(res.intangent and res.outtangent)
    then
      local single = {res.length,res.time,res.value,res.intangent,res.outtangent};
      for i=1,le do
        self:AddCurvePoint(paraname,"Free",single[4][i],"Free",single[5][i],mathfunction.vector2(single[2][i],single[3][i]));
      end
    end
end

function particlenode:setRuntimeParaVal(paraname,res)
  
  if(not res)
  then
    return;
  end
  local valueType = particledefine.valueType;
  local eAffector = particledefine.emitterAffector;
  local eDatetype = particledefine.emitterDataType;
  local config = res;
  if(valueType[config.mode]==valueType.constant)
  then
    self:SetBaseParam(paraname, res.constant);
  elseif(valueType[config.mode]==valueType.twoconstants)
  then
    self:SetRandomBetween(paraname,res.constantmin,res.constantmax);
  elseif(valueType[config.mode]==valueType.curve)
  then
    self:AddRunTimeSngCurve(paraname,res);
  elseif(valueType[config.mode]==valueType.gradient)
  then
    self:AddRunTimeSngGradient(paraname,res);
  end
end


function particlenode:SetVal(affector,res)
  if(affector>=0 and affector<=14)
  then
    self:SetGeneralVal(affector,res);
  end
end

function particlenode:Getminmax(config)
  local res = nil;
  local valueType = particledefine.valueType;
  if(valueType[config.mode]==valueType.constant)
  then
    res = {config.constant,config.constant};
  elseif(config.constantmin and config.constantmax --[[config.mode=="twoconstants"]])
  then
    res = {config.constantmin,config.constantmax};
  elseif(valueType[config.mode]==valueType.color)
  then
    local clr = config.color;
    res = {mathfunction.vector4(clr[1],clr[2],clr[3],clr[4]),mathfunction.vector4(clr[1],clr[2],clr[3],clr[4])};
  elseif(valueType[config.mode]==valueType.twocolors)
  then
    local clrmin = config.colormin;
    local clrmax = config.colormax;
    res = {mathfunction.vector4(clrmin[1],clrmin[2],clrmin[3],clrmin[4]),mathfunction.vector4(clrmax[1],clrmax[2],clrmax[3],clrmax[4])};
  elseif(valueType[config.mode]==valueType.twoconstants)
  then
    res={config.constantmin,config.constantmax};
  end  
  return res;
end




function particlenode:parseStartupMoudle(moudle)
  
  local startSize = nil;

  
  startSize = self:Getminmax(moudle.startsize);
  local wscale = self:GetWorldScale();
  local eAffector = particledefine.emitterAffector;
  local eDatetype = particledefine.emitterDataType;
  if(startSize and wscale)
  then
     self:AddGeneralAffector(eAffector.EA_PARTICLE_SIZE,eDatetype.DST_VECTOR1,mathfunction.vector1(startSize[1]*wscale:x()*0.5),
       mathfunction.vector1(startSize[2]*wscale:y()*0.5));
  end
  
 
  
  local res = self:GetVal(moudle.startlifetime);
  --res.constant = 3;
  self:SetVal(eAffector.EA_PARTICLE_LIFE,res);


  res = self:GetVal(moudle.startspeed);
  --res.constant =1;
  self:SetVal(eAffector.EA_PARTICLE_SPEED,res);


  
 res = self:GetVal(moudle.startcolor);
 self:SetVal(eAffector.EA_PARTICLE_COLOR,res);

end

function particlenode:parseUVMoudle(moudle)
  if(not moudle)
  then
    return;
  end
  self.buvmoudle = true;
  --[[if(moudle)
  then
    self:SetShaderParts({"EmitterVertexCpu",
      particledefine.rendermode.billboard and particledefine.rendermode.billboard or "BillboardTransform",
      "EmitterAtlasAnimationUV",
      "VertexOutput"},{"Texture2DSampling",
      "EmitterFragmentCpu",
      "FragmentOutput"},"{ ALPAH_BLEND, ONE, ONE, ONE, ONE }");
  else
      self:SetShaderParts({"EmitterVertexCpu",
      particledefine.rendermode.billboard and particledefine.rendermode.billboard or "BillboardTransform",
      "EmitterBaseUV",
      "VertexOutput"},{"Texture2DSampling",
      "EmitterFragmentCpu",
      "FragmentOutput"},"{ ALPAH_BLEND, ONE, ONE, ONE, ONE }");
  end]]
  
  local uvmoudule = moudle;
  if(uvmoudule)
  then
    
    local frameovertime =  self: Getminmax(uvmoudule.frameovertime);
    local startframe =     self:Getminmax(uvmoudule.startframe);
    frameovertime = frameovertime and frameovertime or {0,0};
    startframe    = startframe and startframe or {0,0};
    
    
     --local minmaxrow = self:GetMinMaxRow(uvmoudule.mode,uvmoudule.randomrow,uvmoudule.tiley,uvmoudule.row);
      --[[self:AddAnimationAffector(mathfunction.vector2(uvmoudule.tilex,uvmoudule.tiley),uvmoudule.cyclecount,self.GetAnimMode(uvmoudule.mode),minmaxrow[1],
      minmaxrow[2],uvmoudule.frameovertime~="curve",uvmoudule.frameovertime.constant,uvmoudule.frameovertime.constant, 
      uvmoudule.startframe.constant,   uvmoudule.startframe.constant);]]
     local minmaxrow = self:GetMinMaxRow(uvmoudule.mode,uvmoudule.randomrow,uvmoudule.tiley,uvmoudule.row);
      self:AddAnimationAffector(mathfunction.vector2(uvmoudule.tilex,uvmoudule.tiley),uvmoudule.cyclecount,self.GetAnimMode(uvmoudule.mode),minmaxrow[1],
      minmaxrow[2],uvmoudule.frameovertime.mode~="curve",frameovertime[1],frameovertime[2], 
     startframe[1],   startframe[2]);
  end
  
  
  
  if(uvmoudule)
  then
    local res = self:GetVal(uvmoudule.frameovertime);
    local tileCount = 0;
    if(uvmoudule.mode=="singlerow")
    then
      tileCount= uvmoudule.tiley-1;
    else
      tileCount= uvmoudule.tiley*uvmoudule.tilex-1;
    end
  
    if(uvmoudule.frameovertime.mode=="curve")
    then
       for i=1,res.length  do
         res.value[i] = res.value[i]*tileCount;
       end
    end
    self:setRuntimeParaVal("AnimationFrame",res);
  end  
end


function particlenode:parseShapeMoudle(moudle)
  
  
  local eAffector = particledefine.emitterAffector;
  local eDatetype = particledefine.emitterDataType;
  local eshape =particledefine.emitterShape;
  
  if(moudle and eshape[moudle.shape]==eshape.sphere)
  then
    self:AddSphereShapeAffector(mathfunction.vector3(0.00,0.00,0.0),moudle.radius,false);
    return;
  end
  
  if(moudle and eshape[moudle.shape]==eshape.cone)
  then
    self:AddConeShapeAffector(mathfunction.vector3(0.00,0.00,0.0),moudle.radius,moudle.angle,moudle.length,moudle.arc,moudle.arc,moudle.shapespread);
    return;
  end
  
  if(moudle and eshape[moudle.shape]==eshape.sphereshell)
  then
    self:AddSphereShapeAffector(mathfunction.vector3(0.00,0.00,0.0),moudle.radius,false);
    return;
  end
  
  if(moudle==nil)
  then
    self:AddBoxShapeAffector(mathfunction.vector3(0.00,0.00,0.0),0,0,0,0);
    self.particlefollow =  true;
    --self:AddGeneralAffector(eAffector.EA_PARTICLE_POSITION_NOISE,eDatetype.DST_VECTOR3,mathfunction.vector3(-0.00,-0.00,0),mathfunction.vector3(0.00,0.00,0));
  else
    self:AddGeneralAffector(eAffector.EA_PARTICLE_POSITION_NOISE,eDatetype.DST_VECTOR3,mathfunction.vector3(-0.00,-0.00,0),mathfunction.vector3(0.00,0.00,0));
    --self:AddGeneralAffector(eAffector.EA_PARTICLE_POSITION_NOISE,eDatetype.DST_VECTOR3,mathfunction.vector3(-(moudle.radius and moudle.radius or 0),
      --  -(moudle.angle and moudle.angle or 0),-(moudle.arc and moudle.arc or 0)),mathfunction.vector3(moudle.radius,moudle.radius,eshape[moudle.shape]));
  end
end

function particlenode:parseNoiseMoudle(moudle)
  
  local eAffector = particledefine.emitterAffector;
  local eDatetype = particledefine.emitterDataType;
  if(not moudle)
  then
    return;
  end
  
  self:AddGeneralAffector(eAffector.EA_PARTICLE_AXIS_NOISE,eDatetype.DST_VECTOR3,mathfunction.vector3(0.0,0.0,0.0),mathfunction.vector3(0.0,0.0,0.0));
end

function particlenode:parseRenderMoudle(moudle,para)
 local rendermodule = moudle;

 if(rendermodule and rendermodule.psmaterialdef)
 then
   if(rendermodule.psmaterialdef.shader=="particles/additive")
   then
     self.blendstr = "{ ALPAH_BLEND, SRC_ALPHA, ONE, ONE, ONE }";
      --self.blendstr = "{ ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }";
   else
     self.blendstr = "{ ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }";
   end
 end
 
 
 
  --self:AddGeneralAffector(eAffector.EA_PARTICLE_STRETCH,eDatetype.DST_VECTOR1,mathfunction.vector1(4),mathfunction.vector1(4));
 if(rendermodule and rendermodule.rendermode)
 then
   if(rendermodule.rendermode==particledefine.strenchBillBoardName)
   then
     local strenchcof = particledefine.strenchBillBoardCof;
     local lengthscale =  rendermodule.lengthscale;
     strenchcof = lengthscale and lengthscale or strenchcof;
     self:AddGeneralAffector(eAffector.EA_PARTICLE_STRETCH,eDatetype.DST_VECTOR1,mathfunction.vector1(strenchcof),mathfunction.vector1(strenchcof));
    end
 
 end
 
 
 
  local emittervertexstr = self.particlefollow and "EmitterVertexCpuFollow" or  "EmitterVertexCpu";
  if(self.buvmoudle)
  then
    self:SetShaderParts({emittervertexstr,
      particledefine.rendermode.billboard and particledefine.rendermode.billboard or "BillboardTransform",
      "EmitterAtlasAnimationUV",
      "VertexOutput"},{"Texture2DSampling",
      "EmitterFragmentCpu",
      "FragmentOutput"}, self.blendstr);
  else
      --[[self:SetShaderParts({"EmitterVertexCpu","EmitterStertch",
      particledefine.rendermode.billboard and particledefine.rendermode.billboard or "BillboardTransform",
      "EmitterBaseUV",
      "VertexOutput"},{"Texture2DSampling",
      "EmitterFragmentCpu",
      "FragmentOutput"}, self.blendstr);]]
      
      if(rendermodule.rendermode==particledefine.strenchBillBoardName)
      then
        self:SetShaderParts({"EmitterVertexCpu","EmitterStertchAlongSpeedWorldSpace",
        "EmitterBaseUV",
        "VertexOutput"},{"Texture2DSampling",
        "EmitterFragmentCpu",
        "FragmentOutput"}, self.blendstr);
      else
        self:SetShaderParts({emittervertexstr,
        particledefine.rendermode.billboard and particledefine.rendermode.billboard or "BillboardTransform",
        "EmitterBaseUV",
        "VertexOutput"},{"Texture2DSampling",
        "EmitterFragmentCpu",
        "FragmentOutput"}, self.blendstr);
      end
  end
  self:SetTexture(para[1] .."/_metascene/" ..rendermodule.psmaterialdef.diffusemap);
end

function particlenode:parseSizeMoudle(moudle)
  
    
  if(not moudle)
  then
    return;
  end
  local res = self:GetVal(moudle.size);
  self:setRuntimeParaVal("Scale",res);
end


function particlenode:ParseVelocity(vel)
  
  if(vel.mode=="twoconstants")
  then
    local res = self:Getminmax(vel);
  end
  
end

function particlenode:parseVelocityMoudle(moudle)
  if(not moudle)
  then
    return;
  end
  
  
  
end

function particlenode:SetPara(config,para)
  
  local render = self.render;
  local particleparaconfig = para["particleparaconfig"];
  particleparaconfig = particleparaconfig and particleparaconfig or config.particlesystemrenderer.particlesystemdef;
  
  
  local startupmodule  = particleparaconfig.startup_module;
  local emissionmodule = particleparaconfig.emission_module;
  local shapemodule    = particleparaconfig.shape_module;
  local sizemodule    = particleparaconfig.size_module;
  local rotationmodule    = particleparaconfig.rotation_module;
  local rendermodule = particleparaconfig.render_module;
  local uvmoudule    = particleparaconfig.uv_module;
  local colormoudule = particleparaconfig.color_module;
  
  self:parseStartupMoudle(startupmodule);
  self:parseEmissionMoudle(emissionmodule);
  self:parseShapeMoudle(shapemodule);
  self:parseUVMoudle(uvmoudule);
  self:parseRenderMoudle(rendermodule,para);
  self:parseColorMoudle(colormoudule);
  self:parseSizeMoudle(sizemodule);
  self:parseRotationMoudle(rotationmodule);

  self:SetUp();
  self.render:SetParameter(self.globaloffsetslot, mathfunction.vector3(0,0,0));
  
end
function particlenode:Render()
  
--self:updateRotation();
--particlenode.super.AsyncUpdate(self,self.timespan);
--  if self.timespan == nil then
--    self.timespan = 0
--  end
  if(self.particlefollow)
  then
    self:SetGlobalRotation(self.trans:GetWorldTransform());
  end
  particlenode.super.Update(self, self.timespan);

end

function particlenode:SetVisible(vis)
    particlenode.super.SetShow(self,vis);
    if(not vis)
    then
       --self:SetLocalPosition(mathfunction.vector3(-100000000,-100000000,-100000000));
      self.node:Reset();
      self.node:Stop();
    else
      -- self:SetLocalPosition(self.localpos);
      self.node:Start();
    end
  
end


function particlenode:SetRenderOrder(zpos)
    --local offset = -2000;
    zpos = -zpos;
    local offset = particledefine.zposOffset;
    local bindboxV = mathfunction.Aabbox3d(mathfunction.vector3(-1,-1, offset + zpos -1),
    mathfunction.vector3(1,1,offset + zpos));
    self:SetBindBox(bindboxV);
    self:SetCull(false);
  
end



function particlenode:GetRandow(begn,endn,seed)
  math.randomseed(seed);
  local val = math.random(particledefine.randomBegin,particledefine.randomEnd);
  return begn+val/particledefine.randomEnd*(endn-begn);
end

function particlenode:SetShow(isshow)  
  if (self.triggerType==nil or 0 == self.triggerType)
  then
    particlenode.super.SetShow(self,isshow);
    if(isshow==false)
    then
      self:ReStart();
    end
  else
     if(isshow==false)
     then
       --if(self:IsOnFace())
       --then
         particlenode.super.SetShow(self,false);
         self:ReStart();
       --end
     end
  end
end


function particlenode:ReStart()
  self.curTime = 0;
  self.initMark = 0;
  self.curLoop = self.initMark;
  self.stateType = behdefined.stateType.NULL;
  self.disAction = nil;
  self.lastAction = nil;
  self.action = nil;
  self.needupd = false;
  self.curLen = nil;
  self.frames= 0;
  self.curFrame = 0;
end

function particlenode:Update(timespan, face, position, rotation, action)
  self.timespan = timespan;
  self.frames = self.frames+1;
  self.action = action;

  self.face = face;
  self.curFrame= self.curFrame+1;
  self:Render();
end

function particlenode:GetLoopFrameCount()
  return self.curFrame;
end

function particlenode:AddEvent(event)
  table.insert(self.events,event)
end

function particlenode:ResetEvent()
  self.events ={};
end

function particlenode:ResetLoopFrameCount()
  self.curFrame = 0;
end
function particlenode:GetLoopCount()
  return self.curFrame;
end

function particlenode:ResetLoopCount()
    self.curFrame = 0;
end
function particlenode:Play()
  self:SetVisible(true);
  self:Render();
end

return particlenode;