--require "venusdebug"
local apollonode = require "apolloutility.apollonode"
local deformation = require "facecute.deformation.deformation"
local deformation3 = require "facecute.deformation.deformation3"
local threesticker = require "facecute.3dsticker.threesticker"
local threesticker3 = require "facecute.3dsticker.threesticker3"
local facesticker2d = require "facecute.facesticker2d.facesticker2d"
local facesticker2d3 = require "facecute.facesticker2d.facesticker2d3"
local soundeffect = require "facecute.soundeffect.soundeffect"
local soundeffect3 = require "facecute.soundeffect.soundeffect3New"
local facechange = require "facecute.facechange.facechange"
local facechange3 = require "facecute.facechange.facechange3"
local facechangemakeup = require "facecute.facechange.facachangemakeup"
local haircolor = require "facecute.haircolor.haircolor"
local renderqueue = require "apolloutility.renderqueue"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local defined = require "facecute.defined"
local Object = require "classic"
local particle = require "facecute.particle.particle"
local particle3 = require "facecute.particle.particle3New"
local hairtarget = require "facecute.haircolor.hairrendertarget"
local EffectAgent = require "facecute.effectagent"

local show_rect = false;
local point_count = 2*4;

--作为一个独立单元每个识别出来的人头配备一个，这个数据中包含需要管理的3d模型、变形的方法
local headtarget = Object:extend();

function headtarget:new(maincamera)
  self.isshow = false;
  self.showHead = true;
  self.maincamera = maincamera;
  self.actionid = 0; --初始状态
  self.assets = {};--保存全部的资源
  self.fixupdates = {}
  setmetatable(self.fixupdates, {__mode = "v"}) --弱引用 
  self.sounds = {};--声音要全部停止
  self.head = apollonode.ModelNode();
  self.head:CreateResource(
      defined.headtarget_human_head_mesh,
      defined.headtarget_human_head_material);
  renderqueue:After(self.head);
  
  if show_rect then
    apolloengine.IGraphicSystem:Pointsize(4);
    apolloengine.ShaderEntity.POINT_COLOR = 
      apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "POINT_COLOR");
    self.rect = apollonode.PointNode();
    self.rect:CreateResource(
      point_count,
      mathfunction.vector4(0,1,0,1),
      "comm:documents/material/pointrender.material");
    self.rect:SetShow(false);
    renderqueue:After(self.rect);
  end
end

--传入数据表，解析数据3d贴纸、2d贴纸、变形器
function headtarget:ParseConfig(config, paramters)
  local res = true;
  if config.showHead ~= nil then
    self.showHead = config.showHead;
  end
  paramters["headIndex"]=self.headIndex;
  paramters["groupID"] = self.groupID
  if config.faceMorph then
    local obj = nil;
    if config["version"]=="3.0" then
      obj = facechange3(self.maincamera);
    else
      obj = facechange(self.maincamera);
    end

    res = res and obj:ParseConfig(config, paramters);
    obj:SetRootNode(self.head);
    table.insert(self.assets, obj);
  end

  self.version = config["version"];    

  if config.parts then
    local obj = nil
    if config["version"]=="3.0" then
      obj = facesticker2d3(self.maincamera);
    else
      obj = facesticker2d(self.maincamera);
    end
    
    res = res and obj:ParseConfig(config, paramters);
    obj:SetRootNode(self.head);
    table.insert(self.assets, obj);
  end
  
  if config.soundParts then
    for name, value in pairs(config.soundParts) do
      local obj = nil
      if config["version"]=="3.0" then
        obj = soundeffect3();
      else
        obj = soundeffect();
      end
      res = res and obj:ParseConfig(value, paramters);
      obj:SetRootNode(self.head);
      table.insert(self.sounds, obj);
      if config["version"]=="3.0" then
        obj = EffectAgent(obj, name)
      end
      table.insert(self.assets, obj);
    end    
  end  
  
  if config.deformations then    
    local obj = nil
    if config["version"]=="3.0" then
      obj = deformation3(self.maincamera);  
    else
      obj = deformation(self.maincamera);  
    end
    obj:ParseConfig(config,paramters);
    obj:SetRootNode(self.head);
    table.insert(self.assets, obj);
  end
  
  if config.parts3d and config.parts3d.modelList then
    local obj = nil;
    if config["version"]=="3.0" then
      obj = threesticker3();  
    else
      obj = threesticker();
    end
    res = res and obj:ParseConfig(config,paramters);
    obj:SetRootNode(self.head);
    table.insert(self.assets, obj);
  end
  
  if config.parts3d and config.parts3d.particleList then
    local len =table.getn(config.parts3d.particleList)
    for i=1,len do
      local obj = nil;
      if config["version"]=="3.0" then
        obj = particle3(self.maincamera);  
      else
        obj = particle(self.maincamera);
      end
       
      obj:ParseConfig(config.parts3d.particleList[i], paramters);
      obj:SetRootNode(self.head);
      if config["version"]=="3.0" then
        obj = EffectAgent(obj, config.parts3d.particleList[i].name)
      end
      table.insert(self.assets, obj);
    end
  end
  
  if config.change_hair_color then
    if self.headIndex == 1 then
      local boundBox = self.head:GetBindBox();
      local obj = haircolor();
      obj:ParseConfig(config.change_hair_color,paramters,boundBox);
      obj:SetRootNode(self.head);
      table.insert(self.assets,obj);
      table.insert(self.fixupdates, obj);
    end
  end
  
  self.isshow = false;

  return res;
end

--设置是否显示
function headtarget:SetShow(isshow)
  if self.isshow ~= isshow then
    self.isshow = isshow;
    if show_rect then
      self.rect:SetShow(isshow);
    end
    self.head:SetShow(isshow and self.showHead);
    for _, node in ipairs(self.assets) do
      node:SetShow(isshow);
    end  
  end
end

function headtarget:getAsset(name)
  local obj = nil
  for _,v in ipairs(self.assets) do
    obj = v:getAsset(name)
    if obj ~= nil then return obj end
  end
  return obj
end

function headtarget:ReleaseResource()
  for _, sound in ipairs(self.sounds) do
    sound:StopSound();
  end  
  self.isshow = false;
  self.showHead = true;
  self.assets = {}
  self.sounds = {}
  collectgarbage();
end

function headtarget:_UpdateRect(action)
  if show_rect and action and action[1] then
    local rt = action[1]:GetRect();
    local dw = 2/action[1].size[1];
    local dh = 2/action[1].size[2];
    local l = rt[1];
    local t = rt[2];
    local r = rt[3];
    local b = rt[4];    
    local pt = {
      {l,t}, {r,b},
      {l+dw,t}, {r+dw,b},
      {l,t+dh}, {r,b+dh},
      {l+dw,t+dh}, {r+dw,b+dh},
      };
    self.rect:Update(pt);
  end 
end

--更新人头位置
function headtarget:Update(timespan, face, position, rotation, action)
  self:_UpdateRect(action);

  self.head:SetLocalPosition(position);
  self.head:SetLocalRotation(rotation);
  for _, node in ipairs(self.assets) do
    node:Update(timespan, face, position, rotation, action);
  end  
end

function headtarget:FixUpdate()
  for _, node in ipairs(self.fixupdates) do
    node:FixUpdate();
  end  
end


function headtarget:ParseMakeupConfig(config, paramters, makeuptype)
  local res = true;
  if config.showHead ~= nil then
    self.showHead = config.showHead;
  end
  paramters["headIndex"]=self.headIndex;
  paramters["groupID"] = self.groupID
  if config.faceMorph then
    local obj = facechangemakeup(self.maincamera, makeuptype);
    res = res and obj:ParseConfig(config, paramters);
    obj:SetRootNode(self.head);
    table.insert(self.assets, obj);
  end
  self.version = config["version"];
  
  self.isshow = false;

  return res;
end

function headtarget:ReleaseMakeup(makeuptype)
  for pos, node in ipairs(self.assets) do
    if node:GetMakeuptype() == makeuptype then
      table.remove(self.assets, pos)
    end
  end
  
  if #self.assets == 0 then
    self.isshow = false;
    self.showHead = true;
    self.assets = {}
  end
  collectgarbage();
end
return headtarget;

